/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isNull", type="boolean", defaultValue="true"), @NiagaraProperty(name="value", type="BDate", defaultValue="BDate.DEFAULT")})
public class BBacnetOptionalDate
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property isNull = BBacnetOptionalDate.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property value = BBacnetOptionalDate.newProperty((int)0, (BValue)BDate.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetOptionalDate.class);

    @Generated
    public boolean getIsNull() {
        return this.getBoolean(isNull);
    }

    @Generated
    public void setIsNull(boolean v) {
        this.setBoolean(isNull, v, null);
    }

    @Generated
    public BDate getValue() {
        return (BDate)this.get(value);
    }

    @Generated
    public void setValue(BDate v) {
        this.set(value, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetOptionalDate() {
    }

    public BBacnetOptionalDate(BDate value) {
        this.setIsNull(false);
        this.setValue(value);
    }

    public boolean isNull() {
        return this.getIsNull();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        if (this.getIsNull()) {
            out.writeNull();
        } else {
            BDate date = this.getValue();
            out.writeDate(BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay()));
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        switch (tag) {
            case 0: {
                in.readNull();
                this.setBoolean(isNull, true, noWrite);
                break;
            }
            case 10: {
                BBacnetDate bacnetDate = in.readDate();
                if (bacnetDate.isAnyUnspecified() || bacnetDate.isMonthSpecial() || bacnetDate.isDayOfMonthSpecial()) {
                    throw new OutOfRangeException("Decoded BACnet date pattern in BACnetOptionalDate: " + (Object)((Object)bacnetDate));
                }
                BDate date = bacnetDate.toBDate();
                this.setBoolean(isNull, false, noWrite);
                this.set(value, (BValue)date, noWrite);
                break;
            }
            default: {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
    }

    public String toString(Context context) {
        return this.getIsNull() ? "null" : this.getValue().toString(context);
    }
}

