/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BAddListElementAction;
import com.tridium.bacnet.datatypes.BRemoveListElementAction;
import com.tridium.bacnet.datatypes.ListManipulation;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="listTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=4)
@NiagaraTopic(name="listPropertyChanged")
public class BBacnetListOf
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property listTypeSpec = BBacnetListOf.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Topic listPropertyChanged = BBacnetListOf.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetListOf.class);
    protected boolean addActions = true;
    private int asnType;
    private boolean config;
    private boolean export;
    protected static final Logger log = Logger.getLogger("bacnet");

    @Generated
    public BTypeSpec getListTypeSpec() {
        return (BTypeSpec)this.get(listTypeSpec);
    }

    @Generated
    public void setListTypeSpec(BTypeSpec v) {
        this.set(listTypeSpec, (BValue)v, null);
    }

    @Generated
    public void fireListPropertyChanged(BValue event) {
        this.fire(listPropertyChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetListOf() {
    }

    public BBacnetListOf(Type listType) {
        this.setListTypeSpec(BTypeSpec.make((Type)listType));
    }

    public void started() {
        if (this.getParent() instanceof BBacnetObject) {
            this.config = true;
        }
        if (this.getParent() instanceof BIBacnetExportObject) {
            this.export = true;
        }
        if (this.addActions) {
            if (this.get("addElement") == null) {
                BAddListElementAction addElement = new BAddListElementAction();
                addElement.setParameterTypeSpec(this.getListTypeSpec());
                this.add("addElement", (BValue)addElement, 2, noWrite);
            }
            if (this.get("removeElement") == null) {
                BRemoveListElementAction removeElement = new BRemoveListElementAction();
                removeElement.setParameterTypeSpec(this.getListTypeSpec());
                this.add("removeElement", (BValue)removeElement, 2, noWrite);
            }
        }
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (this.config || this.export || BacnetVirtualUtil.isVirtual(this)) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public final void added(Property p, Context cx) {
        super.added(p, cx);
        if (cx == noWrite) {
            return;
        }
        if (this.export) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public final void removed(Property p, BValue old, Context cx) {
        super.removed(p, old, cx);
        if (cx == noWrite) {
            return;
        }
        if (this.export) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().subscribed();
        }
        if ((vp = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            vp.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty vp;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().unsubscribed();
        }
        if ((vp = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public final ChangeListError addElements(byte[] encodedElements, Context cx) {
        ArrayList<Object> v = new ArrayList<Object>();
        int ffen = 1;
        try {
            AsnInputStream in = new AsnInputStream(encodedElements);
            int tag = in.peekTag();
            Type t = this.getListType();
            if (t.is(BIBacnetDataType.TYPE)) {
                while (tag != -1) {
                    BObject o = t.getInstance();
                    ((BIBacnetDataType)o).readAsn(in);
                    v.add((BValue)o);
                    ++ffen;
                    tag = in.peekTag();
                }
            } else {
                while (tag != -1) {
                    BSimple s = in.readAsn();
                    if (t.is(BEnum.TYPE)) {
                        s = ((BEnum)t.getInstance()).getRange().get(((BInteger)s).getInt());
                    }
                    v.add(s);
                    ++ffen;
                    tag = in.peekTag();
                }
            }
        }
        catch (AsnException e) {
            return new NChangeListError(8, new NErrorType(2, 9), ffen);
        }
        try {
            for (ffen = 0; ffen < v.size(); ++ffen) {
                this.addListElement((BValue)v.get(ffen), cx);
            }
            return null;
        }
        catch (PermissionException e) {
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
    }

    public final ChangeListError removeElements(byte[] encodedElements, Context cx) {
        ArrayList<Object> v = new ArrayList<Object>();
        int ffen = 1;
        try {
            AsnInputStream in = new AsnInputStream(encodedElements);
            int tag = in.peekTag();
            Type t = this.getListType();
            if (t.is(BIBacnetDataType.TYPE)) {
                while (tag != -1) {
                    BObject o = t.getInstance();
                    ((BIBacnetDataType)o).readAsn(in);
                    v.add((BValue)o);
                    ++ffen;
                    tag = in.peekTag();
                }
            } else {
                while (tag != -1) {
                    BSimple s = in.readAsn();
                    if (t.is(BEnum.TYPE)) {
                        s = ((BEnum)t.getInstance()).getRange().get(((BInteger)s).getInt());
                    }
                    v.add(s);
                    ++ffen;
                    tag = in.peekTag();
                }
            }
        }
        catch (AsnException e) {
            return new NChangeListError(9, new NErrorType(2, 9), ffen);
        }
        try {
            for (ffen = 1; ffen <= v.size(); ++ffen) {
                if (this.contains((BValue)v.get(ffen - 1))) continue;
                return new NChangeListError(9, new NErrorType(5, 81), ffen);
            }
            for (ffen = 0; ffen < v.size(); ++ffen) {
                this.removeListElement((BValue)v.get(ffen), cx);
            }
            return null;
        }
        catch (PermissionException e) {
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
    }

    public final boolean contains(BValue element) {
        SlotCursor c = this.getProperties();
        while (c.next()) {
            if (!c.get().equivalent((Object)element)) continue;
            return true;
        }
        return false;
    }

    public final Type getListType() {
        try {
            return this.getListTypeSpec().getResolvedType();
        }
        catch (Exception e) {
            log.info("Exception resolving list type for " + this.getName() + ":" + e.getMessage());
            return BBacnetNull.TYPE;
        }
    }

    public String toString(Context cx) {
        if (cx != null && cx instanceof BasicContext) {
            return "List of " + this.getListTypeSpec();
        }
        this.loadSlots();
        StringBuilder sb = new StringBuilder("{");
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            if (!((Property)sc.slot()).isProperty() || !sc.property().getType().getTypeSpec().equals((Object)this.getListTypeSpec()) && !sc.property().getType().is(BOrd.TYPE)) continue;
            sb.append(sc.get()).append(',');
        }
        if (sb.length() == 1) {
            return "{}";
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeAsn(AsnOutput out) {
        AsnOutput asnOutput = out;
        synchronized (asnOutput) {
            SlotCursor c = this.getProperties();
            c.next();
            block20: while (c.next()) {
                try {
                    BValue listElement = c.get();
                    if (listElement instanceof BAction) continue;
                    if (listElement instanceof BOrd) {
                        listElement = ((BOrd)listElement).get((BObject)this);
                    }
                    if (listElement != null && listElement.getType() == this.getListType()) {
                        switch (this.asnType()) {
                            case 0: {
                                out.writeNull();
                                continue block20;
                            }
                            case 1: {
                                out.writeBoolean((BBoolean)listElement);
                                continue block20;
                            }
                            case 2: {
                                out.writeUnsigned((BBacnetUnsigned)listElement);
                                continue block20;
                            }
                            case 3: {
                                out.writeSignedInteger((BInteger)listElement);
                                continue block20;
                            }
                            case 4: {
                                out.writeReal((BNumber)((BFloat)listElement));
                                continue block20;
                            }
                            case 5: {
                                out.writeDouble((BNumber)((BDouble)listElement));
                                continue block20;
                            }
                            case 6: {
                                out.writeOctetString((BBacnetOctetString)listElement);
                                continue block20;
                            }
                            case 7: {
                                out.writeCharacterString((BString)listElement);
                                continue block20;
                            }
                            case 8: {
                                out.writeBitString((BBacnetBitString)listElement);
                                continue block20;
                            }
                            case 9: {
                                out.writeEnumerated((BEnum)listElement);
                                continue block20;
                            }
                            case 10: {
                                out.writeDate((BBacnetDate)listElement);
                                continue block20;
                            }
                            case 11: {
                                out.writeTime((BBacnetTime)listElement);
                                continue block20;
                            }
                            case 12: {
                                out.writeObjectIdentifier((BBacnetObjectIdentifier)listElement);
                                continue block20;
                            }
                        }
                        ((BIBacnetDataType)listElement).writeAsn(out);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine(this.getName() + ": writeAsn: constructed data type: listElem=" + listElement + " t=" + listElement.getType() + ", list type=" + this.getListType());
                        continue;
                    }
                    log.warning(this.getName() + ": writeAsn: listElem is null or type mismatch!");
                }
                catch (Exception e) {
                    log.warning(this.getName() + ": writeAsn: Exception! " + e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        void var5_10;
        ArrayList<BSimple> v = new ArrayList<BSimple>();
        AsnInput asnInput = in;
        synchronized (asnInput) {
            while (in.peekTag() != -1) {
                BSimple listElement = null;
                switch (this.asnType()) {
                    case 0: {
                        listElement = in.readNull();
                        break;
                    }
                    case 1: {
                        listElement = BBoolean.make((boolean)in.readBoolean());
                        break;
                    }
                    case 2: {
                        listElement = in.readUnsigned();
                        break;
                    }
                    case 3: {
                        listElement = BInteger.make((int)in.readSignedInteger());
                        break;
                    }
                    case 4: {
                        listElement = BFloat.make((float)in.readReal());
                        break;
                    }
                    case 5: {
                        listElement = BDouble.make((double)in.readDouble());
                        break;
                    }
                    case 6: {
                        listElement = BBacnetOctetString.make(in.readOctetString());
                        break;
                    }
                    case 7: {
                        listElement = BString.make((String)in.readCharacterString());
                        break;
                    }
                    case 8: {
                        listElement = in.readBitString();
                        break;
                    }
                    case 9: {
                        BEnum bEnum = (BEnum)this.getListType().getInstance();
                        listElement = bEnum.getRange().get(in.readEnumerated());
                        break;
                    }
                    case 10: {
                        listElement = in.readDate();
                        break;
                    }
                    case 11: {
                        listElement = in.readTime();
                        break;
                    }
                    case 12: {
                        listElement = in.readObjectIdentifier();
                        break;
                    }
                    default: {
                        listElement = (BValue)this.getListType().getInstance();
                        ((BIBacnetDataType)listElement).readAsn(in);
                    }
                }
                if (listElement == null) continue;
                if (listElement.getType().getTypeName().equals(this.getListTypeSpec().getTypeName())) {
                    v.add(listElement);
                    continue;
                }
                throw new AsnException("Invalid data type for list element: expected=" + this.getListTypeSpec().getTypeName() + " actual=" + listElement.getType().getTypeName());
            }
        }
        int ndx = 0;
        for (BValue bValue : v) {
            String name = this.name(ndx++);
            BacUtil.setOrAdd(this, name, bValue, noWrite);
        }
        Property property = this.getProperty(this.name(ndx++));
        while (var5_10 != null) {
            this.remove((Property)var5_10, noWrite);
            Property property2 = this.getProperty(this.name(ndx++));
        }
    }

    public Property addListElement(BValue listElement, Context cx) {
        if (this.config) {
            BBacnetObject o = (BBacnetObject)this.getParent();
            o.postAsync(new ListManipulation(o, this.getPropertyInParent(), listElement, true));
            if (o.getObjectId().getInstanceNumber() == -1) {
                BacUtil.setOrAdd(this, listElement.getClass().getSimpleName() + "?", listElement, noWrite);
                return null;
            }
            o.upload(new BUploadParameters());
            return null;
        }
        if (listElement.getType().is(this.getListType())) {
            if (!this.contains(listElement)) {
                return this.add(null, listElement, cx);
            }
            return null;
        }
        if (listElement instanceof BOrd) {
            return this.add(null, listElement, 2, cx);
        }
        log.severe(this + ".addListElement:Wrong element type: this is a list of " + this.getListType().getTypeName());
        return null;
    }

    public void removeListElement(BValue listElement, Context cx) {
        BBacnetObject o;
        if (this.config && (o = (BBacnetObject)this.getParent()).getObjectId().getInstanceNumber() != -1) {
            o.postAsync(new ListManipulation(o, this.getPropertyInParent(), listElement, false));
            o.upload(new BUploadParameters());
            return;
        }
        SlotCursor c = this.getProperties();
        while (c.next()) {
            if (!c.get().equivalent((Object)listElement)) continue;
            this.remove(c.property(), cx);
            return;
        }
    }

    private int asnType() {
        Type t = this.getListType();
        this.asnType = t == BBacnetNull.TYPE ? 0 : (t == BBoolean.TYPE ? 1 : (t == BBacnetUnsigned.TYPE ? 2 : (t == BInteger.TYPE ? 3 : (t == BFloat.TYPE ? 4 : (t == BDouble.TYPE ? 5 : (t == BBacnetOctetString.TYPE ? 6 : (t == BString.TYPE ? 7 : (t == BBacnetBitString.TYPE ? 8 : (BEnum.class.isAssignableFrom(t.getTypeClass()) ? 9 : (t == BBacnetDate.TYPE ? 10 : (t == BBacnetTime.TYPE ? 11 : (t == BBacnetObjectIdentifier.TYPE ? 12 : -1))))))))))));
        return this.asnType;
    }

    private String name(int ndx) {
        String s = this.getListTypeSpec().getTypeName();
        if (ndx == 0) {
            return s;
        }
        return s + ndx;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetListOf", 2);
        out.prop((Object)"asnType", this.asnType);
        out.prop((Object)"config", this.config);
        out.prop((Object)"export", this.export);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

