/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="recipient", type="BBacnetRecipient", defaultValue="new BBacnetRecipient()"), @NiagaraProperty(name="processIdentifier", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.make(0)"), @NiagaraProperty(name="issueConfirmedNotifications", type="boolean", defaultValue="false"), @NiagaraProperty(name="timeRemaining", type="BRelTime", defaultValue="BRelTime.DEFAULT")})
public final class BBacnetEventNotificationSubscription
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property recipient = BBacnetEventNotificationSubscription.newProperty((int)0, (BValue)new BBacnetRecipient(), null);
    @Generated
    public static final Property processIdentifier = BBacnetEventNotificationSubscription.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), null);
    @Generated
    public static final Property issueConfirmedNotifications = BBacnetEventNotificationSubscription.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property timeRemaining = BBacnetEventNotificationSubscription.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEventNotificationSubscription.class);

    @Generated
    public BBacnetRecipient getRecipient() {
        return (BBacnetRecipient)this.get(recipient);
    }

    @Generated
    public void setRecipient(BBacnetRecipient v) {
        this.set(recipient, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getProcessIdentifier() {
        return (BBacnetUnsigned)this.get(processIdentifier);
    }

    @Generated
    public void setProcessIdentifier(BBacnetUnsigned v) {
        this.set(processIdentifier, (BValue)v, null);
    }

    @Generated
    public boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    @Generated
    public void setIssueConfirmedNotifications(boolean v) {
        this.setBoolean(issueConfirmedNotifications, v, null);
    }

    @Generated
    public BRelTime getTimeRemaining() {
        return (BRelTime)this.get(timeRemaining);
    }

    @Generated
    public void setTimeRemaining(BRelTime v) {
        this.set(timeRemaining, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        this.getRecipient().writeAsn(out);
        out.writeClosingTag(0);
        long processIdentifier = this.getProcessIdentifier().getLong();
        if (processIdentifier < 0L || processIdentifier > 0xFFFFFFFFL) {
            throw new IllegalStateException("BACnetEventNotificationSubscription.processIdentifier must be between zero and max Unsigned32 (inclusive); actual: " + processIdentifier);
        }
        out.writeUnsignedInteger(1, processIdentifier);
        out.writeBoolean(2, this.getIssueConfirmedNotifications());
        int minutes = this.getTimeRemaining().getMinutes();
        if (minutes < 0) {
            throw new IllegalStateException("BACnetEventNotificationSubscription.timeRemaining must be greater than or equal to zero; actual [minutes]: " + minutes);
        }
        out.writeUnsignedInteger(3, minutes);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        BBacnetRecipient recipient = new BBacnetRecipient();
        recipient.readAsn(in);
        in.skipClosingTag(0);
        BBacnetUnsigned processIdentifier = in.readUnsigned(1);
        if (processIdentifier.getLong() > 0xFFFFFFFFL) {
            throw new OutOfRangeException("BACnetEventNotificationSubscription.processIdentifier must be less than or equal to max Unsigned32; actual: " + processIdentifier.getLong());
        }
        boolean issueConfirmedNotification = in.readBoolean(2);
        int timeRemaining = in.readUnsignedInt(3);
        this.set(BBacnetEventNotificationSubscription.recipient, (BValue)recipient, noWrite);
        this.set(BBacnetEventNotificationSubscription.processIdentifier, (BValue)processIdentifier, noWrite);
        this.setBoolean(issueConfirmedNotifications, issueConfirmedNotification, noWrite);
        this.set(BBacnetEventNotificationSubscription.timeRemaining, (BValue)BRelTime.makeMinutes((int)timeRemaining), noWrite);
    }

    public String toString(Context context) {
        return this.getRecipient().toString(context) + ", processId: " + this.getProcessIdentifier().toString(context);
    }
}

