/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT_DEVICE", facets={@Facet(value="BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.DEVICE)")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT")})
public class BBacnetDeviceObjectReference
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property deviceId = BBacnetDeviceObjectReference.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT_DEVICE, (BFacets)BBacnetObjectType.getObjectIdFacets(8));
    @Generated
    public static final Property objectId = BBacnetDeviceObjectReference.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDeviceObjectReference.class);
    public static final int MAX_ENCODED_SIZE = 10;
    public static final int DEVICE_ID_TAG = 0;
    public static final int OBJECT_ID_TAG = 1;

    @Generated
    public BBacnetObjectIdentifier getDeviceId() {
        return (BBacnetObjectIdentifier)this.get(deviceId);
    }

    @Generated
    public void setDeviceId(BBacnetObjectIdentifier v) {
        this.set(deviceId, (BValue)v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetDeviceObjectReference() {
    }

    public BBacnetDeviceObjectReference(BBacnetObjectIdentifier objectId) {
        this.setObjectId(objectId);
    }

    public BBacnetDeviceObjectReference(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId) {
        this.setDeviceId(deviceId);
        this.setObjectId(objectId);
    }

    public final boolean isDeviceIdUsed() {
        return !deviceId.isEquivalentToDefaultValue(this.get(deviceId));
    }

    @Override
    public final void writeAsn(AsnOutput out) {
        if (this.isDeviceIdUsed()) {
            out.writeObjectIdentifier(0, this.getDeviceId());
        }
        out.writeObjectIdentifier(1, this.getObjectId());
    }

    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        in.peekTag();
        BBacnetObjectIdentifier deviceId = in.isValueTag(0) ? in.readObjectIdentifier(0) : BBacnetObjectIdentifier.DEFAULT_DEVICE;
        BBacnetObjectIdentifier objectId = in.readObjectIdentifier(1);
        this.set(BBacnetDeviceObjectReference.deviceId, (BValue)deviceId, noWrite);
        this.set(BBacnetDeviceObjectReference.objectId, (BValue)objectId, noWrite);
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(cx));
        if (this.isDeviceIdUsed()) {
            if (cx != null && cx.equals(nameContext)) {
                sb.append('_').append(this.getDeviceId().toString(cx));
            } else {
                sb.append(" in ").append(this.getDeviceId().toString(cx));
            }
        }
        return sb.toString();
    }

    public final String toDebugString() {
        StringBuilder sb = new StringBuilder(32);
        if (this.isDeviceIdUsed()) {
            sb.append("\n  " + this.getDeviceId().toString());
        }
        sb.append("\n  " + this.getObjectId().toString());
        return sb.toString();
    }
}

