/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetLightingCommand;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="choice", type="int", defaultValue="0", flags=4)
public class BBacnetChannelValue
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property choice = BBacnetChannelValue.newProperty((int)4, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetChannelValue.class);
    private static final int MAX_TAG = 254;
    public static final int NULL_TAG = 0;
    public static final int REAL_TAG = 1;
    public static final int ENUMERATED_TAG = 2;
    public static final int UNSIGNED_TAG = 3;
    public static final int BOOLEAN_TAG = 4;
    public static final int SIGNED_TAG = 5;
    public static final int DOUBLE_TAG = 6;
    public static final int TIME_TAG = 7;
    public static final int CHARACTERSTRING_TAG = 8;
    public static final int OCTETSTRING_TAG = 9;
    public static final int BITSTRING_TAG = 10;
    public static final int DATE_TAG = 11;
    public static final int OBJECTID_TAG = 12;
    public static final int LIGHTCOMMAND_TAG = 13;
    public static final int LIGHTCOMMAND_SUB_TAG = 0;
    private static final String NULL_VALUE_SLOT_NAME = "null";
    private static final String REAl_SLOT_NAME = "real";
    private static final String ENUMERATED_SLOT_NAME = "enumerated";
    private static final String UNSIGNED_SLOT_NAME = "unsigned";
    private static final String BOOLEAN_SLOT_NAME = "boolean";
    private static final String SIGNED_SLOT_NAME = "signed";
    private static final String DOUBLE_SLOT_NAME = "double";
    private static final String TIME_SLOT_NAME = "time";
    private static final String CHARACTER_STRING_SLOT_NAME = "characterString";
    private static final String OCTET_STRING_SLOT_NAME = "octetString";
    private static final String BIT_STRING_SLOT_NAME = "bitString";
    private static final String DATE_SLOT_NAME = "date";
    private static final String OBJECT_ID_SLOT_NAME = "objectId";
    private static final String LIGHTING_COMMAND_SLOT_NAME = "lightingCommand";
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final Map<Integer, ChoiceInfo> choiceToInfoMap = BBacnetChannelValue.makeChoiceInfoMap();
    private static final BEnumRange choiceRange = BBacnetChannelValue.makeChoiceRange();

    @Generated
    public int getChoice() {
        return this.getInt(choice);
    }

    @Generated
    public void setChoice(int v) {
        this.setInt(choice, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        BComplex parent = this.getParent();
        Property propertyInParent = this.getPropertyInParent();
        if (parent instanceof BComponent && propertyInParent != null) {
            ((BComponent)parent).changed(propertyInParent, context);
        }
    }

    public String toString(Context cx) {
        String slotName = BBacnetChannelValue.getSlotName(this.getChoice());
        return slotName != null ? lex.getText("BacnetChannelValue." + slotName) + ": " + this.get(slotName) : lex.getText("BacnetChannelValue.invalid");
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int choice = this.getChoice();
        switch (choice) {
            case 0: {
                out.writeNull();
                break;
            }
            case 1: {
                out.writeReal((BNumber)this.get(REAl_SLOT_NAME));
                break;
            }
            case 2: {
                out.writeEnumerated(((BInteger)this.get(ENUMERATED_SLOT_NAME)).getInt());
                break;
            }
            case 3: {
                out.writeUnsigned((BBacnetUnsigned)this.get(UNSIGNED_SLOT_NAME));
                break;
            }
            case 4: {
                out.writeBoolean((BBoolean)this.get(BOOLEAN_SLOT_NAME));
                break;
            }
            case 5: {
                out.writeSignedInteger((BInteger)this.get(SIGNED_SLOT_NAME));
                break;
            }
            case 6: {
                out.writeDouble((BNumber)((BDouble)this.get(DOUBLE_SLOT_NAME)));
                break;
            }
            case 7: {
                out.writeTime((BBacnetTime)this.get(TIME_SLOT_NAME));
                break;
            }
            case 8: {
                out.writeCharacterString((BString)this.get(CHARACTER_STRING_SLOT_NAME));
                break;
            }
            case 9: {
                out.writeOctetString((BBacnetOctetString)this.get(OCTET_STRING_SLOT_NAME));
                break;
            }
            case 10: {
                out.writeBitString((BBacnetBitString)this.get(BIT_STRING_SLOT_NAME));
                break;
            }
            case 11: {
                out.writeDate((BBacnetDate)this.get(DATE_SLOT_NAME));
                break;
            }
            case 12: {
                out.writeObjectIdentifier((BBacnetObjectIdentifier)this.get(OBJECT_ID_SLOT_NAME));
                break;
            }
            case 13: {
                BBacnetLightingCommand lightingCommand = (BBacnetLightingCommand)this.get(LIGHTING_COMMAND_SLOT_NAME);
                out.writeOpeningTag(0);
                lightingCommand.writeAsn(out);
                out.writeClosingTag(0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid BACnetChannelValue choice: " + choice);
            }
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        Object value;
        int choice;
        block19: {
            int tag;
            block18: {
                tag = in.peekTag();
                if (tag < 0 || tag > 254) {
                    throw new AsnException("Invalid tag: " + tag);
                }
                if (!in.isApplicationTag(tag)) break block18;
                switch (tag) {
                    case 0: {
                        choice = 0;
                        value = in.readNull();
                        break block19;
                    }
                    case 1: {
                        choice = 4;
                        value = BBoolean.make((boolean)in.readBoolean());
                        break block19;
                    }
                    case 2: {
                        choice = 3;
                        value = in.readUnsigned();
                        break block19;
                    }
                    case 3: {
                        choice = 5;
                        value = in.readSigned();
                        break block19;
                    }
                    case 4: {
                        choice = 1;
                        value = in.readFloat();
                        break block19;
                    }
                    case 5: {
                        choice = 6;
                        value = BDouble.make((double)in.readDouble());
                        break block19;
                    }
                    case 6: {
                        choice = 9;
                        value = in.readBacnetOctetString();
                        break block19;
                    }
                    case 7: {
                        choice = 8;
                        value = BString.make((String)in.readCharacterString());
                        break block19;
                    }
                    case 8: {
                        choice = 10;
                        value = in.readBitString();
                        break block19;
                    }
                    case 9: {
                        choice = 2;
                        value = BInteger.make((int)in.readEnumerated());
                        break block19;
                    }
                    case 10: {
                        choice = 11;
                        value = in.readDate();
                        break block19;
                    }
                    case 11: {
                        choice = 7;
                        value = in.readTime();
                        break block19;
                    }
                    case 12: {
                        choice = 12;
                        value = in.readObjectIdentifier();
                        break block19;
                    }
                    default: {
                        throw new AsnException("Invalid tag: " + tag);
                    }
                }
            }
            if (in.isOpeningTag(0)) {
                in.skipTag();
                BBacnetLightingCommand lightingCommand = new BBacnetLightingCommand();
                lightingCommand.readAsn(in);
                in.skipClosingTag(0);
                choice = 13;
                value = lightingCommand;
            } else {
                throw new AsnException("Invalid tag: " + tag);
            }
        }
        this.removeAll(noWrite);
        this.add(BBacnetChannelValue.getSlotName(choice), (BValue)value, noWrite);
        this.setInt(BBacnetChannelValue.choice, choice, noWrite);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetChannelValue", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }

    public BValue getValue() {
        String slotName = BBacnetChannelValue.getSlotName(this.getChoice());
        return slotName != null ? this.get(slotName) : null;
    }

    private static Map<Integer, ChoiceInfo> makeChoiceInfoMap() {
        LinkedHashMap<Integer, ChoiceInfo> map = new LinkedHashMap<Integer, ChoiceInfo>();
        BBacnetChannelValue.putChoiceInfo(map, 0, NULL_VALUE_SLOT_NAME, (BValue)BBacnetNull.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 1, REAl_SLOT_NAME, (BValue)BFloat.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 2, ENUMERATED_SLOT_NAME, (BValue)BInteger.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 3, UNSIGNED_SLOT_NAME, (BValue)BBacnetUnsigned.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 4, BOOLEAN_SLOT_NAME, (BValue)BBoolean.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 5, SIGNED_SLOT_NAME, (BValue)BInteger.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 6, DOUBLE_SLOT_NAME, (BValue)BDouble.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 7, TIME_SLOT_NAME, (BValue)BBacnetTime.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 8, CHARACTER_STRING_SLOT_NAME, (BValue)BString.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 9, OCTET_STRING_SLOT_NAME, (BValue)BBacnetOctetString.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 10, BIT_STRING_SLOT_NAME, (BValue)BBacnetBitString.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 11, DATE_SLOT_NAME, (BValue)BBacnetDate.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 12, OBJECT_ID_SLOT_NAME, (BValue)BBacnetObjectIdentifier.DEFAULT);
        BBacnetChannelValue.putChoiceInfo(map, 13, LIGHTING_COMMAND_SLOT_NAME, (BValue)new BBacnetLightingCommand());
        return map;
    }

    private static void putChoiceInfo(Map<Integer, ChoiceInfo> map, int choice, String slotName, BValue defaultValue) {
        map.put(choice, new ChoiceInfo(slotName, defaultValue));
    }

    private static BEnumRange makeChoiceRange() {
        ArrayList<Map.Entry<Integer, ChoiceInfo>> entries = new ArrayList<Map.Entry<Integer, ChoiceInfo>>(choiceToInfoMap.entrySet());
        int size = entries.size();
        int[] ordinals = new int[size];
        String[] tags = new String[size];
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            ordinals[i] = (Integer)entry.getKey();
            tags[i] = SlotPath.escape((String)("BacnetChannelValue." + ((ChoiceInfo)entry.getValue()).slotName));
        }
        BFacets options = BFacets.make((String)"lexicon", (String)"bacnet");
        return BEnumRange.make(null, (int[])ordinals, (String[])tags, (int)size, (BFacets)options);
    }

    public static BEnumRange getChoiceRange() {
        return choiceRange;
    }

    public static String getSlotName(int choice) {
        if (choice < 0 || choice > 13) {
            return null;
        }
        return BBacnetChannelValue.choiceToInfoMap.get((Object)Integer.valueOf((int)choice)).slotName;
    }

    public static BValue getDefaultValue(int choice) {
        if (choice < 0 || choice > 13) {
            return null;
        }
        return BBacnetChannelValue.choiceToInfoMap.get((Object)Integer.valueOf((int)choice)).defaultValue;
    }

    private static class ChoiceInfo {
        public final String slotName;
        public final BValue defaultValue;

        public ChoiceInfo(String slotName, BValue defaultValue) {
            this.slotName = slotName;
            this.defaultValue = defaultValue;
        }
    }
}

