/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BReadFileConfig;
import com.tridium.bacnet.datatypes.BWriteFileConfig;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.FileData;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.FILE)", flags=8, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)")}, override=true), @NiagaraProperty(name="objectType", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetObjectType.FILE, BEnumRange.make(BBacnetObjectType.TYPE))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)")}, override=true), @NiagaraProperty(name="fileType", type="String", defaultValue="", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.FILE_TYPE, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="fileSize", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.make(0)", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.FILE_SIZE, ASN_UNSIGNED)")}), @NiagaraProperty(name="modificationDate", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.MODIFICATION_DATE, ASN_CONSTRUCTED_DATA)")}), @NiagaraProperty(name="archive", type="boolean", defaultValue="false", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.ARCHIVE, ASN_BOOLEAN)")}), @NiagaraProperty(name="readOnly", type="boolean", defaultValue="true", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.READ_ONLY, ASN_BOOLEAN)")}), @NiagaraProperty(name="fileAccessMethod", type="BBacnetFileAccessMethod", defaultValue="BBacnetFileAccessMethod.streamAccess", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.FILE_ACCESS_METHOD, ASN_ENUMERATED)")}), @NiagaraProperty(name="fileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=64, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IFile\"")})})
@NiagaraActions(value={@NiagaraAction(name="read", returnType="BBlob"), @NiagaraAction(name="write", parameterType="BBlob", defaultValue="BBlob.DEFAULT"), @NiagaraAction(name="readFile", parameterType="BStruct", defaultValue="new BReadFileConfig()", flags=4), @NiagaraAction(name="writeFile", parameterType="BStruct", defaultValue="new BWriteFileConfig()", flags=4)})
public class BBacnetFile
extends BBacnetObject {
    @Generated
    public static final Property objectId = BBacnetFile.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(10), (BFacets)BBacnetFile.makeFacets(75, 12));
    @Generated
    public static final Property objectType = BBacnetFile.newProperty((int)1, (BValue)BDynamicEnum.make((int)10, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetFile.makeFacets(79, 9));
    @Generated
    public static final Property fileType = BBacnetFile.newProperty((int)1, (String)"", (BFacets)BBacnetFile.makeFacets(43, 7));
    @Generated
    public static final Property fileSize = BBacnetFile.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), (BFacets)BBacnetFile.makeFacets(42, 2));
    @Generated
    public static final Property modificationDate = BBacnetFile.newProperty((int)1, (BValue)new BBacnetDateTime(), (BFacets)BBacnetFile.makeFacets(71, -1));
    @Generated
    public static final Property archive = BBacnetFile.newProperty((int)0, (boolean)false, (BFacets)BBacnetFile.makeFacets(13, 1));
    @Generated
    public static final Property readOnly = BBacnetFile.newProperty((int)1, (boolean)true, (BFacets)BBacnetFile.makeFacets(99, 1));
    @Generated
    public static final Property fileAccessMethod = BBacnetFile.newProperty((int)1, (BValue)BBacnetFileAccessMethod.streamAccess, (BFacets)BBacnetFile.makeFacets(41, 9));
    @Generated
    public static final Property fileOrd = BBacnetFile.newProperty((int)64, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    @Generated
    public static final Action read = BBacnetFile.newAction((int)0, null);
    @Generated
    public static final Action write = BBacnetFile.newAction((int)0, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Action readFile = BBacnetFile.newAction((int)4, (BValue)new BReadFileConfig(), null);
    @Generated
    public static final Action writeFile = BBacnetFile.newAction((int)4, (BValue)new BWriteFileConfig(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetFile.class);
    private static final int STREAM_ACCESS_HEADER_SIZE = 16;
    private static final int RECORD_ACCESS_HEADER_SIZE = 21;
    private static final int FILE_DATA_SAFETY_FACTOR = 10;
    private BIFile file;

    @Generated
    public String getFileType() {
        return this.getString(fileType);
    }

    @Generated
    public void setFileType(String v) {
        this.setString(fileType, v, null);
    }

    @Generated
    public BBacnetUnsigned getFileSize() {
        return (BBacnetUnsigned)this.get(fileSize);
    }

    @Generated
    public void setFileSize(BBacnetUnsigned v) {
        this.set(fileSize, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getModificationDate() {
        return (BBacnetDateTime)this.get(modificationDate);
    }

    @Generated
    public void setModificationDate(BBacnetDateTime v) {
        this.set(modificationDate, (BValue)v, null);
    }

    @Generated
    public boolean getArchive() {
        return this.getBoolean(archive);
    }

    @Generated
    public void setArchive(boolean v) {
        this.setBoolean(archive, v, null);
    }

    @Generated
    public boolean getReadOnly() {
        return this.getBoolean(readOnly);
    }

    @Generated
    public void setReadOnly(boolean v) {
        this.setBoolean(readOnly, v, null);
    }

    @Generated
    public BBacnetFileAccessMethod getFileAccessMethod() {
        return (BBacnetFileAccessMethod)this.get(fileAccessMethod);
    }

    @Generated
    public void setFileAccessMethod(BBacnetFileAccessMethod v) {
        this.set(fileAccessMethod, (BValue)v, null);
    }

    @Generated
    public BOrd getFileOrd() {
        return (BOrd)this.get(fileOrd);
    }

    @Generated
    public void setFileOrd(BOrd v) {
        this.set(fileOrd, (BValue)v, null);
    }

    @Generated
    public BBlob read() {
        return (BBlob)this.invoke(read, null, null);
    }

    @Generated
    public void write(BBlob parameter) {
        this.invoke(write, (BValue)parameter, null);
    }

    @Generated
    public void readFile(BStruct parameter) {
        this.invoke(readFile, (BValue)parameter, null);
    }

    @Generated
    public void writeFile(BStruct parameter) {
        this.invoke(writeFile, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.getFile();
    }

    @Override
    public void stopped() {
        this.file = null;
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(fileOrd)) {
            this.getFile();
        }
    }

    @Override
    public String toString(Context context) {
        return this.getObjectId().toString(context) + " local: " + this.getFileOrd();
    }

    public static byte[] readFile(BBacnetDevice device, BBacnetObjectIdentifier objectId) throws BacnetException {
        int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(device.getAddress(), objectId, 41));
        if (fileAccessMethod == 1) {
            int requestedOctetCount;
            int fileSize;
            block3: {
                fileSize = -1;
                requestedOctetCount = Integer.MAX_VALUE;
                try {
                    requestedOctetCount = fileSize = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(device.getAddress(), objectId, 42));
                }
                catch (ErrorException e) {
                    if (e.getErrorType().getErrorCode() == 122) break block3;
                    throw e;
                }
            }
            return BBacnetFile.readFileDataStream(device, objectId, fileSize, 0, requestedOctetCount);
        }
        int recordCount = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(device.getAddress(), objectId, 141));
        return BBacnetFile.readFileDataRecord(device, objectId, 0, recordCount);
    }

    public BBlob doRead() {
        BBacnetDevice device = this.device();
        if (device == null) {
            throw new BajaRuntimeException(this + ": device not found");
        }
        try {
            byte[] fileData = BBacnetFile.readFile(device, this.getObjectId());
            return BBlob.make((byte[])fileData);
        }
        catch (BacnetException e) {
            log.log(Level.SEVERE, "Unable to read file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
    }

    public void doReadFile(BStruct arg) {
        BBacnetNetwork.bacnet().postAsync(new ReadFileReq((BReadFileConfig)arg, this));
    }

    public void doWriteFile(BStruct arg) {
        BBacnetNetwork.bacnet().postAsync(new WriteFileReq((BWriteFileConfig)arg, this));
    }

    public static void writeFile(BBacnetDevice device, BBacnetObjectIdentifier objectId, byte[] fileData) throws BacnetException {
        BBacnetFile.writeFileDataStream(device, objectId, 0, fileData);
    }

    public static void writeFile(BBacnetDevice device, BBacnetObjectIdentifier objectId, int count, BBacnetOctetString[] fileRecordData) throws BacnetException {
        BBacnetFile.writeFileDataRecord(device, objectId, 0, count, fileRecordData);
    }

    public void doWrite(BBlob arg) {
        BBacnetDevice device = this.device();
        if (device == null) {
            throw new BajaRuntimeException(this + ": device not found");
        }
        byte[] fileData = arg.copyBytes();
        if (this.getFileAccessMethod() == BBacnetFileAccessMethod.streamAccess) {
            try {
                BBacnetFile.writeFileDataStream(device, this.getObjectId(), 0, fileData);
            }
            catch (BacnetException e) {
                log.log(Level.SEVERE, "Unable to write file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
                throw new BajaRuntimeException((Throwable)((Object)e));
            }
        }
        try {
            BBacnetOctetString[] fileRecordData = BBacnetFile.getFileRecordData(fileData);
            BBacnetFile.writeFileDataRecord(device, this.getObjectId(), 0, fileRecordData.length, fileRecordData);
        }
        catch (AsnException e) {
            log.severe("File data is not in array of encoded BACnetOctetStrings");
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
        catch (BacnetException e) {
            log.log(Level.SEVERE, "Unable to write file record contents for " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e), (Throwable)((Object)e));
            throw new BajaRuntimeException((Throwable)((Object)e));
        }
    }

    private BIFile getFile() {
        try {
            if (!fileOrd.isEquivalentToDefaultValue((BValue)this.getFileOrd())) {
                BObject o = this.getFileOrd().get((BObject)this);
                this.file = o instanceof BIFile ? (BIFile)o : null;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to resolve file ord for " + this + ": " + this.getFileOrd(), e);
            this.file = null;
        }
        return this.file;
    }

    private static BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    private static byte[] readFileDataRecord(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileStartRecord, int requestedRecordCount) throws BacnetException {
        if (!device.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        AsnOutputStream out = new AsnOutputStream();
        for (int i = 0; i < requestedRecordCount; ++i) {
            FileData ack = BBacnetFile.client().atomicReadFile(device.getAddress(), objectId, 1, fileStartRecord + i, 1L);
            out.writeOctetString(ack.getFileRecordData()[0]);
            if (ack.isEndOfFile()) break;
        }
        return out.toByteArray();
    }

    private static byte[] readFileDataStream(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileSize, int fileStartPosition, int requestedOctetCount) throws BacnetException {
        FileData ack;
        ByteArrayOutputStream data;
        if (!device.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        if (fileSize < 0) {
            data = new ByteArrayOutputStream();
        } else {
            data = new ByteArrayOutputStream(fileSize);
            if (fileSize < requestedOctetCount) {
                requestedOctetCount = fileSize;
            }
        }
        int lastByte = Integer.MAX_VALUE;
        if (requestedOctetCount < Integer.MAX_VALUE) {
            try {
                lastByte = Math.addExact(fileStartPosition, requestedOctetCount);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        int maxReturnableFileSize = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxReturnableFileSize) {
            maxReturnableFileSize = myMax;
        }
        maxReturnableFileSize -= 6;
        maxReturnableFileSize -= BBacnetFile.getTagSize(maxReturnableFileSize);
        int start = fileStartPosition;
        int len = maxReturnableFileSize;
        do {
            ack = BBacnetFile.client().atomicReadFile(device.getAddress(), objectId, 0, start, len);
            byte[] fileData = ack.getFileData();
            data.write(fileData, 0, fileData.length);
        } while (!ack.isEndOfFile() && (start += len) < lastByte);
        return data.toByteArray();
    }

    public static BBacnetOctetString[] getFileRecordData(byte[] fileData) throws AsnException {
        ArrayList<BBacnetOctetString> records = new ArrayList<BBacnetOctetString>();
        AsnInputStream in = new AsnInputStream(fileData);
        while (in.available() > 0) {
            records.add(in.readBacnetOctetString());
        }
        return records.toArray(new BBacnetOctetString[0]);
    }

    private static void writeFileDataRecord(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileStartRecord, int recordCount, BBacnetOctetString[] fileRecordData) throws BacnetException {
        if (!device.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        if (fileRecordData == null) {
            throw new IllegalArgumentException("fileRecordData is null!");
        }
        if (fileRecordData.length == 0) {
            BBacnetFile.client().atomicWriteFileRecord(device.getAddress(), objectId, fileStartRecord, 0L, fileRecordData);
            return;
        }
        int writeCount = recordCount;
        if (fileStartRecord + recordCount > fileRecordData.length) {
            writeCount = fileRecordData.length - fileStartRecord;
        }
        int maxApdu = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxApdu) {
            maxApdu = myMax;
        }
        int maxFileDataSize = maxApdu - 21 - 10;
        int recordIndex = fileStartRecord;
        ArrayList<BBacnetOctetString> requestRecords = new ArrayList<BBacnetOctetString>(writeCount);
        while (recordIndex - fileStartRecord < writeCount) {
            int start = recordIndex;
            requestRecords.clear();
            int recordSize = fileRecordData[recordIndex].length();
            int fileDataSize = BBacnetFile.getTagSize(recordSize) + recordSize;
            do {
                requestRecords.add(fileRecordData[recordIndex]);
            } while (++recordIndex - fileStartRecord < writeCount && (fileDataSize += BBacnetFile.getTagSize(recordSize = fileRecordData[recordIndex].length()) + recordSize) <= maxFileDataSize);
            BBacnetOctetString[] requestRecordData = requestRecords.toArray(new BBacnetOctetString[0]);
            BBacnetFile.client().atomicWriteFileRecord(device.getAddress(), objectId, start, requestRecordData.length, requestRecordData);
        }
    }

    private static void writeFileDataStream(BBacnetDevice device, BBacnetObjectIdentifier objectId, int fileStartPosition, byte[] fileData) throws BacnetException {
        int copylen;
        if (!device.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        int writeLength = fileData.length;
        int maxApdu = device.getMaxAPDULengthAccepted();
        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (myMax < maxApdu) {
            maxApdu = myMax;
        }
        int maxFileDataSize = maxApdu - 16 - 10;
        maxFileDataSize -= BBacnetFile.getTagSize(maxFileDataSize);
        int start = fileStartPosition;
        do {
            if (start + (copylen = maxFileDataSize) > writeLength) {
                copylen = writeLength - start;
            }
            byte[] reqFileData = new byte[copylen];
            System.arraycopy(fileData, start, reqFileData, 0, copylen);
            BBacnetFile.client().atomicWriteFileStream(device.getAddress(), objectId, start, reqFileData);
        } while ((start += copylen) < writeLength);
    }

    private static int getTagSize(int dataLength) {
        if (dataLength <= 4) {
            return 1;
        }
        if (dataLength <= 253) {
            return 2;
        }
        if (dataLength <= 65535) {
            return 4;
        }
        return 6;
    }

    class WriteFileReq
    implements Runnable {
        BWriteFileConfig parms;
        BBacnetFile bacnetFile;

        WriteFileReq(BWriteFileConfig arg, BBacnetFile f) {
            this.parms = arg;
            this.bacnetFile = f;
        }

        @Override
        public void run() {
            block19: {
                byte[] fileData;
                BBacnetDevice device = this.bacnetFile.device();
                if (device == null) {
                    throw new IllegalStateException("Unable to write to file because device not found: " + this.bacnetFile.getFileOrd());
                }
                int remoteStart = this.parms.getRemoteStart();
                int localStart = this.parms.getLocalStart();
                RandomAccessFile src = null;
                try {
                    if (this.bacnetFile.file == null) {
                        throw new NullOrdException("No local source file specified for BACnet File " + this.bacnetFile);
                    }
                    File f = ((BLocalFileStore)this.bacnetFile.file.getStore()).getLocalFile();
                    long flen = f.length() - (long)localStart;
                    if (flen > Integer.MAX_VALUE) {
                        throw new BajaRuntimeException("Local file data length " + flen + " is too long to write to BACnet!");
                    }
                    int len = (int)flen;
                    fileData = new byte[len];
                    src = new RandomAccessFile(f, "r");
                    src.seek(localStart);
                    src.read(fileData, 0, len);
                }
                catch (IOException e) {
                    BBacnetObject.log.log(Level.SEVERE, "IOException reading from local file " + this.bacnetFile.file, e);
                    throw new BajaRuntimeException((Throwable)e);
                }
                finally {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(device.getAddress(), this.bacnetFile.getObjectId(), 41));
                    if (fileAccessMethod == 1) {
                        BBacnetFile.writeFileDataStream(device, this.bacnetFile.getObjectId(), remoteStart, fileData);
                        break block19;
                    }
                    try {
                        BBacnetOctetString[] fileRecordData = BBacnetFile.getFileRecordData(fileData);
                        BBacnetFile.writeFileDataRecord(device, BBacnetFile.this.getObjectId(), remoteStart, fileRecordData.length, fileRecordData);
                    }
                    catch (AsnException e) {
                        BBacnetObject.log.severe("File data is not in array of encoded BACnetOctetStrings");
                        throw new BajaRuntimeException((Throwable)((Object)e));
                    }
                }
                catch (BacnetException e) {
                    BBacnetObject.log.log(Level.SEVERE, "Unable to write file record contents for " + (Object)((Object)BBacnetFile.this.getObjectId()) + ": " + (Object)((Object)e), (Throwable)((Object)e));
                    throw new BajaRuntimeException((Throwable)((Object)e));
                }
            }
        }
    }

    static class ReadFileReq
    implements Runnable {
        BReadFileConfig parms;
        BBacnetFile bacnetFile;

        ReadFileReq(BReadFileConfig arg, BBacnetFile f) {
            this.parms = arg;
            this.bacnetFile = f;
        }

        @Override
        public void run() {
            byte[] fileData;
            block19: {
                BBacnetDevice device = this.bacnetFile.device();
                if (device == null) {
                    throw new IllegalStateException("Unable to read file because device not found: " + this.bacnetFile.getFileOrd());
                }
                int start = this.parms.getStart();
                int count = this.parms.getCount();
                try {
                    int fileAccessMethod = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(device.getAddress(), this.bacnetFile.getObjectId(), 41));
                    if (fileAccessMethod == 1) {
                        int fileSize;
                        block18: {
                            fileSize = -1;
                            try {
                                fileSize = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(device.getAddress(), this.bacnetFile.getObjectId(), 42));
                            }
                            catch (ErrorException e) {
                                if (e.getErrorType().getErrorCode() == 122) break block18;
                                throw e;
                            }
                        }
                        fileData = BBacnetFile.readFileDataStream(device, this.bacnetFile.getObjectId(), fileSize, start, count);
                        break block19;
                    }
                    fileData = BBacnetFile.readFileDataRecord(device, this.bacnetFile.getObjectId(), start, count);
                }
                catch (BacnetException e) {
                    BBacnetObject.log.log(Level.SEVERE, "Unable to read file contents for " + (Object)((Object)this.bacnetFile.getObjectId()) + " : " + (Object)((Object)e), (Throwable)((Object)e));
                    throw new BajaRuntimeException((Throwable)((Object)e));
                }
            }
            RandomAccessFile out = null;
            try {
                if (this.bacnetFile.file == null) {
                    throw new NullOrdException("No local target file specified for BACnet File " + this.bacnetFile);
                }
                if (this.bacnetFile.file.isReadonly()) {
                    throw new IllegalStateException("Unable to write to file " + this.bacnetFile.getFileOrd());
                }
                File f = ((BLocalFileStore)this.bacnetFile.file.getStore()).getLocalFile();
                out = new RandomAccessFile(f, "rw");
                out.write(fileData);
            }
            catch (IOException e) {
                BBacnetObject.log.log(Level.SEVERE, "IOException writing to local file " + this.bacnetFile.file, e);
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

