/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetConfigFolder;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BLoadable;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT", flags=8, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)")}), @NiagaraProperty(name="objectName", type="String", defaultValue="", facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_NAME, ASN_CHARACTER_STRING)")}), @NiagaraProperty(name="objectType", type="BEnum", defaultValue="BDynamicEnum.make(0, BEnumRange.make(BBacnetObjectType.TYPE))", flags=1, facets={@Facet(value="makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)")})})
@NiagaraActions(value={@NiagaraAction(name="download", parameterType="BDownloadParameters", defaultValue="new BDownloadParameters()", flags=20, override=true), @NiagaraAction(name="readBacnetProperty", parameterType="BEnum", defaultValue="BDynamicEnum.make(BBacnetPropertyIdentifier.presentValue)", returnType="BValue", flags=4), @NiagaraAction(name="writeBacnetProperty", parameterType="BEnum", defaultValue="BDynamicEnum.make(BBacnetPropertyIdentifier.presentValue)", flags=4), @NiagaraAction(name="uploadRequiredProperties", flags=4), @NiagaraAction(name="uploadOptionalProperties", flags=4)})
public class BBacnetObject
extends BLoadable
implements BacnetConst,
BIBacnetPollable {
    @Generated
    public static final Property pollFrequency = BBacnetObject.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property status = BBacnetObject.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBacnetObject.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property objectId = BBacnetObject.newProperty((int)8, (BValue)BBacnetObjectIdentifier.DEFAULT, (BFacets)BBacnetObject.makeFacets(75, 12));
    @Generated
    public static final Property objectName = BBacnetObject.newProperty((int)0, (String)"", (BFacets)BBacnetObject.makeFacets(77, 7));
    @Generated
    public static final Property objectType = BBacnetObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetObject.makeFacets(79, 9));
    @Generated
    public static final Action download = BBacnetObject.newAction((int)20, (BValue)new BDownloadParameters(), null);
    @Generated
    public static final Action readBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    @Generated
    public static final Action writeBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    @Generated
    public static final Action uploadRequiredProperties = BBacnetObject.newAction((int)4, null);
    @Generated
    public static final Action uploadOptionalProperties = BBacnetObject.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetObject.class);
    private static final BIcon icon = BIcon.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    protected static final Lexicon lex = Lexicon.make((String)"bacnet");
    public static final Logger log = Logger.getLogger("bacnet.client");
    public static final Logger plog = Logger.getLogger("bacnet.point");
    private static final Map<Integer, Array<TypeInfo>> byObjectType = new HashMap<Integer, Array<TypeInfo>>();
    private static boolean initialized = false;
    private static final BRelTime WRITE_PROPS_DELAY = BRelTime.make((long)20L);
    private static final Object UPLOAD_LOCK = new Object();
    protected volatile ArrayList<PollListEntry> polledProperties = new ArrayList();
    private BBacnetConfigDeviceExt config;
    private final Map<BFacets, BacnetPropertyData> propDataMap = new HashMap<BFacets, BacnetPropertyData>();
    private final Map<PropertyWrite, PropertyWrite> writeProps = new HashMap<PropertyWrite, PropertyWrite>();
    private Clock.Ticket writePropsTicket = null;
    public static final String PID = "pId";
    public static final String ASN_TYPE = "asn";
    private static final BacnetPropertyData NOT_BACNET_PROPERTY = new BacnetPropertyData(-1, 0);

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public BEnum getObjectType() {
        return (BEnum)this.get(objectType);
    }

    @Generated
    public void setObjectType(BEnum v) {
        this.set(objectType, (BValue)v, null);
    }

    @Generated
    public BValue readBacnetProperty(BEnum parameter) {
        return this.invoke(readBacnetProperty, (BValue)parameter, null);
    }

    @Generated
    public void writeBacnetProperty(BEnum parameter) {
        this.invoke(writeBacnetProperty, (BValue)parameter, null);
    }

    @Generated
    public void uploadRequiredProperties() {
        this.invoke(uploadRequiredProperties, null, null);
    }

    @Generated
    public void uploadOptionalProperties() {
        this.invoke(uploadOptionalProperties, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BBacnetObject make(BBacnetObjectIdentifier id) {
        Array<TypeInfo> o;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((o = byObjectType.get(id.getObjectType())) != null && o.size() > 0) {
            TypeInfo element = (TypeInfo)o.get(0);
            BBacnetObject bo = (BBacnetObject)element.getInstance();
            bo.setObjectId(id);
            return bo;
        }
        return new BBacnetObject();
    }

    @Deprecated
    public static TypeInfo getTypeInfo(BBacnetObjectIdentifier id) {
        Array<TypeInfo> a;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((a = byObjectType.get(id.getObjectType())) != null) {
            return (TypeInfo)a.first();
        }
        return TYPE.getTypeInfo();
    }

    public static TypeInfo[] getTypeInfos(BBacnetObjectIdentifier id) {
        Array<TypeInfo> a;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((a = byObjectType.get(id.getObjectType())) != null) {
            return (TypeInfo[])a.trim();
        }
        return new TypeInfo[]{TYPE.getTypeInfo()};
    }

    public void started() throws Exception {
        this.checkConfig();
        this.buildPolledProperties();
        BBacnetObject obj = this.config().lookupBacnetObject(this.getObjectId());
        if (obj != null && obj != this) {
            log.severe("Duplicate Bacnet Object ID for config object " + this + " in " + this.device() + "; defaulting objectId!");
            this.setObjectId(BBacnetObjectIdentifier.make(this.getObjectType().getOrdinal()));
        }
    }

    public void stopped() throws Exception {
        try {
            BBacnetNetwork network = this.network();
            if (network != null) {
                network.getPollService(this).unsubscribe((BIPollable)this);
            }
        }
        catch (NotRunningException e) {
            log.warning("BBacnetObject.stopped:NotRunningException unsubscribing from polling on " + this);
        }
        this.polledProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        BacnetPropertyData propData;
        BBacnetNetwork network;
        super.changed(p, cx);
        if (!this.isRunning() || cx == noWrite) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork network2;
            this.removeAll(null);
            this.upload(new BUploadParameters());
            if (this.isSubscribed() && (network2 = this.network()) != null) {
                BBacnetPoll pollService = (BBacnetPoll)network2.getPollService(this);
                pollService.unsubscribe(this);
                this.buildPolledProperties();
                pollService.subscribe(this);
            }
            return;
        }
        if (p.equals(pollFrequency) && this.isSubscribed() && (network = this.network()) != null) {
            BBacnetPoll pollService = (BBacnetPoll)network.getPollService(this);
            pollService.unsubscribe(this);
            pollService.subscribe(this);
        }
        if (!Flags.isReadonly((BComplex)this, (Slot)p) && p.getFacets().getFacet(PID) != null && (propData = this.getPropertyData(p)) != NOT_BACNET_PROPERTY) {
            Map<PropertyWrite, PropertyWrite> map = this.writeProps;
            synchronized (map) {
                PropertyWrite propWrite = new PropertyWrite(propData, p);
                this.writeProps.put(propWrite, propWrite);
                if (this.writePropsTicket == null) {
                    this.writePropsTicket = Clock.schedule((BComponent)this, (BRelTime)WRITE_PROPS_DELAY, (Action)download, (BValue)new BDownloadParameters());
                }
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        BExtensibleEnumList elist;
        BBacnetDevice dev;
        if (slot.equals((Object)objectId)) {
            BExtensibleEnumList elist2;
            if (!this.isMounted()) {
                return super.getSlotFacets(slot);
            }
            BFacets f = BBacnetObjectType.getObjectIdFacets(this.getObjectType().getOrdinal());
            if (f != null) {
                return f;
            }
            BBacnetDevice dev2 = this.device();
            if (dev2 != null && (elist2 = dev2.getEnumerationList()) != null) {
                return elist2.getObjectTypeFacets();
            }
        }
        if (slot.equals((Object)objectType) && (dev = (BBacnetDevice)this.getDevice()) != null && (elist = dev.getEnumerationList()) != null) {
            return elist.getObjectTypeFacets();
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.statusFlags.getTag())) {
            return BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.eventEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.ackedTransitions.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.limitEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_LIMIT_ENABLE_FACETS;
        }
        return super.getSlotFacets(slot);
    }

    public void subscribed() {
        if (!this.isRunning()) {
            return;
        }
        BBacnetNetwork network = this.network();
        if (network != null) {
            network.getPollService(this).subscribe((BIPollable)this);
        }
        this.upload(new BUploadParameters(false));
    }

    public void unsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        BBacnetNetwork network = this.network();
        if (network != null) {
            network.getPollService(this).unsubscribe((BIPollable)this);
        }
    }

    public void doUpload(BUploadParameters p, Context cx) {
        BBacnetDevice device = this.device();
        if (device == null || !device.getEnabled() || device.getStatus().isDown()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((device != null ? device.getName() : "null") + " is either disabled or status is down, object upload is unsuccessful.");
            }
            return;
        }
        if (!this.getObjectId().isValid()) {
            return;
        }
        this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 0x10), (BFacets)BFacets.make((String)"upload", (String)"PENDING")));
        if (!device.isServiceSupported("readPropertyMultiple")) {
            this.uploadIndividual(device, new NReadAccessSpec(this.getObjectId(), this.getPropertyIds(device)));
        } else {
            boolean ok;
            block15: {
                ListIterator it;
                Vector vals;
                Vector<NReadAccessSpec> specs;
                block14: {
                    specs = new Vector<NReadAccessSpec>();
                    specs.add(new NReadAccessSpec(this.getObjectId(), 8));
                    vals = null;
                    ok = false;
                    try {
                        vals = BBacnetObject.client().readPropertyMultiple(device.getAddress(), specs);
                        if (vals == null) {
                            return;
                        }
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(device, it);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block14;
                        log.fine("Exception uploading " + this + " using rpm(ALL):" + e);
                    }
                }
                if (!ok) {
                    try {
                        specs.clear();
                        specs.add(new NReadAccessSpec(this.getObjectId(), 105));
                        vals = BBacnetObject.client().readPropertyMultiple(device.getAddress(), specs);
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(device, it);
                        specs.clear();
                        specs.add(new NReadAccessSpec(this.getObjectId(), 80));
                        vals = BBacnetObject.client().readPropertyMultiple(device.getAddress(), specs);
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(device, it);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block15;
                        log.fine("Exception uploading " + this + " using rpm(REQ/OPT):" + e);
                    }
                }
            }
            if (!ok) {
                this.uploadIndividual(device, new NReadAccessSpec(this.getObjectId(), this.getPropertyIds(device)));
            }
        }
        this.setOutputFacets();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        this.buildPolledProperties();
        this.setStatus(BStatus.ok);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(device.getName() + " object upload execution finish.");
        }
    }

    private int[] getPropertyIds(BBacnetDevice device) {
        try {
            return this.readPropertyList(device);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception reading property list for " + this + ": " + e, e);
            }
            int[] possibleProperties = device.getPossibleProperties(this.getObjectId());
            return this.removePropertyListProperty(possibleProperties);
        }
    }

    private int[] removePropertyListProperty(int[] propIds) {
        for (int i = 0; i < propIds.length; ++i) {
            if (propIds[i] != 371) continue;
            int[] newPropIds = new int[propIds.length - 1];
            System.arraycopy(propIds, 0, newPropIds, 0, i);
            System.arraycopy(propIds, i + 1, newPropIds, i, propIds.length - i - 1);
            return newPropIds;
        }
        return propIds;
    }

    private int[] readPropertyList(BBacnetDevice device) throws BacnetException {
        BBacnetArray propertyList = new BBacnetArray(BDynamicEnum.TYPE);
        this.readArray(device, 371, propertyList);
        BDynamicEnum[] propertyIds = (BDynamicEnum[])propertyList.getChildren(BDynamicEnum.class);
        int[] ordinals = new int[propertyIds.length + 3];
        ordinals[0] = 75;
        ordinals[1] = 77;
        ordinals[2] = 79;
        for (int i = 0; i < propertyIds.length; ++i) {
            ordinals[i + 3] = propertyIds[i].getOrdinal();
        }
        return ordinals;
    }

    public void doUploadRequiredProperties() {
        this.uploadProperties(BBacnetPropertyIdentifier.required);
    }

    public void doUploadOptionalProperties() {
        this.uploadProperties(BBacnetPropertyIdentifier.optional);
    }

    private void uploadProperties(BBacnetPropertyIdentifier propertyId) {
        if (propertyId == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(lex.get("object.upload.unknown.error"));
            }
            return;
        }
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        BBacnetDevice device = this.device();
        if (network == null || device == null) {
            return;
        }
        network.getWorker().post(() -> {
            block2: {
                try {
                    Vector<NReadAccessSpec> specs = new Vector<NReadAccessSpec>();
                    specs.add(new NReadAccessSpec(this.getObjectId(), propertyId.getOrdinal()));
                    Vector vals = BBacnetObject.client().readPropertyMultiple(device.getAddress(), specs);
                    ListIterator it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                    this.updateProperties(device, it);
                }
                catch (BacnetException e) {
                    if (!log.isLoggable(Level.FINE)) break block2;
                    log.log(Level.FINE, lex.getText("object.upload." + propertyId.getTag() + ".error"), (Throwable)((Object)e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownload(BDownloadParameters p, Context cx) {
        ArrayList<PropertyWrite> propWrites;
        Map<PropertyWrite, PropertyWrite> map = this.writeProps;
        synchronized (map) {
            if (this.writePropsTicket != null) {
                this.writePropsTicket.cancel();
            }
            this.writePropsTicket = null;
            propWrites = new ArrayList<PropertyWrite>(this.writeProps.values());
            this.writeProps.clear();
        }
        BBacnetDevice device = this.device();
        if (device == null) {
            return;
        }
        Iterator iterator = propWrites.iterator();
        while (iterator.hasNext()) {
            PropertyWrite propWrite = (PropertyWrite)iterator.next();
            int propId = propWrite.propData.propertyId;
            if (propId != 75 && propId != 79) continue;
            iterator.remove();
        }
        boolean wpmOk = false;
        int firstFailPropId = -1;
        if (propWrites.size() > 1 && device.isServiceSupported("writePropertyMultiple")) {
            try {
                NWriteAccessSpec writeAccessSpec = new NWriteAccessSpec(this.getObjectId());
                for (PropertyWrite propWrite : propWrites) {
                    int propId;
                    if (propWrite.propValue == null) {
                        propWrite.propValue = this.toEncodedValue(propWrite.propData, propWrite.configProp);
                    }
                    if ((propId = propWrite.propData.propertyId) == 87) {
                        propWrite.propValue = BBacnetClientLayer.handlePriorityArrayOptionalDateTime(propWrite.propValue);
                        writeAccessSpec.addPropertyValue(85, -1, propWrite.propValue, propWrite.arrayIndex);
                        continue;
                    }
                    writeAccessSpec.addPropertyValue(propId, propWrite.arrayIndex, propWrite.propValue);
                }
                Vector<NWriteAccessSpec> writeSpecs = new Vector<NWriteAccessSpec>();
                writeSpecs.add(writeAccessSpec);
                BBacnetObject.client().writePropertyMultiple(device.getAddress(), writeSpecs);
                wpmOk = true;
            }
            catch (ErrorException e) {
                firstFailPropId = ((BBacnetObjectPropertyReference)e.getErrorParameters()[0]).getPropertyId();
                log.info("BACnet Error downloading " + this + ":\nFailed write for " + Arrays.toString(e.getErrorParameters()) + ":" + (Object)((Object)e));
            }
            catch (BacnetException e) {
                log.log(Level.INFO, "BacnetException downloading " + this + ":" + (Object)((Object)e), (Throwable)((Object)(log.isLoggable(Level.FINE) ? e : null)));
            }
        }
        if (!wpmOk) {
            boolean preFailure = firstFailPropId != -1;
            for (PropertyWrite propWrite : propWrites) {
                if (preFailure) {
                    if (firstFailPropId != propWrite.propData.propertyId) continue;
                    preFailure = false;
                }
                try {
                    if (propWrite.propValue == null) {
                        propWrite.propValue = this.toEncodedValue(propWrite.propData, propWrite.configProp);
                    }
                    BBacnetObject.client().writeProperty(device.getAddress(), this.getObjectId(), propWrite.propData.propertyId, propWrite.arrayIndex, propWrite.propValue);
                }
                catch (Exception e2) {
                    log.warning("Cannot write property " + propWrite.configProp + " in " + this + ":" + e2);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(device.getName() + " object download execution finish.");
        }
    }

    public BValue doReadBacnetProperty(BEnum propId) throws BacnetException {
        Property prop;
        BBacnetDevice device = this.device();
        if (device != null && !device.isDown() && (prop = this.lookupBacnetProperty(propId.getOrdinal())) != null) {
            this.readProperty(prop);
            return this.get(prop);
        }
        return null;
    }

    public void doWriteBacnetProperty(BEnum propId) throws BacnetException {
        Property prop;
        BBacnetDevice device = this.device();
        if (device != null && !device.isDown() && (prop = this.lookupBacnetProperty(propId.getOrdinal())) != null) {
            this.writeProperty(prop);
        }
    }

    protected final BBacnetNetwork network() {
        return this.config != null ? this.config.network() : null;
    }

    @Override
    public final BBacnetDevice device() {
        if (this.config != null) {
            return this.config.device();
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBacnetDevice)) continue;
            return (BBacnetDevice)parent;
        }
        return null;
    }

    protected final BBacnetConfigDeviceExt config() {
        return this.config;
    }

    private static BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public String toString(Context context) {
        return this.getName() + " [" + this.getObjectId().toString(context) + "]";
    }

    public Property getPresentValueProperty() {
        return null;
    }

    protected void setOutputFacets() {
    }

    protected boolean shouldPoll(int propertyId) {
        return true;
    }

    protected byte[] toEncodedValue(BacnetPropertyData d, Property p) {
        return AsnUtil.toAsn(d.getAsnType(), this.get(p));
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BBacnetConfigFolder && parent.getParent() instanceof BBacnetConfigFolder) {
            return false;
        }
        return super.isParentLegal(parent);
    }

    public void readProperty(Property prop) throws BacnetException {
        BBacnetDevice device = this.device();
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY || device == null || device.isDown()) {
            return;
        }
        if (prop.getType() == BBacnetArray.TYPE) {
            this.readArray(device, d.getPropertyId(), (BBacnetArray)this.get(prop));
        } else {
            byte[] encodedValue = null;
            encodedValue = BBacnetObject.client().readProperty(device.getAddress(), this.getObjectId(), d.getPropertyId());
            this.set(prop, AsnUtil.fromAsn(d.getAsnType(), encodedValue, this.get(prop)), noWrite);
        }
    }

    public void writeProperty(Property prop) throws BacnetException {
        BBacnetDevice device = this.device();
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY || device == null) {
            return;
        }
        if (!device.isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BBacnetObject.client().writeProperty(device.getAddress(), this.getObjectId(), d.getPropertyId(), -1, this.toEncodedValue(d, prop), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperty(Property prop, int arrayIndex, byte[] encodedValue) throws BacnetException {
        BBacnetDevice device = this.device();
        BacnetPropertyData propData = this.getPropertyData(prop);
        if (propData == NOT_BACNET_PROPERTY || device == null) {
            return;
        }
        if (!device.isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        Map<PropertyWrite, PropertyWrite> map = this.writeProps;
        synchronized (map) {
            PropertyWrite propWrite = new PropertyWrite(propData, arrayIndex, encodedValue);
            this.writeProps.put(propWrite, propWrite);
            if (this.writePropsTicket == null) {
                this.writePropsTicket = Clock.schedule((BComponent)this, (BRelTime)WRITE_PROPS_DELAY, (Action)download, (BValue)new BDownloadParameters());
            }
        }
    }

    public void addListElement(Property prop, BValue listElement) throws BacnetException {
        BBacnetDevice device = this.device();
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY || device == null) {
            return;
        }
        if (!this.get(prop).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!device.isServiceSupported("addListElement")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.addListElement"));
        }
        byte[] encodedListElement = AsnUtil.toAsn(listElement);
        if (this.getObjectId().getInstanceNumber() != -1) {
            BBacnetObject.client().addListElement(device.getAddress(), this.getObjectId(), d.getPropertyId(), -1, encodedListElement);
        }
    }

    public void removeListElement(Property prop, BValue listElement) throws BacnetException {
        BBacnetDevice device = this.device();
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY || device == null) {
            return;
        }
        if (!this.get(prop).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!device.isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.removeListElement"));
        }
        byte[] encodedListElement = AsnUtil.toAsn(listElement);
        BBacnetObject.client().removeListElement(device.getAddress(), this.getObjectId(), d.getPropertyId(), -1, encodedListElement);
    }

    @Override
    public final int getPollableType() {
        return 2;
    }

    @Override
    @Deprecated
    public final boolean poll() {
        log.warning("BBacnetObject.poll() is DEPRECATED!!!");
        return false;
    }

    public final void readOk() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public final void readFail(String failureMsg) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(failureMsg);
    }

    @Override
    public final void fromEncodedValue(byte[] encodedValue, BStatus status, Context cx) {
        try {
            Property prop = this.lookupBacnetProperty(((PollListEntry)cx).getPropertyId());
            BInteger asnType = (BInteger)prop.getFacets().getFacet(ASN_TYPE);
            BValue v = AsnUtil.fromAsn(asnType.getInt(), encodedValue, this.get(prop));
            BacUtil.set((BComponent)this, prop, v, noWrite);
            this.readOk();
        }
        catch (AsnException e) {
            this.readFail(e.toString());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception decoding value for " + this + " [" + cx + "]:" + ByteArrayUtil.toHexString((byte[])encodedValue), (Throwable)((Object)e));
            }
        }
        catch (Exception e) {
            plog.log(Level.SEVERE, "Exception occurred in fromEncodedValue", e);
        }
    }

    @Override
    public final PollListEntry[] getPollListEntries() {
        return this.polledProperties.toArray(new PollListEntry[0]);
    }

    private void checkConfig() {
        BBacnetConfigDeviceExt config = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBacnetConfigDeviceExt)) continue;
            config = (BBacnetConfigDeviceExt)parent;
            break;
        }
        this.config = config;
    }

    private void readArray(BBacnetDevice device, int propertyId, BBacnetArray array) throws BacnetException {
        BBacnetAddress address = device.getAddress();
        BBacnetObjectIdentifier objectId = this.getObjectId();
        try {
            byte[] encodedValue = BBacnetObject.client().readProperty(address, objectId, propertyId);
            AsnUtil.fromAsn(-2, encodedValue, (BValue)array);
            return;
        }
        catch (Exception e) {
            ByteArrayOutputStream os;
            boolean readOk;
            int arraySize;
            block12: {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception reading array property " + BBacnetPropertyIdentifier.tag(propertyId) + " in object " + this + ": " + e + "\n building array in groups...", e);
                }
                arraySize = AsnUtil.fromAsnUnsignedInt(BBacnetObject.client().readProperty(address, objectId, propertyId, 0));
                readOk = false;
                os = new ByteArrayOutputStream();
                int index = 1;
                if (device.isServiceSupported("readPropertyMultiple")) {
                    try {
                        BTypeSpec arrTypeSpec = array.getArrayTypeSpec();
                        int elemSize = AsnUtil.getSize(arrTypeSpec);
                        int hdrSize = 9;
                        int elemHdr = 8;
                        int maxAPDUSize = device.getMaxAPDULengthAccepted();
                        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
                        if (maxAPDUSize > myMax) {
                            maxAPDUSize = myMax;
                        }
                        int safetyFactor = 10;
                        int elemsPerRead = (maxAPDUSize - hdrSize - safetyFactor) / (elemSize + elemHdr);
                        do {
                            Vector<NBacnetPropertyReference> refs = new Vector<NBacnetPropertyReference>();
                            for (int i = index; i < index + elemsPerRead && i <= arraySize; ++i) {
                                refs.add(new NBacnetPropertyReference(propertyId, i));
                            }
                            Vector results = BBacnetObject.client().readPropertyMultiple(address, objectId, refs);
                            for (Object result : results) {
                                NReadPropertyResult rpr = (NReadPropertyResult)result;
                                byte[] val = rpr.getPropertyValue();
                                os.write(val, 0, val.length);
                                ++index;
                            }
                        } while (index <= arraySize);
                        readOk = true;
                    }
                    catch (Exception e2) {
                        if (!log.isLoggable(Level.FINE)) break block12;
                        log.log(Level.FINE, "Exception reading array property " + BBacnetPropertyIdentifier.tag(propertyId) + " in object " + this + " in groups: " + e2 + "\n building array element by element...", e2);
                    }
                }
            }
            if (!readOk) {
                for (int i = index; i <= arraySize; ++i) {
                    byte[] encodedElement = BBacnetObject.client().readProperty(address, objectId, propertyId, i);
                    os.write(encodedElement, 0, encodedElement.length);
                }
            }
            AsnUtil.fromAsn(-2, os.toByteArray(), (BValue)array);
            return;
        }
    }

    private boolean readArray(BBacnetDevice device, BBacnetArray a, int propId, PropertyInfo pi) {
        try {
            BBacnetAddress address = device.getAddress();
            BBacnetObjectIdentifier objectId = this.getObjectId();
            int asize = 0;
            try {
                asize = AsnUtil.fromAsnUnsignedInt(BBacnetObject.client().readProperty(address, objectId, propId, 0));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Cannot get array size", e);
                }
                return false;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int i = 1;
            try {
                for (i = 1; i <= asize; ++i) {
                    byte[] encodedElement = BBacnetObject.client().readProperty(address, objectId, propId, i);
                    os.write(encodedElement, 0, encodedElement.length);
                }
                byte[] encodedArray = os.toByteArray();
                AsnInputStream in = new AsnInputStream(encodedArray);
                a.readAsn(in);
                return true;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception reading array element " + i + ":" + e, e);
                }
                return false;
            }
        }
        catch (Throwable t) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unable to build BacnetArray for property " + propId, t);
            }
            return false;
        }
    }

    protected void updatePriorityArrayType(Property priorityArrayProperty, Type newType) {
        if (priorityArrayProperty == null) {
            return;
        }
        BValue priorityArray = this.get(priorityArrayProperty);
        if (!(priorityArray instanceof BBacnetArray) || ((BBacnetArray)priorityArray).getArrayTypeSpec().equals((Object)BBacnetPriorityValue.TYPE.getTypeSpec())) {
            this.set(priorityArrayProperty, (BValue)new BBacnetArray(newType, 16), noWrite);
        }
    }

    protected void buildPolledProperties() {
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        if (this.isSubscribed()) {
            pollService.unsubscribe(this);
        }
        SlotCursor sc = this.getProperties();
        BInteger pId = null;
        if (this.polledProperties.size() > 0) {
            this.polledProperties.clear();
        }
        while (sc.next()) {
            Property p = sc.property();
            pId = (BInteger)p.getFacets().getFacet(PID);
            if (pId == null || !this.shouldPoll(pId.getInt())) continue;
            this.polledProperties.add(new PollListEntry(this.getObjectId(), pId.getInt(), this.device(), this));
        }
        if (this.isSubscribed()) {
            pollService.subscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateProperties(BBacnetDevice device, Iterator it) {
        Object object = UPLOAD_LOCK;
        // MONITORENTER : object
        while (true) {
            if (!it.hasNext()) {
                // MONITOREXIT : object
                if (!log.isLoggable(Level.FINEST)) return;
                log.finest(device.getName() + " object updateProperties execution finish.");
                return;
            }
            NReadPropertyResult rpr = (NReadPropertyResult)it.next();
            int propId = rpr.getPropertyId();
            Property prop = this.lookupBacnetProperty(propId);
            try {
                if (prop == null) {
                    if (rpr.isError()) continue;
                    PropertyInfo propInfo = this.getPropertyInfo(device, propId);
                    BValue value = AsnUtil.asnToValue(propInfo, rpr.getPropertyValue());
                    String name = SlotPath.escape((String)propInfo.getName());
                    prop = this.add(name, value, 0, BBacnetObject.makeFacets(propInfo, value), null);
                    if (this.shouldPoll(propId)) {
                        this.polledProperties.add(new PollListEntry(this.getObjectId(), propId, this.device(), this));
                    }
                    if (device.getEnumerationList().getPropertyIdRange().isOrdinal(propId)) continue;
                    device.getEnumerationList().addNewPropertyId(propInfo.getName(), propId);
                    continue;
                }
                if (rpr.isError()) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Error uploading property " + prop + ":" + rpr.getPropertyAccessError());
                    continue;
                }
                this.set(prop, AsnUtil.fromAsn(((BInteger)prop.getFacets().getFacet(ASN_TYPE)).getInt(), rpr.getPropertyValue(), this.get(prop)), noWrite);
            }
            catch (AsnException e) {
                log.info("Unable to convert encoded value: prop=" + prop + ", id=" + propId + ", val=" + ByteArrayUtil.toHexString((byte[])rpr.getPropertyValue()) + "\n" + (Object)((Object)e));
            }
            catch (Exception e) {
                log.info("Unable to add/update property: prop=" + prop + ", id=" + propId + ", val=" + ByteArrayUtil.toHexString((byte[])rpr.getPropertyValue()) + "\n" + e);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Stack Trace: ", e);
                continue;
            }
            break;
        }
    }

    private void uploadIndividual(BBacnetDevice device, NReadAccessSpec spec) {
        PropertyReference[] refs = spec.getListOfPropertyReferences();
        for (int i = 0; i < refs.length; ++i) {
            int propId = refs[i].getPropertyId();
            try {
                Property prop = this.lookupBacnetProperty(propId);
                if (prop != null) {
                    this.readProperty(prop);
                    continue;
                }
                byte[] encodedValue = null;
                PropertyInfo propInfo = this.getPropertyInfo(device, propId);
                String name = SlotPath.escape((String)propInfo.getName());
                try {
                    encodedValue = BBacnetObject.client().readProperty(device.getAddress(), this.getObjectId(), propId);
                    BValue value = AsnUtil.asnToValue(propInfo, encodedValue);
                    prop = this.add(name, value, 0, BBacnetObject.makeFacets(propInfo, value), noWrite);
                }
                catch (BacnetException e) {
                    if (e instanceof ErrorException && ((ErrorException)e).getErrorType().getErrorCode() == 32) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Unknown Property " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                        continue;
                    }
                    if (propInfo.isArray()) {
                        BBacnetArray a = new BBacnetArray();
                        a.setArrayTypeSpec(BTypeSpec.make((String)propInfo.getType()));
                        this.readArray(device, a, propId, propInfo);
                        prop = this.add(name, (BValue)a, 0, BBacnetObject.makeFacets(propInfo, (BValue)a), noWrite);
                    }
                    log.info("BacnetException uploading propertyId " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                }
                if (!this.shouldPoll(propId)) continue;
                this.polledProperties.add(new PollListEntry(this.getObjectId(), propId, this.device(), this));
                continue;
            }
            catch (TransactionException e) {
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("TransactionException uploading object " + (Object)((Object)this.getObjectId()) + " in " + this.device() + ": " + e);
                break;
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Exception uploading propertyId " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            }
        }
    }

    private PropertyInfo getPropertyInfo(BBacnetDevice device, int propId) {
        PropertyInfo propInfo = device.getPropertyInfo(this.getObjectId().getObjectType(), propId);
        if (propInfo == null) {
            propInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(propId), propId, -6);
        }
        return propInfo;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetObject", 2);
        out.prop((Object)"config", (Object)this.config);
        if (this.polledProperties != null) {
            int siz = this.polledProperties.size();
            out.prop((Object)"polledProperties", siz);
            for (int i = 0; i < siz; ++i) {
                out.prop((Object)("polledProperties[" + i + "]:"), (Object)this.polledProperties.get(i).debugString());
            }
        } else {
            out.prop((Object)"polledProperties", (Object)"NULL");
        }
        out.prop((Object)"propDataMap", this.propDataMap.size());
        for (Map.Entry<BFacets, BacnetPropertyData> entry : this.propDataMap.entrySet()) {
            out.prop((Object)entry.getKey(), (Object)entry.getValue());
        }
        out.endProps();
    }

    protected Property lookupBacnetProperty(int propId) {
        SlotCursor c = this.getProperties();
        while (c.next()) {
            try {
                Property property = c.property();
                BInteger propertyIdFacet = (BInteger)property.getFacets().getFacet(PID);
                if (propertyIdFacet == null || propertyIdFacet.getInt() != propId) continue;
                return property;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static void init() {
        TypeInfo base = TYPE.getTypeInfo();
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(base);
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equals(base)) continue;
            BBacnetObject o = (BBacnetObject)types[i].getInstance();
            int objTypOrd = o.getObjectType().getOrdinal();
            Array cur = byObjectType.get(objTypOrd);
            if (cur == null) {
                cur = new Array(TypeInfo.class);
            }
            cur.add((Object)types[i]);
            byObjectType.put(objTypOrd, (Array<TypeInfo>)cur);
        }
        initialized = true;
    }

    protected static BFacets makeFacets(int propertyId, int asnType) {
        HashMap<String, BInteger> map = new HashMap<String, BInteger>();
        map.put(PID, BInteger.make((int)propertyId));
        map.put(ASN_TYPE, BInteger.make((int)asnType));
        return BFacets.make(map);
    }

    protected static BFacets makeFacets(int propertyId, int asnType, Map<String, BIDataValue> m) {
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>(m);
        map.put(PID, (BIDataValue)BInteger.make((int)propertyId));
        map.put(ASN_TYPE, (BIDataValue)BInteger.make((int)asnType));
        return BFacets.make(map);
    }

    protected static BFacets makeFacets(int propertyId, int asnType, String[] keys, BIDataValue[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        String[] k = new String[keys.length + 2];
        System.arraycopy(keys, 0, k, 0, keys.length);
        k[keys.length] = PID;
        k[keys.length + 1] = ASN_TYPE;
        BIDataValue[] v = new BIDataValue[values.length + 2];
        System.arraycopy(values, 0, v, 0, values.length);
        v[values.length] = BInteger.make((int)propertyId);
        v[values.length + 1] = BInteger.make((int)asnType);
        return BFacets.make((String[])k, (BIDataValue[])v);
    }

    protected static BFacets makeFacets(PropertyInfo info, BValue value) {
        HashMap<Object, Object> map = info.isBitString() ? new HashMap<String, BIDataValue>(BacnetBitStringUtil.getBitStringMap(info.getBitStringName())) : new HashMap<String, BInteger>();
        map.put(PID, BInteger.make((int)info.getId()));
        map.put(ASN_TYPE, BInteger.make((int)info.getAsnType()));
        return BFacets.make(map);
    }

    protected BacnetPropertyData getPropertyData(Property prop) {
        BacnetPropertyData d;
        BFacets f = prop.getFacets();
        if (f == null) {
            return NOT_BACNET_PROPERTY;
        }
        if (f.geti(PID, -1) == -1) {
            return NOT_BACNET_PROPERTY;
        }
        if (!prop.isDynamic() && (d = this.propDataMap.get(f)) == null) {
            d = BBacnetObject.makePropertyData(f);
            this.propDataMap.put(f, d);
            return d;
        }
        return BBacnetObject.makePropertyData(f);
    }

    private static BacnetPropertyData makePropertyData(BFacets f) {
        int propertyId = -1;
        int asnType = 0;
        BObject s = f.getFacet(PID);
        if (s != null) {
            propertyId = ((BInteger)s).getInt();
        }
        if ((s = f.getFacet(ASN_TYPE)) != null) {
            asnType = ((BInteger)s).getInt();
        }
        return BacnetPropertyData.make(propertyId, asnType);
    }

    private static class PropertyWrite {
        public final BacnetPropertyData propData;
        public final int arrayIndex;
        public byte[] propValue;
        public final Property configProp;
        private final int hash;

        public PropertyWrite(BacnetPropertyData propData, Property configProp) {
            this.propData = propData;
            this.arrayIndex = -1;
            this.propValue = null;
            this.configProp = configProp;
            this.hash = Objects.hash(propData.propertyId, this.arrayIndex);
        }

        public PropertyWrite(BacnetPropertyData propData, int arrayIndex, byte[] propValue) {
            this.propData = propData;
            this.arrayIndex = arrayIndex;
            this.propValue = propValue;
            this.configProp = null;
            this.hash = Objects.hash(propData.propertyId, arrayIndex);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyWrite that = (PropertyWrite)o;
            return this.propData.propertyId == that.propData.propertyId && this.arrayIndex == that.arrayIndex;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class BacnetPropertyData {
        int propertyId;
        int asnType;

        private BacnetPropertyData(int propertyId, int asnType) {
            this.propertyId = propertyId;
            this.asnType = asnType;
        }

        static BacnetPropertyData make(int pid, int asn) {
            if (pid == -1 && asn == 0) {
                return NOT_BACNET_PROPERTY;
            }
            return new BacnetPropertyData(pid, asn);
        }

        public int getPropertyId() {
            return this.propertyId;
        }

        public int getAsnType() {
            return this.asnType;
        }
    }
}

