/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server.object;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.object.BBacnetObjectCreator;
import com.tridium.bacnet.stack.server.object.BacObjCreatorDeletorUtil;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetCalendarDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCalendarCreator
extends BBacnetObjectCreator {
    @Generated
    public static final Type TYPE = Sys.loadType(BCalendarCreator.class);
    private static int[] SUPPORTED_INITIAL_PROPERTY = new int[]{77, 28, 23};
    private static int[] SUPPORTED_PROPERTY = new int[]{77, 28, 23, 75, 79, 85, 371};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isObjectTypeSupported(int objectType) {
        return objectType == 6;
    }

    @Override
    public BIBacnetExportObject createObject(BBacnetObjectIdentifier oid) {
        BBacnetCalendarDescriptor descriptor = new BBacnetCalendarDescriptor();
        descriptor.setObjectId(oid);
        BCalendarSchedule calendar = new BCalendarSchedule();
        descriptor.add("DynamicCalendar", (BValue)calendar);
        calendar.setCleanupExpiredEvents(false);
        return descriptor;
    }

    @Override
    public ErrorType writeInitialValue(BIBacnetExportObject exportDescriptor, PropertyValue propertyValue) throws BacnetException {
        switch (propertyValue.getPropertyId()) {
            case 23: 
            case 28: 
            case 77: {
                return exportDescriptor.writeProperty(propertyValue);
            }
        }
        return new NErrorType(2, 40);
    }

    @Override
    public ErrorType exportObject(BBacnetExportTable table, BIBacnetExportObject exportDescriptor) {
        try {
            if (exportDescriptor instanceof BValue) {
                BValue ed = (BValue)exportDescriptor;
                BComponent dynafolder = table.get("dynamicObjects").asComponent();
                String expDescName = "calendar_" + exportDescriptor.getObjectId().getInstanceNumber();
                dynafolder.add(expDescName, ed);
                BOrd b = ((BCalendarSchedule)((BBacnetCalendarDescriptor)dynafolder.get(expDescName)).get("DynamicCalendar")).getHandleOrd();
                BBacnetCalendarDescriptor bcd = (BBacnetCalendarDescriptor)dynafolder.get(expDescName);
                bcd.setCalendarOrd(b);
                bcd.set("objectName", (BValue)BString.make((String)expDescName));
                bcd.add("dynamic", (BValue)BString.make((String)"dynamic"), 5);
                return null;
            }
            BacObjCreatorDeletorUtil.logger.warning("dynamically created BIBacnetExportObjects must extend BValue");
        }
        catch (Exception e) {
            BacObjCreatorDeletorUtil.logger.warning(e.getMessage());
            return new NErrorType(2, 56);
        }
        return null;
    }

    @Override
    protected int[] getSupportedInitialValue() {
        return SUPPORTED_INITIAL_PROPERTY;
    }

    @Override
    protected int[] getSupportedProperty() {
        return SUPPORTED_PROPERTY;
    }
}

