/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AddListElementRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.RemoveListElementRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.error.WritePropertyMultipleError;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AbortException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RejectException;

public class PropertyHandler
implements ServiceHandler,
BacnetConfirmedServiceChoice {
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private BBacnetServerLayer server;
    private BBacnetTransportLayer transportLayer;

    PropertyHandler(BBacnetServerLayer server) {
        this.server = server;
    }

    @Override
    public BacnetServicePrimitive receiveRequest(int serviceChoice, BacnetServicePrimitive request, BBacnetAddress sourceAddress) {
        switch (serviceChoice) {
            case 12: {
                return this.processReadPropertyRequest((ReadPropertyRequest)request);
            }
            case 14: {
                return this.processReadPropertyMultipleRequest((ReadPropertyMultipleRequest)request);
            }
            case 26: {
                return this.processReadRangeRequest((ReadRangeRequest)request);
            }
            case 15: {
                return this.processWritePropertyRequest((WritePropertyRequest)request);
            }
            case 16: {
                return this.processWritePropertyMultipleRequest((WritePropertyMultipleRequest)request);
            }
            case 8: {
                return this.processAddListElementRequest((AddListElementRequest)request);
            }
            case 9: {
                return this.processRemoveListElementRequest((RemoveListElementRequest)request);
            }
        }
        logger.info("PropertyHandler.receiveRequest:Unknown request! " + request);
        return new BacnetReject(9);
    }

    public void setTransportLayer(BBacnetTransportLayer transportLayer) {
        this.transportLayer = transportLayer;
    }

    @Override
    public BBacnetTransportLayer getTransportLayer() {
        return this.transportLayer;
    }

    private BacnetServicePrimitive processReadPropertyRequest(ReadPropertyRequest request) {
        PropertyValue result;
        BIBacnetExportObject object;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = request.getObjectId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.ReadPropertyRequest received: " + request);
        }
        if ((object = local.lookupBacnetObject(objectId)) == null) {
            if (objectId.getObjectType() == 8 && objectId.getInstanceNumber() == 0x3FFFFF) {
                object = local;
                objectId = local.getObjectId();
            } else {
                return new SimpleError(12, new NErrorType(1, 31));
            }
        }
        if (objectId.equals((Object)this.server.getBackupRestoreFileId()) && local.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupRestoreCommTime();
        }
        try {
            result = object.readProperty(new NBacnetPropertyReference(request.getPropertyId(), request.getPropertyArrayIndex()));
        }
        catch (RejectException e) {
            return new BacnetReject(e.getRejectReason());
        }
        if (result.isError()) {
            return new SimpleError(12, new NErrorType(result.getErrorClass(), result.getErrorCode()));
        }
        return new ReadPropertyAck(objectId, request.getPropertyId(), request.getPropertyArrayIndex(), result.getPropertyValue());
    }

    private BacnetServicePrimitive processReadPropertyMultipleRequest(ReadPropertyMultipleRequest request) {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        ReadPropertyMultipleAck response = new ReadPropertyMultipleAck();
        ListIterator<NReadAccessSpec> readAccessSpecs = request.getReadAccessSpecs();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.ReadPropertyMultipleRequest received: " + request);
        }
        boolean foundAtLeastOneObject = false;
        boolean foundAtLeastOneProperty = false;
        try {
            while (readAccessSpecs.hasNext()) {
                NReadAccessSpec ras = (NReadAccessSpec)readAccessSpecs.next();
                BBacnetObjectIdentifier objectId = ras.getObjectId();
                BIBacnetExportObject object = local.lookupBacnetObject(objectId);
                if (object == null && objectId.getObjectType() == 8 && objectId.getInstanceNumber() == 0x3FFFFF) {
                    object = local;
                    objectId = local.getObjectId();
                }
                NReadAccessResult readAccessResult = new NReadAccessResult(objectId);
                if (object == null) {
                    ListIterator propertyReferences = ras.getPropertyReferences();
                    while (propertyReferences.hasNext()) {
                        NBacnetPropertyReference propRef = (NBacnetPropertyReference)propertyReferences.next();
                        readAccessResult.addResult(new NReadPropertyResult(propRef.getPropertyId(), propRef.getPropertyArrayIndex(), new NErrorType(1, 31)));
                    }
                } else {
                    foundAtLeastOneObject = true;
                    if (objectId.equals((Object)this.server.getBackupRestoreFileId())) {
                        this.server.updateLastBackupRestoreCommTime();
                    }
                    PropertyReference[] refs = ras.getListOfPropertyReferences();
                    PropertyValue[] readResults = object.readPropertyMultiple(refs);
                    for (int i = 0; i < readResults.length; ++i) {
                        if (!foundAtLeastOneProperty && !readResults[i].isError()) {
                            foundAtLeastOneProperty = true;
                        }
                        readAccessResult.addResult(readResults[i]);
                    }
                }
                response.addReadAccessResult(readAccessResult);
            }
        }
        catch (RejectException e) {
            return new BacnetReject(e.getRejectReason());
        }
        if (foundAtLeastOneObject) {
            return response;
        }
        return new SimpleError(14, new NErrorType(1, 31));
    }

    private BacnetServicePrimitive processReadRangeRequest(ReadRangeRequest request) {
        RangeData result;
        BIBacnetExportObject object;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = request.getObjectId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.ReadRangeRequest received: " + request);
        }
        if ((object = local.lookupBacnetObject(objectId)) == null) {
            return new SimpleError(26, new NErrorType(1, 31));
        }
        try {
            result = object.readRange(request);
        }
        catch (RejectException e) {
            return new BacnetReject(e.getRejectReason());
        }
        if (result.isError()) {
            return new SimpleError(26, (NErrorType)result.getError());
        }
        return (BacnetServicePrimitive)((Object)result);
    }

    private BacnetServicePrimitive processWritePropertyRequest(WritePropertyRequest request) {
        BIBacnetExportObject object;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = request.getObjectId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.WritePropertyRequest received: " + request);
        }
        if ((object = local.lookupBacnetObject(objectId)) == null) {
            return new SimpleError(15, new NErrorType(1, 31));
        }
        try {
            if (objectId.equals((Object)this.server.getBackupRestoreFileId()) && local.getBackupAndRestoreState() != BBacnetBackupState.idle) {
                this.server.updateLastBackupRestoreCommTime();
            }
            object.setTransportLayer(this.getTransportLayer());
            ErrorType result = object.writeProperty(new NBacnetPropertyValue(request.getPropertyId(), request.getPropertyArrayIndex(), request.getEncodedValue(), request.getPriority()));
            if (result == null) {
                return new BacnetSimpleAck(15);
            }
            return new SimpleError(15, (NErrorType)result);
        }
        catch (RejectException r) {
            return new BacnetReject(r.getRejectReason());
        }
        catch (AbortException a) {
            return new BacnetAbort(a.getAbortReason());
        }
        catch (AsnException n) {
            return new BacnetReject(4);
        }
        catch (BacnetException e) {
            return new SimpleError(15, new NErrorType(1, 0));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in processWritePropertyRequest:" + e, e);
            return new SimpleError(15, new NErrorType(5, 0));
        }
    }

    private BacnetServicePrimitive processWritePropertyMultipleRequest(WritePropertyMultipleRequest request) {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        ListIterator<NWriteAccessSpec> writeAccessSpecs = request.getWriteAccessSpecs();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.WritePropertyMultipleRequest received: " + request);
        }
        BBacnetObjectIdentifier objectId = null;
        NBacnetPropertyValue propertyValue = null;
        try {
            while (writeAccessSpecs.hasNext()) {
                NWriteAccessSpec was = (NWriteAccessSpec)writeAccessSpecs.next();
                objectId = was.getObjectId();
                BIBacnetExportObject object = local.lookupBacnetObject(objectId);
                ListIterator propertyValues = was.getPropertyValues();
                while (propertyValues.hasNext()) {
                    ErrorType error;
                    propertyValue = (NBacnetPropertyValue)propertyValues.next();
                    if (object == null) {
                        return new WritePropertyMultipleError(new NErrorType(1, 31), new BBacnetObjectPropertyReference(objectId, propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex()));
                    }
                    if (objectId.equals((Object)this.server.getBackupRestoreFileId())) {
                        this.server.updateLastBackupRestoreCommTime();
                    }
                    if ((error = object.writeProperty(propertyValue)) == null) continue;
                    return new WritePropertyMultipleError((NErrorType)error, new BBacnetObjectPropertyReference(objectId, propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex()));
                }
            }
            return new BacnetSimpleAck(16);
        }
        catch (RejectException r) {
            return new BacnetReject(r.getRejectReason());
        }
        catch (AbortException a) {
            return new BacnetAbort(a.getAbortReason());
        }
        catch (AsnException n) {
            return new BacnetReject(4);
        }
        catch (BacnetException e) {
            if (objectId == null) {
                objectId = BBacnetObjectIdentifier.DEFAULT;
            }
            if (propertyValue == null) {
                propertyValue = new NBacnetPropertyValue();
            }
            return new WritePropertyMultipleError(new NErrorType(1, 0), new BBacnetObjectPropertyReference(objectId, propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex()));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in processWritePropertyMultipleRequest:" + e, e);
            if (objectId == null) {
                objectId = BBacnetObjectIdentifier.DEFAULT;
            }
            if (propertyValue == null) {
                propertyValue = new NBacnetPropertyValue();
            }
            return new WritePropertyMultipleError(new NErrorType(5, 0), new BBacnetObjectPropertyReference(objectId, propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex()));
        }
    }

    private BacnetServicePrimitive processAddListElementRequest(AddListElementRequest request) {
        BIBacnetExportObject object;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = request.getObjectId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.AddListElementRequest received: " + request);
        }
        if ((object = local.lookupBacnetObject(objectId)) == null) {
            return new NChangeListError(8, new NErrorType(1, 31), 1L);
        }
        try {
            ChangeListError result = object.addListElements(new NBacnetPropertyValue(request.getPropertyId(), request.getPropertyArrayIndex(), request.getListOfElements()));
            if (result == null) {
                return new BacnetSimpleAck(8);
            }
            return (NChangeListError)result;
        }
        catch (RejectException r) {
            return new BacnetReject(r.getRejectReason());
        }
        catch (AbortException a) {
            return new BacnetAbort(a.getAbortReason());
        }
        catch (AsnException n) {
            return new BacnetReject(4);
        }
        catch (BacnetException e) {
            return new NChangeListError(8, new NErrorType(1, 0), 1L);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in addListElementRequest:" + e, e);
            return new NChangeListError(8, new NErrorType(5, 0), 1L);
        }
    }

    private BacnetServicePrimitive processRemoveListElementRequest(RemoveListElementRequest request) {
        BIBacnetExportObject object;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier objectId = request.getObjectId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PropertyHandler.RemoveListElementRequest received: " + request);
        }
        if ((object = local.lookupBacnetObject(objectId)) == null) {
            return new NChangeListError(9, new NErrorType(1, 31), 1L);
        }
        try {
            ChangeListError result = object.removeListElements(new NBacnetPropertyValue(request.getPropertyId(), request.getPropertyArrayIndex(), request.getListOfElements()));
            if (result == null) {
                return new BacnetSimpleAck(9);
            }
            return (NChangeListError)result;
        }
        catch (RejectException r) {
            return new BacnetReject(r.getRejectReason());
        }
        catch (AbortException a) {
            return new BacnetAbort(a.getAbortReason());
        }
        catch (AsnException n) {
            return new BacnetReject(4);
        }
        catch (BacnetException e) {
            return new NChangeListError(9, new NErrorType(1, 0), 1L);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in removeListElementRequest:" + e, e);
            return new NChangeListError(9, new NErrorType(5, 0), 1L);
        }
    }
}

