/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.history.BHistory;
import com.tridium.json.JSONObject;
import java.util.Map;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIBacnetExportFolder
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BIBacnetExportFolder.class);

    public BBacnetExportTable getExports();

    public String getName();

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.box)})
    default public JSONObject getExportData(String slotPathBody, Map<String, Object> params, Context context) {
        JSONObject exportData = new JSONObject();
        BValue value = (BValue)BOrd.make((BOrd)this.getExports().getOrdInHost(), (OrdQuery)new SlotPath(slotPathBody)).get();
        if (null != value && value.getType().is(BIBacnetExportObject.TYPE)) {
            if (value instanceof BIProtected && !((BIProtected)value).getPermissions(context).hasOperatorRead()) {
                return exportData;
            }
            exportData.put("targetName", (Object)"");
            exportData.put("targetOutput", (Object)"null");
            BIBacnetExportObject exportObj = (BIBacnetExportObject)value;
            BOrd objectOrd = exportObj.getObjectOrd();
            exportData.put("objectOrd", (Object)objectOrd.toString(context));
            String writable = "";
            if (exportObj instanceof BBacnetPointDescriptor) {
                writable = ((BBacnetPointDescriptor)exportObj).getBacnetWritable();
            }
            exportData.put("bacnetWritable", (Object)writable);
            if (objectOrd.equals((Object)BOrd.NULL)) {
                return exportData;
            }
            OrdTarget ordTarget = objectOrd.resolve((BObject)value, context);
            if (ordTarget.canRead()) {
                BObject targetObj = ordTarget.get();
                if (targetObj instanceof BComponent) {
                    exportData.put("targetName", (Object)((BComponent)targetObj).getName());
                } else if (targetObj instanceof BHistory) {
                    exportData.put("targetName", (Object)((BHistory)targetObj).getDisplayName(context));
                }
                exportData.put("targetOutput", (Object)targetObj.toString(context));
            }
        }
        return exportData;
    }

    default public boolean operatorCanRead(BObject targetObj, Context context) {
        return targetObj instanceof BIProtected && ((BIProtected)targetObj).getPermissions(context).hasOperatorRead();
    }
}

