/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.network.PrioritizedQueue;
import com.tridium.bacnet.stack.network.PrioritizedQueueEntry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunnablePrioritizedQueue
extends PrioritizedQueue
implements Runnable {
    private boolean isAlive;
    private Thread thread;
    private static final Logger logger = Logger.getLogger("bacnet.stack");

    public RunnablePrioritizedQueue(int maxSize) {
        super(maxSize);
    }

    public RunnablePrioritizedQueue() {
    }

    public boolean isRunning() {
        return this.thread != null && this.isAlive;
    }

    public void start(String threadName) {
        if (this.isAlive) {
            return;
        }
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void start(ThreadGroup threadGroup, String threadName) {
        if (this.isAlive) {
            return;
        }
        this.isAlive = true;
        this.thread = new Thread(threadGroup, this, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected int getTimeout() {
        return -1;
    }

    protected void process(PrioritizedQueueEntry entry) {
    }

    @Override
    public void run() {
        this.isAlive = true;
        while (this.isAlive) {
            try {
                this.process(this.dequeue(this.getTimeout()));
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception occurred while processing RunnablePrioritizedQueue item", e);
            }
        }
    }
}

