/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.connection;

import com.tridium.bacnet.stack.link.sc.BNodeSwitch;
import com.tridium.bacnet.stack.link.sc.BNodeSwitchConnections;
import com.tridium.bacnet.stack.link.sc.NoConnectionException;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import com.tridium.bacnet.stack.link.sc.VmacUtil;
import com.tridium.bacnet.stack.link.sc.connection.BBacnetScConnectionState;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BInitiatingConnectionState;
import com.tridium.bacnet.stack.link.sc.connection.BScNodeInfo;
import com.tridium.bacnet.stack.link.sc.connection.IScConnectionInitiator;
import com.tridium.bacnet.stack.link.sc.message.AddressResolution;
import com.tridium.bacnet.stack.link.sc.message.AddressResolutionAck;
import com.tridium.bacnet.stack.link.sc.message.Advertisement;
import com.tridium.bacnet.stack.link.sc.message.AdvertisementSolicitation;
import com.tridium.bacnet.stack.link.sc.message.ScBvlcResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BBacnetScConnectionState", defaultValue="BBacnetScConnectionState.notConnected", flags=259), @NiagaraProperty(name="subState", type="BInitiatingConnectionState", defaultValue="BInitiatingConnectionState.DEFAULT", flags=259), @NiagaraProperty(name="peerUriAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"example.com\")"), @NiagaraProperty(name="peerUriPath", type="String", defaultValue="BNodeSwitch.DEFAULT_SERVLET_NAME"), @NiagaraProperty(name="peerUriQuery", type="String", defaultValue=""), @NiagaraProperty(name="peerAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"null\")", flags=3), @NiagaraProperty(name="peerVmac", type="BBacnetOctetString", defaultValue="BBacnetOctetString.DEFAULT", flags=1), @NiagaraProperty(name="peerUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=1), @NiagaraProperty(name="peerMaxBvlcLength", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="peerMaxNpduLength", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="peerInfo", type="BScNodeInfo", defaultValue="new BScNodeInfo()"), @NiagaraProperty(name="lastConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastDisconnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastFailureToConnect", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="error", type="BErrorType", defaultValue="new BErrorType(-1, -1)", flags=1), @NiagaraProperty(name="errorDetails", type="String", defaultValue="", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="initiateConnection"), @NiagaraAction(name="forceDisconnect"), @NiagaraAction(name="changePeerVmac", parameterType="BBacnetOctetString", defaultValue="BBacnetOctetString.make(new byte[VMAC_LENGTH])"), @NiagaraAction(name="sendAddressResolution"), @NiagaraAction(name="sendAdvertisementSolicitation"), @NiagaraAction(name="addressResolutionTimedOut", flags=4), @NiagaraAction(name="advertisementSolicitationTimedOut", flags=4)})
public final class BDirectInitiatingConnection
extends BInitiatingConnection
implements IPropertyValidator {
    @Generated
    public static final Property state = BDirectInitiatingConnection.newProperty((int)259, (BValue)BBacnetScConnectionState.notConnected, null);
    @Generated
    public static final Property subState = BDirectInitiatingConnection.newProperty((int)259, (BValue)BInitiatingConnectionState.DEFAULT, null);
    @Generated
    public static final Property peerUriAddress = BDirectInitiatingConnection.newProperty((int)0, (BValue)new BInternetAddress("example.com"), null);
    @Generated
    public static final Property peerUriPath = BDirectInitiatingConnection.newProperty((int)0, (String)"nodeSwitch", null);
    @Generated
    public static final Property peerUriQuery = BDirectInitiatingConnection.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property peerAddress = BDirectInitiatingConnection.newProperty((int)3, (BValue)new BInternetAddress("null"), null);
    @Generated
    public static final Property peerVmac = BDirectInitiatingConnection.newProperty((int)1, (BValue)BBacnetOctetString.DEFAULT, null);
    @Generated
    public static final Property peerUuid = BDirectInitiatingConnection.newProperty((int)1, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property peerMaxBvlcLength = BDirectInitiatingConnection.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property peerMaxNpduLength = BDirectInitiatingConnection.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property peerInfo = BDirectInitiatingConnection.newProperty((int)0, (BValue)new BScNodeInfo(), null);
    @Generated
    public static final Property lastConnect = BDirectInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastDisconnect = BDirectInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastFailureToConnect = BDirectInitiatingConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property error = BDirectInitiatingConnection.newProperty((int)1, (BValue)new BErrorType(-1, -1), null);
    @Generated
    public static final Property errorDetails = BDirectInitiatingConnection.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action initiateConnection = BDirectInitiatingConnection.newAction((int)0, null);
    @Generated
    public static final Action forceDisconnect = BDirectInitiatingConnection.newAction((int)0, null);
    @Generated
    public static final Action changePeerVmac = BDirectInitiatingConnection.newAction((int)0, (BValue)BBacnetOctetString.make(new byte[6]), null);
    @Generated
    public static final Action sendAddressResolution = BDirectInitiatingConnection.newAction((int)0, null);
    @Generated
    public static final Action sendAdvertisementSolicitation = BDirectInitiatingConnection.newAction((int)0, null);
    @Generated
    public static final Action addressResolutionTimedOut = BDirectInitiatingConnection.newAction((int)4, null);
    @Generated
    public static final Action advertisementSolicitationTimedOut = BDirectInitiatingConnection.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDirectInitiatingConnection.class);
    private static final Logger logger = Logger.getLogger("bacnet.sc.nodeSwitch");
    private BNodeSwitch nodeSwitch;
    private int addressResolutionId = -1;
    private Clock.Ticket addressResolutionTicket;
    private int advertisementSolicitationId = -1;
    private Clock.Ticket advertisementSolicitationTicket;

    @Override
    @Generated
    public BBacnetScConnectionState getState() {
        return (BBacnetScConnectionState)this.get(state);
    }

    @Override
    @Generated
    public void setState(BBacnetScConnectionState v) {
        this.set(state, (BValue)v, null);
    }

    @Override
    @Generated
    public BInitiatingConnectionState getSubState() {
        return (BInitiatingConnectionState)this.get(subState);
    }

    @Override
    @Generated
    public void setSubState(BInitiatingConnectionState v) {
        this.set(subState, (BValue)v, null);
    }

    @Generated
    public BInternetAddress getPeerUriAddress() {
        return (BInternetAddress)this.get(peerUriAddress);
    }

    @Generated
    public void setPeerUriAddress(BInternetAddress v) {
        this.set(peerUriAddress, (BValue)v, null);
    }

    @Generated
    public String getPeerUriPath() {
        return this.getString(peerUriPath);
    }

    @Generated
    public void setPeerUriPath(String v) {
        this.setString(peerUriPath, v, null);
    }

    @Generated
    public String getPeerUriQuery() {
        return this.getString(peerUriQuery);
    }

    @Generated
    public void setPeerUriQuery(String v) {
        this.setString(peerUriQuery, v, null);
    }

    @Generated
    public BInternetAddress getPeerAddress() {
        return (BInternetAddress)this.get(peerAddress);
    }

    @Generated
    public void setPeerAddress(BInternetAddress v) {
        this.set(peerAddress, (BValue)v, null);
    }

    @Generated
    public BBacnetOctetString getPeerVmac() {
        return (BBacnetOctetString)this.get(peerVmac);
    }

    @Generated
    public void setPeerVmac(BBacnetOctetString v) {
        this.set(peerVmac, (BValue)v, null);
    }

    @Generated
    public BUuid getPeerUuid() {
        return (BUuid)this.get(peerUuid);
    }

    @Generated
    public void setPeerUuid(BUuid v) {
        this.set(peerUuid, (BValue)v, null);
    }

    @Generated
    public int getPeerMaxBvlcLength() {
        return this.getInt(peerMaxBvlcLength);
    }

    @Generated
    public void setPeerMaxBvlcLength(int v) {
        this.setInt(peerMaxBvlcLength, v, null);
    }

    @Generated
    public int getPeerMaxNpduLength() {
        return this.getInt(peerMaxNpduLength);
    }

    @Generated
    public void setPeerMaxNpduLength(int v) {
        this.setInt(peerMaxNpduLength, v, null);
    }

    @Generated
    public BScNodeInfo getPeerInfo() {
        return (BScNodeInfo)this.get(peerInfo);
    }

    @Generated
    public void setPeerInfo(BScNodeInfo v) {
        this.set(peerInfo, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastConnect() {
        return (BAbsTime)this.get(lastConnect);
    }

    @Override
    @Generated
    public void setLastConnect(BAbsTime v) {
        this.set(lastConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastDisconnect() {
        return (BAbsTime)this.get(lastDisconnect);
    }

    @Override
    @Generated
    public void setLastDisconnect(BAbsTime v) {
        this.set(lastDisconnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getLastFailureToConnect() {
        return (BAbsTime)this.get(lastFailureToConnect);
    }

    @Override
    @Generated
    public void setLastFailureToConnect(BAbsTime v) {
        this.set(lastFailureToConnect, (BValue)v, null);
    }

    @Override
    @Generated
    public BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    @Override
    @Generated
    public void setError(BErrorType v) {
        this.set(error, (BValue)v, null);
    }

    @Override
    @Generated
    public String getErrorDetails() {
        return this.getString(errorDetails);
    }

    @Override
    @Generated
    public void setErrorDetails(String v) {
        this.setString(errorDetails, v, null);
    }

    @Generated
    public void initiateConnection() {
        this.invoke(initiateConnection, null, null);
    }

    @Generated
    public void forceDisconnect() {
        this.invoke(forceDisconnect, null, null);
    }

    @Generated
    public void changePeerVmac(BBacnetOctetString parameter) {
        this.invoke(changePeerVmac, (BValue)parameter, null);
    }

    @Generated
    public void sendAddressResolution() {
        this.invoke(sendAddressResolution, null, null);
    }

    @Generated
    public void sendAdvertisementSolicitation() {
        this.invoke(sendAdvertisementSolicitation, null, null);
    }

    @Generated
    public void addressResolutionTimedOut() {
        this.invoke(addressResolutionTimedOut, null, null);
    }

    @Generated
    public void advertisementSolicitationTimedOut() {
        this.invoke(advertisementSolicitationTimedOut, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BDirectInitiatingConnection make(BInternetAddress address, String path, BBacnetOctetString vmac) {
        BDirectInitiatingConnection connection = new BDirectInitiatingConnection();
        connection.setPeerUriAddress(address);
        connection.setPeerUriPath(path);
        if (VmacUtil.isDeviceVmac(VmacUtil.octetStringToVmac(vmac))) {
            connection.setPeerVmac(vmac);
        }
        return connection;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNodeSwitchConnections;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.nodeSwitch = (BNodeSwitch)this.getParent().getParent();
    }

    public void doInitiateConnection() {
        this.scLinkLayer.checkNetworkPortIsEnabled();
        this.nodeSwitch.checkInitiatesDirectConnections();
        BInitiatingConnectionState subState = this.getSubState();
        if (!subState.equals((Object)BInitiatingConnectionState.idle)) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.connect.improperState", new Object[]{subState.getDisplayTag(null)});
        }
        AccessController.doPrivileged(() -> {
            this.connect();
            return null;
        });
    }

    public void doChangePeerVmac(BBacnetOctetString peerVmac) {
        BInitiatingConnectionState subState = this.getSubState();
        if (!subState.equals((Object)BInitiatingConnectionState.idle)) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.changePeerVmac.improperState", new Object[]{subState.getDisplayTag(null)});
        }
        if (!VmacUtil.isDeviceVmac(VmacUtil.octetStringToVmac(peerVmac))) {
            throw new LocalizableRuntimeException("bacnet", "changeVmacAddress.invalidVmac");
        }
        this.setPeerVmac(peerVmac);
    }

    public void doSendAddressResolution() {
        this.cancelAddressResolutionTimer();
        long destinationVmac = VmacUtil.bytesToVmac(this.getPeerVmac().getBytes());
        if (!VmacUtil.isDeviceVmac(destinationVmac)) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.invalidVmac", new Object[]{this.getPeerVmac()});
        }
        try {
            int messageId = this.getNextMessageId();
            AddressResolution message = AddressResolution.make(messageId);
            this.nodeSwitch.sendMessage(destinationVmac, message);
            this.getPeerInfo().setAddressResolutionStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.inProgress", new Object[0]));
            this.addressResolutionId = messageId;
            this.startAddressResolutionTimer();
        }
        catch (NoConnectionException e) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.noConnection", new Object[]{VmacUtil.vmacToString(destinationVmac)}, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.failed", new Object[]{VmacUtil.vmacToString(destinationVmac)}, (Throwable)e);
        }
    }

    public synchronized void doAddressResolutionTimedOut() {
        if (this.addressResolutionTicket != null) {
            this.cancelAddressResolutionTimer();
            this.getPeerInfo().setAddressResolutionStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.timedOut", new Object[0]));
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Address resolution timed-out").toString());
            }
        }
    }

    public void doSendAdvertisementSolicitation() {
        this.cancelAdvertisementSolicitationTimer();
        long destinationVmac = VmacUtil.bytesToVmac(this.getPeerVmac().getBytes());
        if (!VmacUtil.isDeviceVmac(destinationVmac)) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.invalidVmac", new Object[]{this.getPeerVmac()});
        }
        try {
            int messageId = this.getNextMessageId();
            AdvertisementSolicitation message = AdvertisementSolicitation.make(messageId);
            this.nodeSwitch.sendMessage(destinationVmac, message);
            this.getPeerInfo().setAdvertisementSolicitationStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.inProgress", new Object[0]));
            this.advertisementSolicitationId = messageId;
            this.startAdvertisementSolicitationTimer();
        }
        catch (NoConnectionException e) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.noConnection", new Object[]{VmacUtil.vmacToString(destinationVmac)}, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("bacnet", "directInitiatingConnection.sendInfoMessage.failed", new Object[]{VmacUtil.vmacToString(destinationVmac)}, (Throwable)e);
        }
    }

    public synchronized void doAdvertisementSolicitationTimedOut() {
        if (this.advertisementSolicitationTicket != null) {
            this.cancelAdvertisementSolicitationTimer();
            this.getPeerInfo().setAdvertisementSolicitationStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.timedOut", new Object[0]));
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Advertisement Solicitation timed-out").toString());
            }
        }
    }

    public synchronized void handleAddressResolutionAck(AddressResolutionAck addressResolutionAck) {
        if (addressResolutionAck.getMessageId() != this.addressResolutionId) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Ignoring Address-Resolution-ACK that has message ID ").append(addressResolutionAck.getMessageId()).append(" instead of expected ID ").append(this.addressResolutionId).append("; message: ").append(addressResolutionAck).toString());
            }
            return;
        }
        this.cancelAddressResolutionTimer();
        BScNodeInfo peerInfo = this.getPeerInfo();
        peerInfo.setDirectUris(String.join((CharSequence)"\n", addressResolutionAck.getWebSocketUris()));
        peerInfo.setAcceptsDirectConnections(true);
        peerInfo.setAddressResolutionStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.success", new Object[0]));
    }

    public synchronized void handleAddressResolutionNak(ScBvlcResult bvlcResult) {
        if (bvlcResult.getMessageId() != this.addressResolutionId) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Ignoring Address-Resolution BVLC-Result-NAK that has message ID ").append(bvlcResult.getMessageId()).append(" instead of expected ID ").append(this.addressResolutionId).append("; message: ").append(bvlcResult).toString());
            }
            return;
        }
        this.cancelAddressResolutionTimer();
        BScNodeInfo peerInfo = this.getPeerInfo();
        int errorCode = bvlcResult.getErrorCode();
        if (errorCode == 45) {
            peerInfo.setAcceptsDirectConnections(false);
            peerInfo.setAddressResolutionStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.doesNotAcceptDirect", new Object[0]));
        } else {
            String tag = BBacnetErrorCode.tag(errorCode);
            peerInfo.setAddressResolutionStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.failed", errorCode, ScLinkLayerUtil.getLexiconText(tag, new Object[0])));
        }
    }

    public synchronized void handleAdvertisement(Advertisement advertisement) {
        this.cancelAdvertisementSolicitationTimer();
        BScNodeInfo peerInfo = this.getPeerInfo();
        peerInfo.setHubConnectorStatus(advertisement.getHubConnectionStatus());
        peerInfo.setAcceptsDirectConnections(advertisement.acceptsDirectConnections());
        peerInfo.setMaxBvlcLength(advertisement.getMaxBvlcLength());
        peerInfo.setMaxNpduLength(advertisement.getMaxNpduLength());
        peerInfo.setAdvertisementSolicitationStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.success", new Object[0]));
    }

    public synchronized void handleAdvertisementNak(ScBvlcResult bvlcResult) {
        if (bvlcResult.getMessageId() != this.advertisementSolicitationId) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(this.getLogInfo().append(": Ignoring Advertisement BVLC-Result-NAK that has message ID ").append(bvlcResult.getMessageId()).append(" instead of expected ID ").append(this.advertisementSolicitationId).append("; message: ").append(bvlcResult).toString());
            }
            return;
        }
        this.cancelAdvertisementSolicitationTimer();
        int errorCode = bvlcResult.getErrorCode();
        String tag = BBacnetErrorCode.tag(errorCode);
        this.getPeerInfo().setAdvertisementSolicitationStatus(ScLinkLayerUtil.getLexiconText("directInitiatingConnection.sendInfoMessageStatus.failed", errorCode, ScLinkLayerUtil.getLexiconText(tag, new Object[0])));
    }

    @Override
    protected void setRemoteAddress(BInternetAddress address) {
        this.setPeerAddress(address);
    }

    @Override
    protected void setRemoteVmac(long vmac) {
        this.setPeerVmac(VmacUtil.vmacToOctetString(vmac));
    }

    @Override
    protected void setRemoteUuid(UUID uuid) {
        this.setPeerUuid(BUuid.make((UUID)uuid));
    }

    @Override
    protected void setRemoteMaxBvlcLength(int maxBvlcLength) {
        this.setPeerMaxBvlcLength(maxBvlcLength);
    }

    @Override
    protected void setRemoteMaxNpduLength(int maxNpduLength) {
        this.setPeerMaxNpduLength(maxNpduLength);
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return BDirectInitiatingConnection.makeURI(this.getPeerUriAddress(), this.getPeerUriPath().trim(), this.getPeerUriQuery().trim());
    }

    @Override
    protected IScConnectionInitiator getConnectionInitiator() {
        return this.nodeSwitch;
    }

    @Override
    public String getLocalConnectionToken() {
        return null;
    }

    @Override
    public void clearLocalConnectionToken() {
    }

    public String toString(Context cx) {
        return this.getState().getDisplayTag(cx) + " [" + this.getPeerVmac().toString(cx) + ']';
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(peerUriQuery)) {
            return this;
        }
        return super.getPropertyValidator(property, context);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        for (Property property : properties) {
            if (!property.equals(peerUriQuery)) continue;
            return this;
        }
        return super.getPropertyValidator(properties, context);
    }

    public void validateSet(Validatable validatable, Context context) {
        for (Property property : validatable.getModifiedProperties()) {
            if (!property.equals(peerUriQuery)) continue;
            BDirectInitiatingConnection.checkUriQuery(((BString)validatable.getProposedValue(property)).getString());
        }
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property.equals(peerUriQuery)) {
            BDirectInitiatingConnection.checkUriQuery(((BString)newValue).getString());
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public StringBuilder getLogInfo() {
        long remoteVmac = this.getRemoteVmac();
        UUID remoteUuid = this.getRemoteUuid();
        if (remoteVmac != -1L && remoteUuid != null) {
            return new StringBuilder("Direct initiating connection, VMAC ").append(VmacUtil.vmacToString(remoteVmac)).append(", UUID ").append(remoteUuid);
        }
        return new StringBuilder("Direct initiating connection");
    }

    private void startAddressResolutionTimer() {
        if (this.isRunning()) {
            this.addressResolutionTicket = Clock.schedule((BComponent)this, (BRelTime)this.getPeerInfo().getAddressResolutionTimeout(), (Action)addressResolutionTimedOut, null);
        }
    }

    private void cancelAddressResolutionTimer() {
        Clock.Ticket ticket = this.addressResolutionTicket;
        if (ticket != null) {
            ticket.cancel();
        }
        this.addressResolutionTicket = null;
    }

    private void startAdvertisementSolicitationTimer() {
        if (this.isRunning()) {
            this.advertisementSolicitationTicket = Clock.schedule((BComponent)this, (BRelTime)this.getPeerInfo().getAdvertisementSolicitationTimeout(), (Action)advertisementSolicitationTimedOut, null);
        }
    }

    private void cancelAdvertisementSolicitationTimer() {
        Clock.Ticket ticket = this.advertisementSolicitationTicket;
        if (ticket != null) {
            ticket.cancel();
        }
        this.advertisementSolicitationTicket = null;
    }
}

