/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc.connection;

import com.tridium.bacnet.stack.link.sc.BAbstractConnectionManager;
import com.tridium.bacnet.stack.link.sc.ScLinkLayerUtil;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.web.BINiagaraWebServlet;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="servletName", type="String", defaultValue=""), @NiagaraProperty(name="webServiceOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"web:WebService\"")})})
public abstract class BAbstractScWebSocketAcceptor
extends BComponent
implements BINiagaraWebServlet,
BIRestrictedComponent {
    @Generated
    public static final Property servletName = BAbstractScWebSocketAcceptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property webServiceOrd = BAbstractScWebSocketAcceptor.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"web:WebService"));
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractScWebSocketAcceptor.class);
    private WeakReference<BWebService> webServiceRef = new WeakReference<Object>(null);
    private BAbstractConnectionManager parent;
    private String faultCause;

    @Generated
    public String getServletName() {
        return this.getString(servletName);
    }

    @Generated
    public void setServletName(String v) {
        this.setString(servletName, v, null);
    }

    @Generated
    public BOrd getWebServiceOrd() {
        return (BOrd)this.get(webServiceOrd);
    }

    @Generated
    public void setWebServiceOrd(BOrd v) {
        this.set(webServiceOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract void updateWebSocketSettings();

    public void started() throws Exception {
        super.started();
        this.parent = (BAbstractConnectionManager)this.getParent();
    }

    public void stopped() throws Exception {
        this.unregister();
        super.stopped();
    }

    public void linkCommStart() {
        this.register();
    }

    public void linkCommStop() {
        this.unregister();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && (property.equals(servletName) || property.equals(webServiceOrd))) {
            this.unregister();
            this.register();
        }
    }

    private void register() {
        if (this.parent == null || this.parent.isFatalFault() || this.parent.getStatus().isDisabled() || !this.parent.acceptEnabled()) {
            return;
        }
        BWebService webService = this.getWebService();
        if (webService == null) {
            return;
        }
        BWebServer webServer = webService.getWebServer();
        if (webServer == null) {
            this.getLogger().log(Level.FINE, "WebService does not contain a WebServer on which to register WebSocketAcceptor");
            this.configFail("webSocketAcceptor.webServiceMissingWebServer", new Object[0]);
            return;
        }
        try {
            webServer.register((BINiagaraWebServlet)this);
            this.webServiceRef = new WeakReference<BWebService>(webService);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to register WebSocketAcceptor", e);
            this.configFail("webSocketAcceptor.couldNotRegister", new Object[0]);
        }
    }

    private void unregister() {
        BWebService webService = (BWebService)this.webServiceRef.get();
        this.webServiceRef.clear();
        if (webService == null) {
            this.getLogger().fine("Did not unregister WebSocketAcceptor: not previously registered");
            return;
        }
        BWebServer webServer = webService.getWebServer();
        if (webServer == null) {
            this.getLogger().fine("Failed to unregister WebSocketAcceptor: WebService does not contain a WebServer on which to unregister WebSocketAcceptor");
            return;
        }
        try {
            webServer.unregister((BINiagaraWebServlet)this);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Failed to unregister WebSocketAcceptor", e);
        }
    }

    public void setValidServletName(boolean valid) {
        if (valid) {
            this.configOk();
        } else {
            this.configFail("webSocketAcceptor.couldNotRegister", new Object[0]);
        }
    }

    public final BWebService getWebService() {
        BOrd ord = this.getWebServiceOrd();
        if (!ord.isNull()) {
            if (!ScLinkLayerUtil.areOrdSchemesValid(ord)) {
                String allowedOrdQuerySchemes = String.join((CharSequence)", ", ScLinkLayerUtil.ALLOWED_ORD_QUERY_SCHEMES);
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().fine("WebService ord " + ord + " contains an ord query scheme not in the allowed list: " + allowedOrdQuerySchemes);
                }
                this.configFail("webSocketAcceptor.disallowedOrdScheme", allowedOrdQuerySchemes);
                return null;
            }
            try {
                return (BWebService)ord.get((BObject)this);
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Failed to find WebService at " + ord, e);
                this.configFail("webSocketAcceptor.couldNotResolveWebService", new Object[0]);
            }
        } else {
            try {
                return (BWebService)Sys.getService((Type)BWebService.TYPE);
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Failed to find default WebService", e);
                this.configFail("webSocketAcceptor.couldNotResolveWebService", new Object[0]);
            }
        }
        return null;
    }

    private Logger getLogger() {
        return this.parent != null ? this.parent.getLogger() : Logger.getLogger("bacnet.sc.webSocketAcceptor");
    }

    public String getFaultCause() {
        return this.faultCause;
    }

    private void configFail(String key, Object ... args) {
        this.faultCause = ScLinkLayerUtil.LEXICON.getText(key, null, args);
        this.parent.updateStatus();
    }

    private void configOk() {
        this.faultCause = null;
        this.parent.updateStatus();
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!(parent instanceof BAbstractConnectionManager)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        ScLinkLayerUtil.checkForDuplicate(this, parent);
    }
}

