/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.sc;

import com.tridium.bacnet.stack.link.sc.connection.BAbstractConnection;
import com.tridium.bacnet.stack.link.sc.connection.BAcceptingConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableIdleCleanup", type="boolean", defaultValue="true"), @NiagaraProperty(name="idleCleanupInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)", facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.FALSE"), @Facet(name="BFacets.MIN", value="BRelTime.make(0)")})})
@NiagaraAction(name="cleanupIdle", flags=2068)
public abstract class BConnectionContainer
extends BComponent {
    @Generated
    public static final Property enableIdleCleanup = BConnectionContainer.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property idleCleanupInterval = BConnectionContainer.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L))));
    @Generated
    public static final Action cleanupIdle = BConnectionContainer.newAction((int)2068, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConnectionContainer.class);
    private Clock.Ticket waitTicket;

    @Generated
    public boolean getEnableIdleCleanup() {
        return this.getBoolean(enableIdleCleanup);
    }

    @Generated
    public void setEnableIdleCleanup(boolean v) {
        this.setBoolean(enableIdleCleanup, v, null);
    }

    @Generated
    public BRelTime getIdleCleanupInterval() {
        return (BRelTime)this.get(idleCleanupInterval);
    }

    @Generated
    public void setIdleCleanupInterval(BRelTime v) {
        this.set(idleCleanupInterval, (BValue)v, null);
    }

    @Generated
    public void cleanupIdle() {
        this.invoke(cleanupIdle, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private void scheduleIdleCleanup() {
        if (!this.isRunning() || !this.getEnableIdleCleanup()) {
            return;
        }
        if (this.waitTicket == null && this.getIdleCleanupInterval().getMillis() > 0L) {
            this.waitTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getIdleCleanupInterval(), (Action)cleanupIdle, null);
        }
    }

    private void cancelIdleCleanup() {
        if (this.waitTicket != null) {
            this.waitTicket.cancel();
        }
        this.waitTicket = null;
    }

    boolean shouldCleanupImmediately() {
        return this.getEnableIdleCleanup() && this.getIdleCleanupInterval().getMillis() == 0L;
    }

    public abstract Logger getLogger();

    public void doCleanupIdle() {
        if (!this.isRunning() || !this.getEnableIdleCleanup()) {
            return;
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Connection container running periodic idle accepting connection cleanup (interval: " + this.getIdleCleanupInterval() + ')');
        }
        BAbsTime thresholdTime = BAbsTime.make((long)(BAbsTime.now().getMillis() - this.getIdleCleanupInterval().getMillis()));
        for (BAcceptingConnection connection : (BAcceptingConnection[])this.getChildren(BAcceptingConnection.class)) {
            if (!BConnectionContainer.shouldRemove(connection, thresholdTime)) continue;
            this.remove((BComplex)connection);
            if (!this.getLogger().isLoggable(Level.FINE)) continue;
            this.getLogger().fine(connection.getLogInfo().append(": Removed by idle accepting connection cleanup.").toString());
        }
    }

    public final void doDisconnectAll() {
        if (!this.isRunning()) {
            return;
        }
        this.getLogger().fine("Connection container calling disconnect on all child connections.");
        for (BAbstractConnection connection : (BAbstractConnection[])this.getChildren(BAbstractConnection.class)) {
            if (!connection.isConnected()) continue;
            connection.disconnect();
        }
    }

    public final void doRemoveAllIdleAccepted() {
        if (!this.isRunning()) {
            return;
        }
        this.getLogger().fine("Connection container removing all child idle accepted connections.");
        for (BAcceptingConnection connection : (BAcceptingConnection[])this.getChildren(BAcceptingConnection.class)) {
            if (!connection.isIdle()) continue;
            this.remove((BComplex)connection);
        }
    }

    public final void started() {
        this.scheduleIdleCleanup();
    }

    public final void changed(Property property, Context context) {
        if (property.equals(enableIdleCleanup) || property.equals(idleCleanupInterval)) {
            int currentFlags = this.getFlags((Slot)idleCleanupInterval);
            if (this.getEnableIdleCleanup()) {
                this.setFlags((Slot)idleCleanupInterval, currentFlags & 0xFFFFFFFE);
                if (this.getIdleCleanupInterval().getMillis() == 0L) {
                    this.doCleanupIdle();
                }
            } else {
                this.setFlags((Slot)idleCleanupInterval, currentFlags | 1);
            }
            this.cancelIdleCleanup();
            this.scheduleIdleCleanup();
        }
    }

    public final void stopped() {
        this.cancelIdleCleanup();
    }

    private static boolean shouldRemove(BAcceptingConnection connection, BAbsTime thresholdTime) {
        return connection.isIdle() && (BConnectionContainer.isBefore(connection.getLastDisconnect(), thresholdTime) || BConnectionContainer.isBefore(connection.getLastFailureToConnect(), thresholdTime));
    }

    private static boolean isBefore(BAbsTime connectionTime, BAbsTime thresholdTime) {
        return connectionTime != null && !connectionTime.isNull() && connectionTime.isBefore(thresholdTime);
    }
}

