/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.ip.BvllMessage;
import com.tridium.bacnet.stack.link.ip.DeleteForeignDeviceTableEntry;
import com.tridium.bacnet.stack.link.ip.RegisterForeignDevice;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.net.InetAddress;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=64), @NiagaraProperty(name="bbmdAddress", type="String", defaultValue="BForeignDeviceRegistration.BBMD_ADDRESS_DEFAULT"), @NiagaraProperty(name="registrationLifetime", type="BRelTime", defaultValue="BRelTime.make(15 * BRelTime.MILLIS_IN_MINUTE)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(BRelTime.MILLIS_IN_MINUTE)")})})
@NiagaraActions(value={@NiagaraAction(name="registerWithBBMD"), @NiagaraAction(name="unregisterWithBBMD")})
public class BForeignDeviceRegistration
extends BComponent {
    @Generated
    public static final Property enabled = BForeignDeviceRegistration.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Property bbmdAddress = BForeignDeviceRegistration.newProperty((int)0, (String)"null", null);
    @Generated
    public static final Property registrationLifetime = BForeignDeviceRegistration.newProperty((int)0, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)60000L)));
    @Generated
    public static final Action registerWithBBMD = BForeignDeviceRegistration.newAction((int)0, null);
    @Generated
    public static final Action unregisterWithBBMD = BForeignDeviceRegistration.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BForeignDeviceRegistration.class);
    private String oldAddress = null;
    private Clock.Ticket registrationTicket = null;
    private static final int REG_OVERLAP_MS = 30000;
    private static final String BBMD_ADDRESS_DEFAULT = "null";
    private static final Log log = Log.getLog((String)"bacnet.link.ip");
    private static Object FD_TICKET_LOCK = new Object();

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getBbmdAddress() {
        return this.getString(bbmdAddress);
    }

    @Generated
    public void setBbmdAddress(String v) {
        this.setString(bbmdAddress, v, null);
    }

    @Generated
    public BRelTime getRegistrationLifetime() {
        return (BRelTime)this.get(registrationLifetime);
    }

    @Generated
    public void setRegistrationLifetime(BRelTime v) {
        this.set(registrationLifetime, (BValue)v, null);
    }

    @Generated
    public void registerWithBBMD() {
        this.invoke(registerWithBBMD, null, null);
    }

    @Generated
    public void unregisterWithBBMD() {
        this.invoke(unregisterWithBBMD, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BForeignDeviceRegistration() {
    }

    public BForeignDeviceRegistration(String bbmdAddress) {
        this(bbmdAddress, null);
    }

    public BForeignDeviceRegistration(String bbmdAddress, BRelTime registrationLifetime) {
        this.setBbmdAddress(bbmdAddress);
        this.setRegistrationLifetime(registrationLifetime);
    }

    public BBacnetIpLinkLayer linklayer() {
        return (BBacnetIpLinkLayer)this.getParent();
    }

    public BNetworkPort port() {
        return (BNetworkPort)this.linklayer().getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetIpLinkLayer;
    }

    public void started() throws Exception {
        if (this.isRunning() && Sys.atSteadyState()) {
            this.doRegisterWithBBMD();
        }
    }

    public void stopped() throws Exception {
        if (this.isRunning() && this.getEnabled()) {
            this.doUnregisterWithBBMD();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning()) {
            if (p.equals(enabled) && cx != BacnetConst.noWrite) {
                if (this.getEnabled()) {
                    this.doRegisterWithBBMD();
                } else {
                    this.doUnregisterWithBBMD();
                }
            } else if (p.equals(bbmdAddress)) {
                if (this.oldAddress != null) {
                    this.unregister(this.oldAddress);
                    this.doRegisterWithBBMD();
                }
            } else if (p.equals(registrationLifetime) && this.getEnabled()) {
                this.cancelTicket();
                this.startTicket();
                this.doRegisterWithBBMD();
            }
        }
    }

    public void doRegisterWithBBMD() {
        this.register(this.getBbmdAddress());
    }

    public void doUnregisterWithBBMD() {
        this.unregister(this.getBbmdAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTicket() {
        Object object = FD_TICKET_LOCK;
        synchronized (object) {
            if (this.registrationTicket != null) {
                this.registrationTicket.cancel();
            }
            this.registrationTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getOverlappingInterval(), (Action)registerWithBBMD, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTicket() {
        Object object = FD_TICKET_LOCK;
        synchronized (object) {
            if (this.registrationTicket != null) {
                this.registrationTicket.cancel();
                this.registrationTicket = null;
            }
        }
    }

    private boolean ticketExpired() {
        return this.registrationTicket == null || this.registrationTicket.isExpired();
    }

    private BRelTime getOverlappingInterval() {
        return BRelTime.make((long)Math.max(this.getRegistrationLifetime().getMillis() - 30000L, 30000L));
    }

    protected void register(String address) {
        this.oldAddress = address;
        if (BBacnetNetwork.bacnet().getEnabled()) {
            try {
                if (log.isTraceOn()) {
                    log.trace("Registering with BBMD at IP:" + address);
                }
                this.sendBvll(address, new RegisterForeignDevice(this.getRegistrationLifetime().getSeconds()));
                this.startTicket();
                this.set(enabled, (BValue)BBoolean.TRUE, BacnetConst.noWrite);
            }
            catch (Exception e) {
                log.warning("Unable to send foreign device registration", (Throwable)e);
            }
        }
    }

    protected void unregister(String address) {
        this.cancelTicket();
        if (BBacnetNetwork.bacnet().getEnabled()) {
            this.sendBvll(address, new DeleteForeignDeviceTableEntry(this.getLocalMacAddress()));
            this.set(enabled, (BValue)BBoolean.FALSE, BacnetConst.noWrite);
        }
    }

    protected void sendBvll(BvllMessage message) {
        this.sendBvll(this.getBbmdAddress(), message);
    }

    protected void sendBvll(String address, BvllMessage message) {
        try {
            byte[] bbmdMacAddr = this.getMacBytes(address);
            if (bbmdMacAddr != null && bbmdMacAddr.length == 6) {
                InetAddress addr = this.linklayer().lookupInetAddr(bbmdMacAddr);
                if (addr != null) {
                    int port = BBacnetIpLinkLayer.getPort(bbmdMacAddr);
                    if (log.isTraceOn()) {
                        log.trace("Sending BVLL message to " + address);
                    }
                    this.sendBvllMessage(addr, port, message);
                }
            } else if (log.isTraceOn()) {
                log.trace("unable Sending BVLL message to " + address);
            }
        }
        catch (Exception e) {
            log.warning("Unable to send bvll message", (Throwable)e);
        }
    }

    protected void sendBvllMessage(InetAddress inet, int port, BvllMessage msg) {
        this.linklayer().sendBvllMessage(inet, port, msg);
    }

    protected byte[] getMacBytes(String address) {
        return BBacnetIpLinkLayer.getMacBytes(address);
    }

    protected byte[] getLocalMacAddress() {
        return this.linklayer().getMac();
    }
}

