/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BBacnetScheduleTypeChangeJob
extends BDeviceManagerJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScheduleTypeChangeJob.class);
    BBacnetScheduleExport expSch;
    BBacnetChangeTypeParm params;
    static Lexicon lex = Lexicon.make((String)"bacnet");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetScheduleTypeChangeJob() {
    }

    public BBacnetScheduleTypeChangeJob(BBacnetNetwork bacnet, BBacnetScheduleExport s, BBacnetChangeTypeParm p) {
        super(bacnet);
        this.expSch = s;
        this.params = p;
    }

    public void run(Context cx) throws Exception {
        BBacnetObjectIdentifier objectId = this.expSch.getObjectId();
        BBacnetAddress adr = ((BBacnetDevice)this.expSch.getDevice()).getAddress();
        try {
            BBacnetArray ba;
            byte[] encodedValue;
            if (this.params.getOprChanged()) {
                BBacnetListOf bl = this.params.getListOfObjectPropertyRefs();
                encodedValue = AsnUtil.toAsn(-3, (BValue)bl);
                try {
                    this.client().writeProperty(adr, objectId, 54, encodedValue);
                    this.log().message("Changed ListOfObjectPropertyRefs ");
                }
                catch (Exception e) {
                    this.log().failed("Failed to change ListOfObjectPropertyRefs: ", (Throwable)e);
                }
            }
            if (this.params.getSchedDefChanged()) {
                BBacnetAny sd = this.params.getScheduleDefault();
                encodedValue = AsnUtil.toAsn(-4, (BValue)sd);
                try {
                    this.client().writeProperty(adr, objectId, 174, encodedValue);
                    this.log().message("Changed ScheduleDefault ");
                }
                catch (Exception e) {
                    this.log().failed("Failed to change ScheduleDefault: ", (Throwable)e);
                }
            }
            if (this.params.getSuperChanged()) {
                this.expSch.setSupervisorOrd(this.params.getSupervisorOrd());
                this.log().message("Changed SupervisorOrd");
            }
            this.expSch.setDataType(this.params.getDataType());
            if (this.params.getHasWeeklySchedule() && this.params.getWeeklyChanged()) {
                ba = this.params.getWeeklySchedule();
                encodedValue = AsnUtil.toAsn(-2, (BValue)ba);
                try {
                    this.client().writeProperty(adr, objectId, 123, encodedValue);
                    this.log().message("Changed WeeklySchedule ");
                }
                catch (Exception e) {
                    this.log().failed("Failed to change WeeklySchedule: ", (Throwable)e);
                }
            }
            if (this.params.getHasExceptionSchedule() && this.params.getExceptionChanged()) {
                ba = this.params.getExceptionSchedule();
                encodedValue = AsnUtil.toAsn(-2, (BValue)ba);
                try {
                    this.client().writeProperty(adr, objectId, 38, encodedValue);
                    this.log().message("Changed ExceptionSchedule ");
                }
                catch (Exception e) {
                    this.log().failed("Failed to change ExceptionSchedule: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(e.toString());
            throw e;
        }
    }
}

