/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="stopTime", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()")})
public class BBacnetActivePeriod
extends BActivePeriod {
    @Generated
    public static final Property startTime = BBacnetActivePeriod.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property stopTime = BBacnetActivePeriod.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetActivePeriod.class);

    @Generated
    public BBacnetDateTime getStartTime() {
        return (BBacnetDateTime)this.get(startTime);
    }

    @Generated
    public void setStartTime(BBacnetDateTime v) {
        this.set(startTime, (BValue)v, null);
    }

    @Generated
    public BBacnetDateTime getStopTime() {
        return (BBacnetDateTime)this.get(stopTime);
    }

    @Generated
    public void setStopTime(BBacnetDateTime v) {
        this.set(stopTime, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isAlwaysActive() {
        return false;
    }

    public boolean isNeverActive() {
        return false;
    }

    public BAbsTime getActiveStart(BAbsTime time) {
        return BAbsTime.make((BAbsTime)time, (BTime)BTime.make((int)0, (int)0, (int)0, (int)0));
    }

    public BAbsTime getActiveEnd(BAbsTime time) {
        BAbsTime start = this.getStartTime().toBAbsTime();
        BAbsTime end = this.getStopTime().toBAbsTime();
        if (time.isBefore(start)) {
            return null;
        }
        if (time.isAfter(end)) {
            return null;
        }
        return end;
    }

    public BAbsTime getNextActive(BAbsTime time) {
        BAbsTime active = this.getStartTime().toBAbsTime();
        if (active.isAfter(time)) {
            return active;
        }
        return null;
    }

    public BAbsTime getNextInactive(BAbsTime time) {
        BAbsTime inactive = this.getStopTime().toBAbsTime();
        if (inactive.isAfter(time)) {
            return inactive;
        }
        return null;
    }

    public boolean isActive(BAbsTime timestamp) {
        BBacnetDateTime ts = new BBacnetDateTime(timestamp);
        return ts.isNotBefore(this.getStartTime()) && ts.isNotAfter(this.getStopTime());
    }
}

