/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import com.tridium.bacnet.asn.NErrorType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BTrendEvent
extends BSimple {
    public static final long NO_EVENT = 0L;
    public static final long LOG_STATUS_EVENT = 0x100000000L;
    public static final long FAILURE_EVENT = 0x200000000L;
    public static final long TIME_CHANGE_EVENT = 0x400000000L;
    public static final long INVALID_EVENT = 0x800000000L;
    private static final long LOG_DISABLED_BIT = 1L;
    private static final long BUFFER_PURGED_BIT = 2L;
    private static final long LOG_INTERRUPTED_BIT = 4L;
    private static final BTrendEvent ZERO;
    public static final BTrendEvent DEFAULT;
    public static final Type TYPE;
    private static final boolean[] LS_ENABLE;
    private static final boolean[] LS_DISABLE;
    private static final boolean[] LS_ENABLE_PURGE;
    private static final boolean[] LS_DISABLE_PURGE;
    private static final boolean[] LS_INTERRUPTED;
    public static final BTrendEvent LOG_STATUS_ENABLED;
    public static final BTrendEvent LOG_STATUS_DISABLED;
    public static final BTrendEvent LOG_STATUS_ENABLED_BUFFER_PURGED;
    public static final BTrendEvent LOG_STATUS_DISABLED_BUFFER_PURGED;
    public static final BTrendEvent LOG_STATUS_INTERRUPTED;
    private long value;

    public static BTrendEvent make() {
        return BTrendEvent.make(0L);
    }

    public static BTrendEvent makeLogStatus(BBacnetBitString val) {
        long value = 0x100000000L;
        if (val == null) {
            return BTrendEvent.make(value | 0x800000000L);
        }
        boolean[] bits = val.getBits();
        if (bits.length < 2) {
            value |= 0x800000000L;
        }
        for (int i = 0; i < bits.length; ++i) {
            if (i >= 32) {
                value |= 0x800000000L;
                break;
            }
            if (!bits[i]) continue;
            value |= 1L << i;
        }
        return BTrendEvent.make(value);
    }

    public static BTrendEvent makeFailure(NErrorType val) {
        long value = 0x200000000L;
        if (val == null) {
            return BTrendEvent.make(value | 0x800000000L);
        }
        long errorClass = 0xFFFF & val.getErrorClass();
        long errorCode = 0xFFFF & val.getErrorCode();
        long temp = 0L;
        temp |= errorClass;
        temp <<= 16;
        return BTrendEvent.make(value |= (temp |= errorCode));
    }

    public static BTrendEvent makeTimeChange(long val) {
        long value = 0x400000000L;
        long seconds = 0xFFFFFFFFL & val;
        return BTrendEvent.make(value |= seconds);
    }

    public static BTrendEvent make(long value) {
        if (value == 0L) {
            return ZERO;
        }
        return new BTrendEvent(value);
    }

    public static BTrendEvent make(String value) {
        return BTrendEvent.make(BTrendEvent.decode(value));
    }

    private BTrendEvent(long value) {
        this.value = value;
    }

    public boolean getBit(long event) {
        return (this.value & event) != 0L;
    }

    public static boolean getBit(long event, long val) {
        return (val & event) != 0L;
    }

    public long getLong() {
        return this.value;
    }

    public int getInt() {
        return (int)this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BTrendEvent) {
            return ((BTrendEvent)((Object)obj)).value == this.value;
        }
        return false;
    }

    public int compareTo(Object obj) {
        long a = this.value;
        long b = ((BNumber)obj).getLong();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public String toString(Context context) {
        return BTrendEvent.encode(this.value);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    public BObject decode(DataInput in) throws IOException {
        return BTrendEvent.make(in.readLong());
    }

    public String encodeToString() throws IOException {
        return BTrendEvent.encode(this.value);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BTrendEvent.make(BTrendEvent.decode(s));
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid BTrendEvent: " + s);
        }
    }

    public static long decode(String s) {
        if (s == null) {
            return 0L;
        }
        int endSearch = s.lastIndexOf(58);
        if (endSearch <= 0) {
            return 0L;
        }
        return Long.parseLong(s.substring(endSearch + 1));
    }

    public static String encode(long x) {
        if (x == 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int eventType = 0;
        if (BTrendEvent.getBit(0x800000000L, x)) {
            sb.append(BBacnetLogRecord.INVALID_STRING + " ");
            eventType = -1;
        }
        if (BTrendEvent.getBit(0x100000000L, x)) {
            sb.append(BBacnetLogRecord.LOG_STATUS_STRING + " ");
            if (eventType >= 0) {
                eventType = 1;
            } else {
                sb.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else if (BTrendEvent.getBit(0x200000000L, x)) {
            sb.append(BBacnetLogRecord.FAILURE_STRING + " ");
            if (eventType >= 0) {
                eventType = 2;
            } else {
                sb.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else if (BTrendEvent.getBit(0x400000000L, x)) {
            sb.append(BBacnetLogRecord.TIME_CHANGE_STRING + " ");
            if (eventType >= 0) {
                eventType = 3;
            } else {
                sb.append(BBacnetLogRecord.EVENT_STRING);
            }
        } else {
            sb.append(BBacnetLogRecord.UNKNOWN_STRING + BBacnetLogRecord.EVENT_STRING);
        }
        switch (eventType) {
            case 1: {
                if (BTrendEvent.getBit(1L, x)) {
                    sb.append(BBacnetLogRecord.LOG_DISABLED_STRING + " ");
                } else {
                    sb.append(BBacnetLogRecord.LOG_ENABLED_STRING + " ");
                }
                if (BTrendEvent.getBit(2L, x)) {
                    sb.append(BBacnetLogRecord.LOG_BUFFER_PURGED_STRING + " ");
                }
                if (!BTrendEvent.getBit(4L, x)) break;
                sb.append(BBacnetLogRecord.LOG_INTERRUPTED_STRING);
                break;
            }
            case 2: {
                int errorCode = (int)(0xFFFFL & x);
                int errorClass = (int)(0xFFFFFFFFFFFF0000L & x) >> 16;
                sb.append("(" + BBacnetErrorClass.tag(errorClass) + ", " + BBacnetErrorCode.tag(errorCode) + ")");
                break;
            }
            case 3: {
                int seconds = (int)(0xFFFFFFFFFFFFFFFFL & x);
                sb.append(String.valueOf(seconds) + " " + BBacnetLogRecord.SECONDS_STRING);
                break;
            }
        }
        sb.append(':' + String.valueOf(x));
        return sb.toString();
    }

    public boolean isLogStatus() {
        return (this.value & 0x100000000L) != 0L;
    }

    public boolean isFailure() {
        return (this.value & 0x200000000L) != 0L;
    }

    public boolean isTimeChange() {
        return (this.value & 0x400000000L) != 0L;
    }

    public BBacnetBitString getLogStatus() {
        boolean[] logStatusFlags = new boolean[]{this.getBit(1L), this.getBit(2L), this.getBit(4L)};
        return BBacnetBitString.make(logStatusFlags);
    }

    public boolean isLogDisabled() {
        return this.isLogStatus() && this.getBit(1L);
    }

    public NErrorType getFailure() {
        int errorCode = (int)(0xFFFFL & this.value);
        int errorClass = (int)(0xFFFFFFFFFFFF0000L & this.value) >> 16;
        return new NErrorType(errorClass, errorCode);
    }

    public float getTimeChange() {
        return 0xFFFFFFFFFFFFFFFFL & this.value;
    }

    public static BBacnetBitString getLogStatus(long event) {
        boolean[] logStatusFlags = new boolean[]{(event & 1L) != 0L, (event & 2L) != 0L, (event & 4L) != 0L};
        return BBacnetBitString.make(logStatusFlags);
    }

    public static NErrorType getFailure(long event) {
        int errorCode = (int)(0xFFFFL & event);
        int errorClass = (int)(0xFFFFFFFFFFFF0000L & event) >> 16;
        return new NErrorType(errorClass, errorCode);
    }

    public static float getTimeChange(long event) {
        return 0xFFFFFFFFL & event;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = ZERO = new BTrendEvent(0L);
        TYPE = Sys.loadType(BTrendEvent.class);
        LS_ENABLE = new boolean[]{false, false, false};
        LS_DISABLE = new boolean[]{true, false, false};
        LS_ENABLE_PURGE = new boolean[]{false, true, false};
        LS_DISABLE_PURGE = new boolean[]{true, true, false};
        LS_INTERRUPTED = new boolean[]{false, false, true};
        LOG_STATUS_ENABLED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_ENABLE));
        LOG_STATUS_DISABLED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_DISABLE));
        LOG_STATUS_ENABLED_BUFFER_PURGED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_ENABLE_PURGE));
        LOG_STATUS_DISABLED_BUFFER_PURGED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_DISABLE_PURGE));
        LOG_STATUS_INTERRUPTED = BTrendEvent.makeLogStatus(BBacnetBitString.make(LS_INTERRUPTED));
    }
}

