/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetPropertyValue;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BEnum;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class ChangeOfReliability
extends BacnetNotificationParameters {
    public static final int RELIABILITY_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    public static final int PROPERTY_VALUES_TAG = 2;
    private BBacnetReliability reliability = BBacnetReliability.DEFAULT;
    private BBacnetBitString statusFlags = BacnetBitStringUtil.getBacnetStatusFlags(BStatus.ok);
    private BBacnetPropertyValue[] values;

    public ChangeOfReliability() {
    }

    public ChangeOfReliability(BBacnetReliability reliability, BBacnetBitString statusFlags, BBacnetPropertyValue[] values) {
        this.reliability = reliability;
        this.statusFlags = statusFlags;
        this.values = values;
    }

    @Override
    public int getChoiceType() {
        return 19;
    }

    public BBacnetReliability getReliability() {
        return this.reliability;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public BBacnetPropertyValue[] getPropertyValues() {
        return this.values;
    }

    @Override
    public void writeEncoded(AsnOutputStream out) {
        out.writeOpeningTag(19);
        out.writeEnumerated(0, (BEnum)this.reliability);
        out.writeBitString(1, this.statusFlags);
        out.writeOpeningTag(2);
        if (this.values != null && this.values.length > 0) {
            for (BBacnetPropertyValue value : this.values) {
                value.writeAsn(out);
            }
        }
        out.writeClosingTag(2);
        out.writeClosingTag(19);
    }

    @Override
    public void readEncoded(AsnInputStream in) throws AsnException {
        this.readEncoded(null, in);
    }

    @Override
    public void readEncoded(BBacnetObjectIdentifier deviceId, AsnInputStream in) throws AsnException {
        in.skipOpeningTag(19);
        BBacnetReliability reliability = BBacnetReliability.make(in.readEnumerated(0));
        BBacnetBitString statusFlags = in.readBitString(1);
        in.skipOpeningTag(2);
        int tag = in.peekTag();
        ArrayList<BBacnetPropertyValue> values = new ArrayList<BBacnetPropertyValue>();
        while (!in.isClosingTag(2)) {
            if (tag == -1) {
                throw new AsnException("Invalid tag: " + tag);
            }
            BBacnetPropertyValue value = new BBacnetPropertyValue();
            value.readAsn(in);
            values.add(value);
            tag = in.peekTag();
        }
        in.skipClosingTag(2);
        in.skipClosingTag(19);
        this.reliability = reliability;
        this.statusFlags = statusFlags;
        this.values = values.toArray(new BBacnetPropertyValue[0]);
    }

    @Override
    public String toString(Context cx) {
        if (cx != null && cx.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("  change-of-reliability\n");
        sb.append("    ").append(BBacnetReliability.tag(this.reliability.getOrdinal())).append("    ").append((Object)this.statusFlags);
        if (this.values != null) {
            sb.append("    ").append(Arrays.toString(this.values));
        }
        return sb.toString();
    }

    @Override
    public String toFacetString() {
        StringBuilder sb = new StringBuilder("evtVals");
        sb.append(".reliability.").append(BBacnetReliability.tag(this.reliability.getOrdinal())).append(".statusFlags.").append((Object)this.statusFlags).append(".values");
        if (this.values != null) {
            for (BBacnetPropertyValue value : this.values) {
                sb.append(".propVal");
                ChangeOfReliability.valueToFacetString(value, sb);
            }
        }
        sb.append(".endValues");
        return sb.toString();
    }

    private static void valueToFacetString(BBacnetPropertyValue v, StringBuilder sb) {
        sb.append(".id.").append(BBacnetPropertyIdentifier.tag(v.getPropertyId()));
        int index = v.getPropertyArrayIndex();
        if (index != -1) {
            sb.append(".index.").append(index);
        }
        byte[] bytes = v.getPropertyValue();
        sb.append(".val.");
        try {
            BValue value = AsnUtil.asnToValue(bytes);
            if (value instanceof BSimple) {
                sb.append(value.toString(BacnetConst.facetsContext));
            } else {
                sb.append(ByteArrayUtil.toHexString((byte[])bytes));
            }
        }
        catch (AsnException e) {
            sb.append(ByteArrayUtil.toHexString((byte[])bytes));
        }
        int priority = v.getPriority();
        if (priority != -1) {
            sb.append(".pri.").append(priority);
        }
    }

    @Override
    public void addAlarmData(HashMap<String, ? super BIDataValue> map) {
        map.put("accessEvent", (BIDataValue)BString.make((String)String.valueOf(this.reliability)));
        map.put("statusFlags", (BIDataValue)BString.make((String)String.valueOf((Object)this.statusFlags)));
        map.put("propertyValues", (BIDataValue)BString.make((String)String.valueOf(this.getValues(this.values))));
    }

    private StringBuffer getValues(BBacnetPropertyValue[] values) {
        if (values == null) {
            return null;
        }
        StringBuffer propertyValues = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                propertyValues.append(values[i].getValue());
                continue;
            }
            propertyValues.append(", " + values[i].getValue());
        }
        return propertyValues;
    }
}

