/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.se;

import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.email.MailPlatformHandler;
import java.security.AccessController;
import java.util.Properties;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailClientAuthenticator;
import javax.baja.email.BIncomingAccount;
import javax.baja.email.BOutgoingAccount;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Sys;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.net.SocketFactory;

public final class MailPlatformHandlerSe
extends MailPlatformHandler {
    @Override
    public Session getIncomingSession(BIncomingAccount acct, String type) throws Exception {
        BEmailClientAuthenticator emailClientAuthenticator = (BEmailClientAuthenticator)acct.getEmailAuthenticator().make();
        Properties properties = new Properties();
        emailClientAuthenticator.setIncomingAuthenticationProperties(properties, type);
        if (acct.getDebug()) {
            properties.put("mail.debug", "true");
            System.err.println("*** type = " + type);
        }
        properties.put("mail." + type + ".host", acct.getHostname());
        properties.put("mail." + type + ".port", "" + acct.getPort());
        properties.put("mail." + type + ".socketFactory.port", "" + acct.getPort());
        properties.put("mail." + type + ".socketFactory.fallback", "true");
        if (acct.getUseSsl() || acct.getUseStartTls()) {
            if (acct.getUseSsl()) {
                properties.put("mail." + type + ".ssl.enable", "true");
            } else if (acct.getUseStartTls()) {
                properties.put("mail." + type + ".starttls.enable", "true");
            }
            properties.put("mail." + type + ".socketFactory.fallback", "false");
            ICryptoManager mgr = CertManagerFactory.getInstance();
            ClientTlsParameters clientTlsParms = new ClientTlsParameters(acct.getTlsMinProtocol().getTag());
            SocketFactory factory = mgr.getClientSocketFactory(clientTlsParms);
            properties.put("mail." + type + ".ssl.socketFactory", factory);
            properties.put("mail." + type + ".ssl.socketFactory.port", "" + acct.getPort());
            properties.put("mail." + type + ".ssl.protocols", MailPlatformHandlerSe.getConfiguredTlsMinimumProtocolVersions(acct));
        }
        if (type.equals("pop3")) {
            properties.put("mail.pop3.rsetbeforequit", "" + (acct.getDeliveryPolicy() != BDeliveryPolicy.delete));
        }
        Session session = AccessController.doPrivileged(() -> Session.getInstance((Properties)properties, (Authenticator)emailClientAuthenticator.getAuthenticator()));
        if (acct.getDebug()) {
            session.setDebug(true);
            session.setDebugOut(System.out);
        }
        return session;
    }

    @Override
    public Session getOutgoingSession(BOutgoingAccount acct) throws Exception {
        BEmailClientAuthenticator emailClientAuthenticator = (BEmailClientAuthenticator)acct.getEmailAuthenticator().make();
        int timeout = Long.valueOf(acct.getConnectionTimeout().getMillis()).intValue();
        String port = String.valueOf(acct.getPort());
        Properties props = new Properties();
        emailClientAuthenticator.setOutgoingAuthenticationProperties(props);
        if (acct.getDebug()) {
            props.put("mail.debug", "true");
        }
        props.put("mail.smtp.localhost", AccessController.doPrivileged(() -> System.getProperty("mail.smtp.localhost", Sys.getHostName())));
        props.put("mail.smtp.host", acct.getHostname());
        props.put("mail.smtp.port", "" + port);
        props.put("mail.smtp.socketFactory.port", port);
        props.put("mail.smtp.socketFactory.fallback", "true");
        props.put("mail.smtp.connectiontimeout", String.valueOf(timeout));
        props.put("mail.smtp.timeout", String.valueOf(timeout));
        if (acct.getUseSsl() || acct.getUseStartTls()) {
            if (acct.getUseSsl()) {
                props.put("mail.smtp.ssl.enable", "true");
            }
            if (acct.getUseStartTls()) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
            ICryptoManager mgr = CertManagerFactory.getInstance();
            ClientTlsParameters clientTlsParms = new ClientTlsParameters(acct.getTlsMinProtocol().getTag());
            SocketFactory factory = mgr.getClientSocketFactory(clientTlsParms);
            props.put("mail.smtp.ssl.socketFactory", factory);
            props.put("mail.smtp.ssl.socketFactory.port", "" + port);
            props.put("mail.smtp.ssl.protocols", MailPlatformHandlerSe.getConfiguredTlsMinimumProtocolVersions(acct));
        }
        Authenticator authenticator = AccessController.doPrivileged(emailClientAuthenticator::getAuthenticator);
        Session session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        if (acct.getDebug()) {
            session.setDebug(true);
            session.setDebugOut(System.out);
        }
        return session;
    }

    private static String getConfiguredTlsMinimumProtocolVersions(BEmailAccount account) {
        return String.join((CharSequence)" ", (CharSequence[])CryptoSupport.TYPE_LISTS.get(account.getTlsMinProtocol().getTag()));
    }
}

