/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import com.tridium.email.BAbstractOAuthEmailAuthenticator;
import com.tridium.email.BBasicEmailClientAuthenticator;
import com.tridium.email.BNoAuthEmailClientAuthenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"email:EmailService"})})
public final class BEmailServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailServiceSecurityDashboardProviderAgent.class);
    private BEmailService service;
    private static final String NO_EMAIL_ACCOUNTS_SUMMARY = "securityDashboard.emailService.noEmailAccounts.summary";
    private static final String NO_EMAIL_ACCOUNTS_DESCRIPTION = "securityDashboard.emailService.noEmailAccounts.description";
    private static final String DEBUG_ENABLED_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugEnabledForDisabledAccount.summary";
    private static final String DEBUG_DISABLED_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugDisabledForDisabledAccount.summary";
    private static final String DEBUG_ENABLED_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugEnabledForEnabledAccount.summary";
    private static final String DEBUG_DISABLED_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.debugDisabledForEnabledAccount.summary";
    private static final String ENABLING_DEBUG_DESCRIPTION = "securityDashboard.emailService.enablingDebug.description";
    private static final String NO_TLS_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noTLSForDisabledAccount.summary";
    private static final String SPECIFIED_TLS_FOR_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedTLSForDisabledAccount.summary";
    private static final String NO_TLS_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noTLSForEnabledAccount.summary";
    private static final String SPECIFIED_TLS_FOR_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedTLSForEnabledAccount.summary";
    private static final String DISABLING_TLS_DESCRIPTION = "securityDashboard.emailService.disablingTLS.description";
    private static final String BASIC_AUTH_WITH_TLS_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.basicAuthWithTLSForDisabledAccount.summary";
    private static final String BASIC_AUTH_NO_TLS_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.basicAuthNoTLSForDisabledAccount.summary";
    private static final String BASIC_AUTH_WITH_TLS_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.basicAuthWithTLSForEnabledAccount.summary";
    private static final String BASIC_AUTH_NO_TLS_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.basicAuthNoTLSForEnabledAccount.summary";
    private static final String OAUTH_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.oAuthForEnabledAccount.summary";
    private static final String OAUTH_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.oAuthForDisabledAccount.summary";
    private static final String NO_AUTH_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noAuthForEnabledAccount.summary";
    private static final String NO_AUTH_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.noAuthForDisabledAccount.summary";
    private static final String OUTDATED_AUTHENTICATOR_DESCRIPTION = "securityDashboard.emailService.outdatedAuthenticator.description";
    private static final String OAUTH_ENDPOINT_NO_TLS_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.oAuthEndpointNoTLSForEnabledAccount.summary";
    private static final String OAUTH_ENDPOINT_NO_TLS_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.oAuthEndpointNoTLSForDisabledAccount.summary";
    private static final String INSECURE_ENDPOINT_DESCRIPTION = "securityDashboard.emailService.oAuthEndpointInsecure.description";
    private static final String DEPRECATED_TLS_VERSION_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedMinTlsVersionDeprecatedForDisabledAccount.summary";
    private static final String RECOMMENDED_TLS_VERSION_ON_DISABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedMinTlsVersionRecommendedForDisabledAccount.summary";
    private static final String DEPRECATED_TLS_VERSION_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedMinTlsVersionDeprecatedForEnabledAccount.summary";
    private static final String RECOMMENDED_TLS_VERSION_ON_ENABLED_ACCOUNT_SUMMARY = "securityDashboard.emailService.specifiedMinTlsVersionRecommendedForEnabledAccount.summary";
    private static final String MIN_TLS_VERSION_RECOMMENDATION_DESCRIPTION = "securityDashboard.emailService.minTlsVersionRecommendation.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.service = (BEmailService)object;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)this.service.getType(), (String)"securityDashboard.emailService.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.service.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 2;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BEmailAccount[] accounts = (BEmailAccount[])this.service.getChildren(BEmailAccount.class);
        if (accounts.length == 0) {
            items.add(SecurityDashboardItem.makeInfo((Type)TYPE, (String)NO_EMAIL_ACCOUNTS_SUMMARY, (String)NO_EMAIL_ACCOUNTS_DESCRIPTION));
        } else {
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getDebugDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoDebugDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getDebugEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoDebugEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getMinTlsProtocolVersionLowerThanRecommendedDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getMinTlsProtocolVersionRecommendedDisabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getMinTlsProtocolVersionLowerThanRecommendedEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getMinTlsProtocolVersionRecommendedEnabled(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureBasicAuthOnEnabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureBasicAuthOnEnabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getSecureBasicAuthOnDisabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureBasicAuthOnDisabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getOAuthOnEnabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getOAuthOnDisabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoAuthOnEnabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getNoAuthOnDisabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureOauthEndpointOnEnabledAccounts(accounts, cx));
            items.addAll(BEmailServiceSecurityDashboardProviderAgent.getInsecureOauthEndpointOnDisabledAccounts(accounts, cx));
        }
        return Collections.unmodifiableList(items);
    }

    private static List<SecurityDashboardItem> getDebugDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getDebug() && !account.getEnabled(), BSecurityItemStatus.securityStatusInfo, DEBUG_ENABLED_FOR_DISABLED_ACCOUNT_SUMMARY, ENABLING_DEBUG_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getNoDebugDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getDebug() && !account.getEnabled(), BSecurityItemStatus.securityStatusInfo, DEBUG_DISABLED_FOR_DISABLED_ACCOUNT_SUMMARY, ENABLING_DEBUG_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getDebugEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getDebug() && account.getEnabled(), BSecurityItemStatus.securityStatusAlert, DEBUG_ENABLED_FOR_ENABLED_ACCOUNT_SUMMARY, ENABLING_DEBUG_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getNoDebugEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getDebug() && account.getEnabled(), BSecurityItemStatus.securityStatusOK, DEBUG_DISABLED_FOR_ENABLED_ACCOUNT_SUMMARY, ENABLING_DEBUG_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getUseSsl() && !account.getUseStartTls() && !account.getEnabled(), BSecurityItemStatus.securityStatusInfo, NO_TLS_FOR_DISABLED_ACCOUNT_SUMMARY, DISABLING_TLS_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getSecureDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> (account.getUseSsl() || account.getUseStartTls()) && !account.getEnabled(), BSecurityItemStatus.securityStatusInfo, SPECIFIED_TLS_FOR_DISABLED_ACCOUNT_SUMMARY, DISABLING_TLS_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getUseSsl() && !account.getUseStartTls() && account.getEnabled(), BSecurityItemStatus.securityStatusAlert, NO_TLS_FOR_ENABLED_ACCOUNT_SUMMARY, DISABLING_TLS_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getSecureEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> (account.getUseSsl() || account.getUseStartTls()) && account.getEnabled(), BSecurityItemStatus.securityStatusOK, SPECIFIED_TLS_FOR_ENABLED_ACCOUNT_SUMMARY, DISABLING_TLS_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getMinTlsProtocolVersionLowerThanRecommendedDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getEnabled() && (account.getUseSsl() || account.getUseStartTls()) && account.getTlsMinProtocol().getOrdinal() < 4, BSecurityItemStatus.securityStatusInfo, DEPRECATED_TLS_VERSION_ON_DISABLED_ACCOUNT_SUMMARY, MIN_TLS_VERSION_RECOMMENDATION_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getMinTlsProtocolVersionRecommendedDisabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getEnabled() && (account.getUseSsl() || account.getUseStartTls()) && account.getTlsMinProtocol().getOrdinal() >= 4, BSecurityItemStatus.securityStatusInfo, RECOMMENDED_TLS_VERSION_ON_DISABLED_ACCOUNT_SUMMARY, MIN_TLS_VERSION_RECOMMENDATION_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getMinTlsProtocolVersionLowerThanRecommendedEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getEnabled() && (account.getUseSsl() || account.getUseStartTls()) && account.getTlsMinProtocol().getOrdinal() < 4, BSecurityItemStatus.securityStatusAlert, DEPRECATED_TLS_VERSION_ON_ENABLED_ACCOUNT_SUMMARY, MIN_TLS_VERSION_RECOMMENDATION_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getMinTlsProtocolVersionRecommendedEnabled(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getEnabled() && (account.getUseSsl() || account.getUseStartTls()) && account.getTlsMinProtocol().getOrdinal() >= 4, BSecurityItemStatus.securityStatusOK, RECOMMENDED_TLS_VERSION_ON_ENABLED_ACCOUNT_SUMMARY, MIN_TLS_VERSION_RECOMMENDATION_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getSecureBasicAuthOnEnabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> (account.getUseSsl() || account.getUseStartTls()) && account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BBasicEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusWarning, BASIC_AUTH_WITH_TLS_ON_ENABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureBasicAuthOnEnabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getUseSsl() && !account.getUseStartTls() && account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BBasicEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusAlert, BASIC_AUTH_NO_TLS_ON_ENABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getSecureBasicAuthOnDisabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> (account.getUseSsl() || account.getUseStartTls()) && !account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BBasicEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusInfo, BASIC_AUTH_WITH_TLS_ON_DISABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureBasicAuthOnDisabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getUseSsl() && !account.getUseStartTls() && !account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BBasicEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusInfo, BASIC_AUTH_NO_TLS_ON_DISABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getOAuthOnEnabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BAbstractOAuthEmailAuthenticator.TYPE), BSecurityItemStatus.securityStatusOK, OAUTH_ON_ENABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getOAuthOnDisabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BAbstractOAuthEmailAuthenticator.TYPE), BSecurityItemStatus.securityStatusInfo, OAUTH_ON_DISABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getNoAuthOnEnabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BNoAuthEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusWarning, NO_AUTH_ON_ENABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getNoAuthOnDisabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BNoAuthEmailClientAuthenticator.TYPE), BSecurityItemStatus.securityStatusInfo, NO_AUTH_ON_DISABLED_ACCOUNT_SUMMARY, OUTDATED_AUTHENTICATOR_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureOauthEndpointOnEnabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BAbstractOAuthEmailAuthenticator.TYPE) && BEmailServiceSecurityDashboardProviderAgent.hasInsecureOauthEndpoint((BAbstractOAuthEmailAuthenticator)account.getEmailAuthenticator().make()), BSecurityItemStatus.securityStatusAlert, OAUTH_ENDPOINT_NO_TLS_ON_ENABLED_ACCOUNT_SUMMARY, INSECURE_ENDPOINT_DESCRIPTION, context);
    }

    private static List<SecurityDashboardItem> getInsecureOauthEndpointOnDisabledAccounts(BEmailAccount[] accounts, Context context) {
        return BEmailServiceSecurityDashboardProviderAgent.getSecurityDashboardItemsForFilter(accounts, account -> !account.getEnabled() && account.getEmailAuthenticator().getTypeSpec().getTypeInfo().is(BAbstractOAuthEmailAuthenticator.TYPE) && BEmailServiceSecurityDashboardProviderAgent.hasInsecureOauthEndpoint((BAbstractOAuthEmailAuthenticator)account.getEmailAuthenticator().make()), BSecurityItemStatus.securityStatusInfo, OAUTH_ENDPOINT_NO_TLS_ON_DISABLED_ACCOUNT_SUMMARY, INSECURE_ENDPOINT_DESCRIPTION, context);
    }

    private static boolean hasInsecureOauthEndpoint(BAbstractOAuthEmailAuthenticator emailAuthenticator) {
        return !emailAuthenticator.getAuthServerMetadataEndpoint().trim().toLowerCase().startsWith("https:");
    }

    private static List<SecurityDashboardItem> getSecurityDashboardItemsForFilter(BEmailAccount[] accounts, Predicate<BEmailAccount> accountFilter, BSecurityItemStatus securityItemStatus, String summaryKey, String descKey, Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List matchingEmailAccountNames = Arrays.stream(accounts).filter(accountFilter).map(account -> account.getDisplayName(context)).collect(Collectors.toList());
        if (!matchingEmailAccountNames.isEmpty()) {
            items.add(SecurityDashboardItem.make((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)summaryKey, (String)String.join((CharSequence)", ", matchingEmailAccountNames)), (String)descKey, (BSecurityItemStatus)securityItemStatus));
        }
        return items;
    }
}

