/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import com.tridium.oauth2.OAuth2AuthorizationException;
import com.tridium.oauth2.OAuth2AuthorizationRequest;
import com.tridium.oauth2.OAuth2AuthorizationResponse;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadataResolver;
import com.tridium.util.ArrayUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;
import javax.baja.email.BEmailClientAuthenticator;
import javax.baja.email.BIIncomingAccountClientAuthenticator;
import javax.baja.email.BIOutgoingAccountClientAuthenticator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.Transport;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authServerMetadataEndpoint", type="String", defaultValue="https://endpoint.server.com/path/to/endpoint"), @NiagaraProperty(name="account", type="String", defaultValue=""), @NiagaraProperty(name="clientId", type="String", defaultValue=""), @NiagaraProperty(name="scope", type="String", defaultValue="")})
public abstract class BAbstractOAuthEmailAuthenticator
extends BEmailClientAuthenticator
implements BIIncomingAccountClientAuthenticator,
BIOutgoingAccountClientAuthenticator {
    @Generated
    public static final Property authServerMetadataEndpoint = BAbstractOAuthEmailAuthenticator.newProperty((int)0, (String)"https://endpoint.server.com/path/to/endpoint", null);
    @Generated
    public static final Property account = BAbstractOAuthEmailAuthenticator.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property clientId = BAbstractOAuthEmailAuthenticator.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property scope = BAbstractOAuthEmailAuthenticator.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractOAuthEmailAuthenticator.class);
    private OAuth2AuthorizationServerMetadata authServerMetadata;
    private static final String[] CONFIGURABLE_PROPERTIES = new String[]{authServerMetadataEndpoint.getName(), account.getName(), clientId.getName(), scope.getName()};

    @Generated
    public String getAuthServerMetadataEndpoint() {
        return this.getString(authServerMetadataEndpoint);
    }

    @Generated
    public void setAuthServerMetadataEndpoint(String v) {
        this.setString(authServerMetadataEndpoint, v, null);
    }

    @Generated
    public String getAccount() {
        return this.getString(account);
    }

    @Generated
    public void setAccount(String v) {
        this.setString(account, v, null);
    }

    @Generated
    public String getClientId() {
        return this.getString(clientId);
    }

    @Generated
    public void setClientId(String v) {
        this.setString(clientId, v, null);
    }

    @Generated
    public String getScope() {
        return this.getString(scope);
    }

    @Generated
    public void setScope(String v) {
        this.setString(scope, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected abstract OAuth2AuthorizationRequest getAuthorizationRequest() throws OAuth2AuthorizationException;

    protected String getAccessToken() throws OAuth2AuthorizationException {
        String errorDescription;
        OAuth2AuthorizationResponse tokenResponse;
        if (this.getAuthServerMetadata() == null) {
            this.resolveAuthServerMetadata(new OAuth2AuthorizationServerMetadataResolver());
        }
        OAuth2AuthorizationRequest tokenRequest = this.getAuthorizationRequest();
        try {
            tokenResponse = AccessController.doPrivileged(() -> ((OAuth2AuthorizationRequest)tokenRequest).send());
        }
        catch (PrivilegedActionException e) {
            throw new OAuth2AuthorizationException("An exception occurred while performing authorization", e.getCause());
        }
        if (OAuth2AuthorizationResponse.Result.SUCCESS.equals((Object)tokenResponse.getResultStatus())) {
            return tokenResponse.get("access_token");
        }
        StringBuilder exceptionMessage = new StringBuilder("OAuth 2.0 Authorization Request unsuccessful");
        String errorResponse = tokenResponse.get("error");
        if (errorResponse != null) {
            exceptionMessage.append(", error response: ").append(errorResponse);
        }
        if ((errorDescription = tokenResponse.get("error_description")) != null) {
            exceptionMessage.append(", error description: ").append(errorDescription);
        }
        throw new OAuth2AuthorizationException(exceptionMessage.toString());
    }

    protected void resolveAuthServerMetadata(OAuth2AuthorizationServerMetadataResolver authServerMetadataResolver) {
        OAuth2AuthorizationServerMetadata newMetadata = null;
        try {
            URL authServerMetadataURL = new URL(this.getAuthServerMetadataEndpoint());
            newMetadata = AccessController.doPrivileged(() -> authServerMetadataResolver.resolve(authServerMetadataURL));
        }
        catch (MalformedURLException e) {
            throw new OAuth2AuthorizationException(String.format("Unable to resolve Authorization Server Metadata, '%s' is not a valid URL.", this.getAuthServerMetadataEndpoint()), (Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new OAuth2AuthorizationException("Unable to obtain OAuth 2.0 Authorization Server Metadata from URI", e.getCause());
        }
        finally {
            this.authServerMetadata = newMetadata;
        }
    }

    protected OAuth2AuthorizationServerMetadata getAuthServerMetadata() {
        return this.authServerMetadata;
    }

    @Override
    public void setOutgoingAuthenticationProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties argument must not be null");
        }
        String mailStoreTypePropertyPrefix = "mail.smtp";
        properties.put(mailStoreTypePropertyPrefix + ".sasl.enable", "true");
        properties.put(mailStoreTypePropertyPrefix + ".sasl.mechanisms", "XOAUTH2");
        properties.put(mailStoreTypePropertyPrefix + ".auth.login.disable", "true");
        properties.put(mailStoreTypePropertyPrefix + ".auth.plain.disable", "true");
    }

    @Override
    public void setIncomingAuthenticationProperties(Properties properties, String storeType) {
        if (properties == null) {
            throw new IllegalArgumentException("properties argument must not be null");
        }
        if (!"imap".equals(storeType)) {
            throw new UnsupportedOperationException("XOAUTH2 Authentication is only supported for IMAP sessions");
        }
        String mailStoreTypePropertyPrefix = "mail." + storeType;
        properties.put(mailStoreTypePropertyPrefix + ".sasl.enable", "true");
        properties.put(mailStoreTypePropertyPrefix + ".sasl.mechanisms", "XOAUTH2");
        properties.put(mailStoreTypePropertyPrefix + ".auth.login.disable", "true");
        properties.put(mailStoreTypePropertyPrefix + ".auth.plain.disable", "true");
    }

    @Override
    public void connectOutgoingSession(Transport transport) throws MessagingException {
        try {
            AccessController.doPrivileged(() -> {
                transport.connect(this.getAccount(), this.getAccessToken());
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new MessagingException("Unable to connect to SMTP transport!", e.getException());
        }
    }

    @Override
    public void connectIncomingSession(Store messageStore, String storeType) throws MessagingException {
        if (!"imap".equals(storeType)) {
            throw new UnsupportedOperationException("Incoming mail sessions supported for IMAP sessions");
        }
        try {
            AccessController.doPrivileged(() -> {
                messageStore.connect(this.getAccount(), this.getAccessToken());
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new MessagingException(String.format("Unable to connect to %s store!", storeType), e.getException());
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == authServerMetadataEndpoint) {
            this.resolveAuthServerMetadata(new OAuth2AuthorizationServerMetadataResolver());
        }
        super.changed(property, context);
    }

    @Override
    public String[] listConfig() {
        return (String[])ArrayUtil.add((Object[])super.listConfig(), (Object[])CONFIGURABLE_PROPERTIES);
    }
}

