/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.point;

import com.tridium.lonworks.discover.BLonCreationEntry;
import com.tridium.lonworks.ui.point.PointLearn;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.proxy.BLonBooleanProxyExt;
import javax.baja.lonworks.proxy.BLonEnumProxyExt;
import javax.baja.lonworks.proxy.BLonFloatProxyExt;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.lonworks.proxy.BLonStringProxyExt;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"lonworks:LonPointDeviceExt", "lonworks:LonPointFolder"}, requiredPermissions="r")})
public class BLonPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BLonPointManager.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLonPointManager.class);
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colTarget = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.targetComp"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.targetComp}, 7);
    MgrColumn colElement = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.targetName"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.targetName}, 7);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3){

        public void save(MgrEditRow row, BValue value, Context cx) {
            BLonPointManager.this.updateUnit(row, value, cx);
            super.save(row, value, cx);
        }
    };
    MgrColumn colFaultCause = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.faultCause"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.faultCause}, 4);
    MgrColumn colEnabled = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.enabled"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.enabled}, 6);
    MgrColumn colReadValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.readValue"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.readValue}, 6);
    MgrColumn colWriteValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.writeValue"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.writeValue}, 6);
    MgrColumn colLinkType = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.linkType"), new Property[]{BControlPoint.proxyExt, BLonProxyExt.linkType}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BLonProxyExt.conversion}, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colValue, this.colFaultCause, this.colType, this.colTarget, this.colElement, this.colFacets, this.colConversion, this.colEnabled, this.colReadValue, this.colWriteValue, this.colLinkType};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LonPointModel(this);
    }

    protected MgrLearn makeLearn() {
        return new PointLearn((BAbstractManager)this);
    }

    protected MgrController makeController() {
        return new PointController(this){

            protected MgrController.IMgrCommand[] makeCommands() {
                return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.edit, this.discover, this.learnMode, this.add, this.quickAdd};
            }
        };
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getId() == 5 && event.getSlot() == BDynamicDevice.dynamicOpComplete) {
            ((PointLearn)this.getLearn()).updateDiscoveryRows();
        }
        super.handleComponentEvent(event);
    }

    private void updateUnit(MgrEditRow row, BValue value, Context cx) {
        BControlPoint cp = (BControlPoint)row.getTarget();
        BLonProxyExt pe = (BLonProxyExt)cp.getProxyExt();
        BFacets df = pe.getDeviceFacets();
        BUnit devUnit = (BUnit)df.get("units");
        BUnit newUnit = (BUnit)((BFacets)value).get("units");
        if (newUnit != null && devUnit != null) {
            BUnit newDevUnit = null;
            String devUnitName = devUnit.getUnitName();
            if (BLonPointManager.isTemp(devUnit) && BLonPointManager.isTempDiff(newUnit)) {
                newDevUnit = UnitDatabase.getUnit((String)(devUnitName + " degrees"));
            } else if (BLonPointManager.isTempDiff(devUnit) && BLonPointManager.isTemp(newUnit)) {
                newDevUnit = UnitDatabase.getUnit((String)devUnitName.substring(0, devUnitName.indexOf(" degrees")));
            }
            if (newDevUnit != null) {
                BFacets newFacets = this.makeNewUnits(df, newDevUnit);
                pe.setDeviceFacets(newFacets);
                BLonData p = pe.getDataPoint();
                Property pr = p.getProperty(pe.getTargetName());
                p.setFacets((Slot)pr, this.makeNewUnits(pr.getFacets(), newDevUnit));
            }
        }
    }

    private static final boolean isTemp(BUnit u) {
        UnitDatabase.Quantity q = UnitDatabase.getDefault().getQuantity(u);
        return q.getName().equals("temperature");
    }

    private static final boolean isTempDiff(BUnit u) {
        UnitDatabase.Quantity q = UnitDatabase.getDefault().getQuantity(u);
        return q.getName().equals("temperature differential");
    }

    private BFacets makeNewUnits(BFacets f, BUnit u) {
        BFacets newFacets = BFacets.makeRemove((BFacets)f, (String)"units");
        return BFacets.make((BFacets)newFacets, (String)"units", (BIDataValue)u);
    }

    class LonPointModel
    extends PointModel {
        LonPointModel(BLonPointManager mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BLonPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BLonBooleanProxyExt ext;
            BControlPoint pt = (BControlPoint)type.newInstance();
            if (pt instanceof BBooleanPoint) {
                ext = new BLonBooleanProxyExt();
            } else if (pt instanceof BNumericPoint) {
                ext = new BLonFloatProxyExt();
            } else if (pt instanceof BEnumPoint) {
                ext = new BLonEnumProxyExt();
            } else if (pt instanceof BStringPoint) {
                ext = new BLonStringProxyExt();
            } else {
                pt.setProxyExt((BAbstractProxyExt)new BNullProxyExt());
                return pt;
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            for (int i = 0; i < rows.length; ++i) {
                Object dis = rows[i].getDiscovery();
                BComponent instance = rows[i].getTarget();
                if (dis == null) continue;
                BLonCreationEntry lce = (BLonCreationEntry)dis;
                BFacets f = lce.getFacets();
                BLonProxyExt pext = (BLonProxyExt)((BControlPoint)instance).getProxyExt();
                pext.setDeviceFacets(f);
            }
            return super.addInstances(rows, cx);
        }
    }
}

