/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.ui;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.httpClient.util.trigger.BTargetClientList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"httpClient:TargetClientList"})})
public class BHttpClientListFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientListFE.class);
    private Map<String, String> clients = new HashMap<String, String>();
    private final BListDropDown clientPicker;
    private final Command addCommand;
    private final BFlowPane clientPickerPane = new BFlowPane(BHalign.center);
    private final BGridPane selectedClientsPane;
    private final Set<String> selectedClients;
    private static final String SAFE_SUFFIX = "slot";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHttpClientListFE() {
        this.clientPicker = new BListDropDown();
        this.clientPickerPane.add("slotsPicker", (BValue)this.clientPicker);
        this.selectedClientsPane = new BGridPane(1);
        this.selectedClientsPane.add("clientPickerPane", (BValue)this.clientPickerPane);
        this.addCommand = new AddCommand();
        BButton addButton = new BButton(this.addCommand);
        addButton.setButtonStyle(BButtonStyle.toolBar);
        addButton.setPadding(BInsets.NULL);
        this.clientPickerPane.add("add", (BValue)addButton);
        this.selectedClients = new HashSet<String>();
        BGridPane outerGrid = new BGridPane(1);
        outerGrid.setRowAlign(BValign.top);
        outerGrid.add("manualPane", (BValue)this.selectedClientsPane);
        this.setContent((BWidget)outerGrid);
    }

    protected void doSetReadonly(boolean readonly) {
        this.addCommand.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BTargetClientList targetList = (BTargetClientList)value;
        try {
            this.populateListComponents(targetList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addButtonEnabledState();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        BTargetClientList clientList = (BTargetClientList)value;
        clientList.removeAll();
        this.selectedClients.forEach(name -> {
            Optional<BOrd> clientHandleOrd = this.clients.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(name)).map(entry -> BOrd.make((String)((String)entry.getKey()))).findFirst();
            clientHandleOrd.ifPresent(ord -> clientList.add("client?", (BValue)ord));
        });
        return value;
    }

    protected void populateListComponents(BTargetClientList clientList) throws Exception {
        this.clientPicker.getList().removeAllItems();
        List<String> alreadyPickedHandles = Arrays.stream(clientList.getChildren(BOrd.class)).map(BObject::toString).collect(Collectors.toList());
        Optional retVal = FoxRpcUtil.doRpc((BISpaceNode)clientList, (String)"findAllClients", (Object[])new Object[0]);
        retVal.ifPresent(map -> {
            this.clients = map;
            this.clients.keySet().stream().filter(handle -> !alreadyPickedHandles.contains(handle)).forEach(handle -> this.clientPicker.getList().addItem((Object)this.clients.get(handle)));
        });
        alreadyPickedHandles.forEach(handle -> this.addSelectedClientName(this.clients.get(handle)));
    }

    private void addSelectedClientName(String clientDisplayName) {
        if (this.selectedClients.add(clientDisplayName)) {
            BGridPane pane = new BGridPane(2);
            BLabel label = new BLabel();
            label.setText(clientDisplayName);
            DeleteCommand deleteCommand = new DeleteCommand(clientDisplayName);
            BButton delButton = new BButton((Command)deleteCommand);
            delButton.setButtonStyle(BButtonStyle.toolBar);
            delButton.setPadding(BInsets.NULL);
            pane.add("lbl", (BValue)label);
            pane.add("delButton", (BValue)delButton);
            this.selectedClientsPane.add(SAFE_SUFFIX + SlotPath.escape((String)clientDisplayName), (BValue)pane);
            if (this.clientPicker != null) {
                this.clientPicker.getList().removeItem((Object)clientDisplayName);
                this.clientPicker.setSelectedIndex(0);
            }
        }
        this.addButtonEnabledState();
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.setModified();
    }

    private void addButtonEnabledState() {
        this.addCommand.setEnabled(this.clientPicker != null && this.clientPicker.getList().getItemCount() > 0);
    }

    private class AddCommand
    extends Command {
        AddCommand() {
            super((BWidget)BHttpClientListFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            if (BHttpClientListFE.this.clientPicker != null && BHttpClientListFE.this.clientPicker.getSelectedIndex() > -1) {
                String selectedClient = (String)BHttpClientListFE.this.clientPicker.getSelectedItem();
                BHttpClientListFE.this.addSelectedClientName(selectedClient);
            }
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        private final String itemToDelete;

        DeleteCommand(String itemToDelete) {
            super((BWidget)BHttpClientListFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.itemToDelete = itemToDelete;
        }

        public CommandArtifact doInvoke() {
            BHttpClientListFE.this.selectedClients.remove(this.itemToDelete);
            BHttpClientListFE.this.selectedClientsPane.remove(BHttpClientListFE.SAFE_SUFFIX + SlotPath.escape((String)this.itemToDelete));
            if (BHttpClientListFE.this.clientPicker != null) {
                BHttpClientListFE.this.clientPicker.getList().addItem((Object)this.itemToDelete);
            }
            BHttpClientListFE.this.addButtonEnabledState();
            BHttpClientListFE.this.setModified();
            BHttpClientListFE.this.relayout();
            return null;
        }
    }
}

