/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.ui;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.httpClient.datatypes.auth.BResponseCookieAuth;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.workbench.propsheet.BPropertyEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BHttpClientChooserFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientChooserFE.class);
    private Map<String, String> clients = new HashMap<String, String>();
    private final BListDropDown clientPicker = new BListDropDown();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHttpClientChooserFE() {
        this.setContent((BWidget)this.clientPicker);
        this.linkTo("lk?", (BComponent)this.clientPicker, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk?", (BComponent)this.clientPicker, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject val, Context cx) {
        BString clientHandle = (BString)val;
        try {
            this.populateClientPicker();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (clientHandle != null) {
            this.clientPicker.getList().setSelectedItem((Object)this.clients.get(clientHandle.getString()));
        }
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        if (this.clientPicker.getSelectedIndex() >= 0) {
            String selectedClient = this.clientPicker.getSelectedItem().toString();
            Optional<String> clientHandle = this.clients.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(selectedClient)).map(Map.Entry::getKey).findFirst();
            if (clientHandle.isPresent()) {
                return BString.make((String)clientHandle.get());
            }
        }
        return BString.DEFAULT;
    }

    private BResponseCookieAuth getAuthenticator() {
        BComplex parent = this.getParent().getParent();
        if (parent instanceof BPropertyEntry) {
            BObject target = ((BPropertyEntry)parent).getTarget();
            if (target instanceof BResponseCookieAuth) {
                return (BResponseCookieAuth)target.as(BResponseCookieAuth.class);
            }
            if (target instanceof BComplex) {
                return (BResponseCookieAuth)HttpClientUtils.getParent((BComplex)target.asComplex(), BResponseCookieAuth.class);
            }
        }
        throw new BajaRuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " unable to detect parent authenticator");
    }

    protected void populateClientPicker() throws Exception {
        this.clientPicker.getList().removeAllItems();
        BResponseCookieAuth auth = this.getAuthenticator();
        if (auth != null) {
            Optional retVal = FoxRpcUtil.doRpc((BISpaceNode)auth, (String)"findAllClients", (Object[])new Object[0]);
            retVal.ifPresent(map -> {
                this.clients = map;
                this.clients.forEach((handle, displayName) -> this.clientPicker.getList().addItem(displayName));
            });
        }
    }
}

