/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph;

import com.tridium.seriestransform.NGraphNodeParams;
import com.tridium.seriestransform.SchemaCheckUtil;
import com.tridium.seriestransform.graph.BNodeContainer;
import com.tridium.seriestransform.graph.BTransformGraphTable;
import com.tridium.seriestransform.terminal.BTerminalNode;
import com.tridium.util.PxUtil;
import java.security.AccessController;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="transformInputs", type="BStatusSchema", defaultValue="new BStatusSchema()", flags=14, override=true)
public class BTransformGraph
extends BNodeContainer {
    @Generated
    public static final Property transformInputs = BTransformGraph.newProperty((int)14, (BValue)new BStatusSchema(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTransformGraph.class);
    private static boolean hideWebWiresheet = AccessController.doPrivileged(() -> System.getProperty("niagara.hideWebWiresheet", "false")).equals("true");
    private static final Lexicon lex = Lexicon.make(BTransformGraph.class);
    private static final String ERR_NO_TERMINAL = lex.getText("fault.msg.noterminal");
    private static final String ERR_MULTI_TERMINALS = lex.getText("fault.msg.multiterminals");
    private static final String FAULT_MISCONFIGURED = lex.getText("fault.msg.schema.invalidgraphconfig");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return true;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base, Context cx) throws TransformException {
        BTerminalNode[] children = (BTerminalNode[])this.getChildren(BTerminalNode.class);
        if (children.length > 0) {
            BTerminalNode terminal = children[0];
            if (params instanceof NGraphNodeParams) {
                BSeriesTransformTable[] resolve = terminal.resolve(((NGraphNodeParams)params).getQueryParams(), base, cx);
                BTransformGraphTable table = new BTransformGraphTable(resolve[0], this.getName(), this.getSchema());
                BSeriesTransformTable[] results = new BSeriesTransformTable[]{table};
                return results;
            }
        }
        throw new ConfigException(ERR_NO_TERMINAL);
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BTerminalNode[] children = (BTerminalNode[])this.getChildren(BTerminalNode.class);
        if (children.length > 0) {
            return children[0].getSchema();
        }
        return new BSeriesSchema();
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        for (BGraphNode node : (BGraphNode[])this.getChildren(BGraphNode.class)) {
            if (node.getStatus().equals((Object)BStatus.ok)) continue;
            String msg = lex.getText(FAULT_MISCONFIGURED, new Object[]{node.getName()});
            throw new ConfigException(msg);
        }
    }

    public final void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BTerminalNode) {
            if (!this.isRunning()) {
                return;
            }
            BTerminalNode[] children = (BTerminalNode[])this.getChildren(BTerminalNode.class);
            if (children.length > 0) {
                throw new LocalizableRuntimeException("seriesTransform", ERR_MULTI_TERMINALS);
            }
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("graph.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.add("wiresheet:WebWiresheet");
        list.add("wiresheet:WireSheet");
        list.toTop("wiresheet:WebWiresheet");
        list.toTop("wiresheet:WireSheet");
        if (hideWebWiresheet) {
            list.remove("wiresheet:WebWiresheet");
        }
        if (SchemaCheckUtil.isChartable(this, cx)) {
            list.add("webChart:ChartWidget");
            if (this.getPermissions(cx).hasAdminWrite()) {
                list.toBottom("webChart:ChartWidget");
            } else {
                list.toTop("webChart:ChartWidget");
            }
        }
        return PxUtil.movePxViewsToTop((AgentList)list);
    }
}

