/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import com.tridium.seriestransform.functions.BFindMax;
import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
public class BPassThrough
extends BTransformFunction {
    @Generated
    public static final Type TYPE = Sys.loadType(BPassThrough.class);
    private static final Lexicon lex = Lexicon.make(BFindMax.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.passthrough");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.passthrough");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BFacets facets = destProp.getFacets();
        BUnit dstUnits = null != facets ? (BUnit)facets.get("units", (BObject)BUnit.NULL) : BUnit.NULL;
        for (String name : srcProps) {
            String seriesName = BPassThrough.getSeriesName(name);
            String fieldName = BPassThrough.getFieldName(name);
            List<? extends BComplex> records = this.getSeriesRecords(series, seriesName);
            if (records.isEmpty()) continue;
            BComplex record = records.get(0);
            BValue value = record.get(fieldName);
            if (value instanceof BNumber) {
                Property srcProp = record.getProperty(fieldName);
                BFacets srcFacets = srcProp.getFacets();
                BUnit srcUnits = null != srcFacets ? (BUnit)srcFacets.get("units", (BObject)BUnit.NULL) : BUnit.NULL;
                try {
                    value = BPassThrough.convertToUnits((BNumber)value, srcUnits, dstUnits);
                }
                catch (SourceException e) {
                    value = BDouble.NaN;
                }
            }
            BPassThrough.setRecordValue(resultRecord, destProp, value);
            return;
        }
    }

    @Override
    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Type getReturnType() {
        return BValue.TYPE;
    }

    @Override
    public Type[] getArgumentTypes() {
        return new Type[]{BValue.TYPE};
    }

    @Override
    public boolean isCumulative() {
        return false;
    }
}

