/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFindMin
extends BTransformFunction {
    @Generated
    public static final Type TYPE = Sys.loadType(BFindMin.class);
    protected static final Lexicon lex = Lexicon.make(BTransformFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.findMin");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.findMin");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getReturnType() {
        return BNumber.TYPE;
    }

    @Override
    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    @Override
    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BDouble minValue = null;
        BUnit dstUnits = BFindMin.getUnits(dstSlot);
        for (String name : srcProps) {
            List<? extends BComplex> records = this.getSeriesRecords(series, BFindMin.getSeriesName(name));
            for (BComplex bComplex : records) {
                Property field = bComplex.getProperty(BFindMin.getFieldName(name));
                try {
                    BNumber check = BFindMin.getMinValue((BNumber)minValue, field, dstUnits, bComplex);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    minValue = check;
                }
                catch (SourceException e) {
                    minValue = BDouble.NaN;
                }
            }
        }
        if (null == minValue) {
            minValue = BDouble.NaN;
        }
        BFindMin.setRecordValue(resultRecord, dstSlot, (BValue)minValue);
    }

    private static BNumber getMinValue(BNumber minValue, Property field, BUnit dstUnits, BComplex record) throws SourceException {
        BValue value = record.get(field);
        BFacets facets = field.getFacets();
        if (minValue == BDouble.NaN) {
            return BDouble.NaN;
        }
        BNumber number = BFindMin.convertToUnits((BNumber)value, (BUnit)facets.getFacet("units"), dstUnits);
        if (number == BDouble.NaN) {
            return BDouble.NaN;
        }
        if (null == minValue || number.compareTo((Object)minValue) < 0) {
            minValue = number;
        }
        return minValue;
    }
}

