/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.filter;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.seriestransform.SeriesColumn;
import com.tridium.seriestransform.filter.BBqlFilterTable;
import java.util.LinkedList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="queryText", type="String", defaultValue="")
public class BBqlFilterNode
extends BGraphNode {
    @Generated
    public static final Property queryText = BBqlFilterNode.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBqlFilterNode.class);
    private BExpression expr;
    private final ExprEngine exprEngine = new ExprEngine(null);
    private static final ExprParser parser = new ExprParser();

    @Generated
    public String getQueryText() {
        return this.getString(queryText);
    }

    @Generated
    public void setQueryText(String v) {
        this.setString(queryText, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) {
        LinkedList<BBqlFilterTable> results = new LinkedList<BBqlFilterTable>();
        for (BSeriesTransformTable table : inputs) {
            BBqlFilterTable filterTable = new BBqlFilterTable(this.getName(), this.getSchema(), this, table);
            results.add(filterTable);
        }
        return results.toArray(new BSeriesTransformTable[0]);
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        schema.add(SeriesColumn.COL_TIMESTAMP, (BValue)BAbsTime.TYPE.getTypeSpec(), 0, BFacets.make((String)"min", (BIDataValue)BAbsTime.DEFAULT), null);
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BGraphNode src = inputSources[0];
            return src.getSchema();
        }
        return schema;
    }

    public void started() {
        try {
            this.expr = parser.parse(new BqlTokenizer(this.getQueryText()));
            this.setStatus(BStatus.ok);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.getQueryText().isEmpty()) {
                this.getTransformInputs().setValue("Invalid BQL expression.");
            }
            this.setStatus(BStatus.fault);
            this.expr = null;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && context != Context.decoding && property.equals(queryText)) {
            String queryString = this.getQueryText();
            this.setQueryText(BBqlFilterNode.fixFlags(queryString));
            try {
                this.expr = parser.parse(new BqlTokenizer(this.getQueryText()));
                this.setStatus(BStatus.ok);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.getQueryText().isEmpty()) {
                    this.getTransformInputs().setValue("Invalid BQL expression.");
                }
                this.setStatus(BStatus.fault);
                this.expr = null;
            }
        }
    }

    public boolean accept(BObject obj) {
        if (this.expr != null) {
            return ((BIBoolean)this.exprEngine.evaluate(this.expr, obj, null)).getBoolean();
        }
        return false;
    }

    @Override
    public void doCheckSchema() {
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformInputs().setValue("schema");
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("filter.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    public static String fixFlags(String s) {
        String prepped = s.replace(" AND ", "\u00bf\u263a AND \u00bf\u263a");
        prepped = prepped.replace(" OR ", "\u00bf\u263a OR \u00bf\u263a");
        CharSequence[] predicateArray = prepped.split("\u00bf\u263a");
        Pattern flags = Pattern.compile("trendFlags (!=|=) [a-f0-9]");
        for (int i = 0; i < predicateArray.length; ++i) {
            Matcher matcher = flags.matcher(predicateArray[i]);
            if (!matcher.matches()) continue;
            boolean usingEqualityOperator = !s.contains(" != ");
            MatchResult mresult = matcher.toMatchResult();
            int flagIndex = mresult.end() - 1;
            char flagHex = s.charAt(flagIndex);
            int flagHexDecoded = Integer.parseInt(String.valueOf(flagHex), 16);
            predicateArray[i] = BBqlFilterNode.hexToFlagQuery(flagHexDecoded, usingEqualityOperator);
        }
        String parsed = String.join((CharSequence)"", predicateArray);
        return parsed;
    }

    public static String hexToFlagQuery(int i, boolean usingequalityoperator) {
        String bitString = Integer.toBinaryString(i);
        if (bitString.length() == 1) {
            bitString = "000" + bitString;
        } else if (bitString.length() == 2) {
            bitString = "00" + bitString;
        } else if (bitString.length() == 3) {
            bitString = '0' + bitString;
        }
        boolean modified = false;
        boolean hidden = false;
        boolean outOfOrder = false;
        boolean start = false;
        if (bitString.charAt(0) == '1') {
            modified = true;
        }
        if (bitString.charAt(1) == '1') {
            hidden = true;
        }
        if (bitString.charAt(2) == '1') {
            outOfOrder = true;
        }
        if (bitString.charAt(3) == '1') {
            start = true;
        }
        int flagCount = 0;
        StringBuilder sb = new StringBuilder();
        String or = " OR ";
        if (modified) {
            ++flagCount;
            sb.append("trendFlags.modified = true");
        }
        if (hidden) {
            if (flagCount > 0) {
                sb.append(" OR ");
            }
            sb.append("trendFlags.hidden = true");
            ++flagCount;
        }
        if (outOfOrder) {
            if (flagCount > 0) {
                sb.append(" OR ");
            }
            sb.append("trendFlags.outOfOrder = true");
            ++flagCount;
        }
        if (start) {
            if (flagCount > 0) {
                sb.append(" OR ");
            }
            sb.append("trendFlags.start = true");
            ++flagCount;
        }
        if (flagCount >= 2) {
            sb.insert(0, '(');
            sb.append(')');
        }
        if (flagCount == 0) {
            sb.append("true = true");
            return sb.toString();
        }
        if (!usingequalityoperator) {
            sb.insert(0, '!');
        }
        return sb.toString();
    }
}

