/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.SubCursor;
import com.tridium.seriestransform.composite.CompositeMapping;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.nre.util.IFilter;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

public class CompositeCursor
extends IntervalSeriesCursor<BComplex> {
    private final BComponent currentRecord;
    private final BComponent previousRecord;
    private final List<SubCursor<BComplex>> subCursors = new LinkedList<SubCursor<BComplex>>();
    private final String keyField;

    public CompositeCursor(BSeriesSchema schema, CompositeMapping[] compositeMappings, IFilter filter, BITable<BComplex> table) {
        super(table);
        this.keyField = schema.getKeyField();
        this.filter = null;
        this.currentRecord = CompositeCursor.createTemplateRecord(schema);
        this.previousRecord = CompositeCursor.createTemplateRecord(schema);
        this.createSubCursors(compositeMappings);
    }

    private void createSubCursors(CompositeMapping[] mappings) {
        for (CompositeMapping cm : mappings) {
            BSeriesTransformTable c = cm.getTable();
            Map<String, String> propertyMappings = cm.getPropertyMappings();
            boolean isHistoryIrregular = false;
            try (TableCursor cursor = c.cursor();){
                BITable nestedTable = cursor.getTable();
                if (null != nestedTable && nestedTable.getType().is(BIHistory.TYPE)) {
                    BHistoryConfig historyConfig = ((BIHistory)nestedTable).getConfig();
                    isHistoryIrregular = historyConfig.getInterval().isIrregular();
                }
            }
            if (isHistoryIrregular) {
                cm.getPropertyMappings().forEach((key, value) -> {
                    Property slot = this.previousRecord.getProperty(key);
                    if (null == slot) {
                        return;
                    }
                    this.previousRecord.setFacets((Slot)slot, BFacets.make((BFacets)slot.getFacets(), (BFacets)BFacets.make((String)"isIrregular", (boolean)true)));
                });
            }
            String keyField = c.getSchema().getKeyField();
            this.subCursors.add(new MappingCursor((Cursor<BComplex>)c.cursor(), keyField, propertyMappings, isHistoryIrregular));
        }
    }

    public boolean advanceCursor() {
        BAbsTime baseTime = this.getBaseTime();
        if (baseTime.equals((Object)BAbsTime.DEFAULT)) {
            return false;
        }
        CompositeCursor.clearRecord((BComplex)this.currentRecord);
        this.copyIrregularEntriesForRecord(this.previousRecord, this.currentRecord, true);
        this.currentRecord.set(this.keyField, (BValue)baseTime);
        for (SubCursor<BComplex> subCursor : this.subCursors) {
            MappingCursor sc = (MappingCursor)subCursor;
            BComplex record = sc.get(baseTime);
            Map<String, String> propMappings = sc.getMappings();
            if (null == record) continue;
            for (Map.Entry<String, String> entry : propMappings.entrySet()) {
                String srcPropName = entry.getValue();
                Property property = this.currentRecord.getProperty(entry.getKey());
                BFacets facets = property.getFacets();
                BValue value = record.get(srcPropName);
                this.currentRecord.set(entry.getKey(), value);
                Slot slot = this.currentRecord.getSlot(entry.getKey());
                this.currentRecord.setFacets(slot, facets);
            }
        }
        this.copyIrregularEntriesForRecord(this.currentRecord, this.previousRecord, false);
        return true;
    }

    private void copyIrregularEntriesForRecord(BComponent source, BComponent destination, boolean checkFacets) {
        SlotCursor properties = source.getProperties();
        while (properties.next()) {
            Property slot = ((Property)properties.slot()).asProperty();
            BFacets slotFacets = slot.getFacets();
            if (checkFacets && !slotFacets.getb("isIrregular", false)) continue;
            BValue bValue = source.get(slot);
            String name = slot.getName();
            if (bValue instanceof BComplex) {
                bValue = bValue.newCopy(true);
            }
            if (null != destination.get(name)) {
                destination.set(name, bValue);
                Slot dstSlot = destination.getSlot(name);
                destination.setFacets(dstSlot, slot.getFacets());
                continue;
            }
            destination.add(name, bValue, 0, slot.getFacets(), null);
        }
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComponent>(this.getTable(), this.currentRecord);
    }

    protected void closeCursor() {
        this.subCursors.forEach(AbstractCursor::close);
    }

    private BAbsTime getBaseTime() {
        BAbsTime timeMarker = BAbsTime.DEFAULT;
        ListIterator<SubCursor<BComplex>> iterator = this.subCursors.listIterator();
        while (iterator.hasNext()) {
            MappingCursor mc = (MappingCursor)iterator.next();
            if (mc.next()) {
                BAbsTime timestamp = mc.getTimestamp();
                if (timeMarker != BAbsTime.DEFAULT && !timestamp.isBefore(timeMarker)) continue;
                timeMarker = timestamp;
                continue;
            }
            iterator.remove();
            return this.getBaseTime();
        }
        return timeMarker;
    }

    protected static class MappingCursor
    extends SubCursor<BComplex> {
        private final Map<String, String> propMappings;
        private final boolean isIrregular;

        public MappingCursor(Cursor<BComplex> c, String keyField, Map<String, String> propMappings, boolean isIrregular) {
            super(c, keyField);
            this.propMappings = propMappings;
            this.isIrregular = isIrregular;
        }

        public Map<String, String> getMappings() {
            return this.propMappings;
        }
    }
}

