/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.cleanser;

import com.tridium.seriestransform.cleanser.interfaces.BIComplexReplacer;
import com.tridium.seriestransform.cleanser.interfaces.BIDetector;
import com.tridium.seriestransform.cleanser.interfaces.BIReplacer;
import com.tridium.seriestransform.cleanser.interfaces.BIValueReplacer;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.history.BTrendFlags;
import javax.baja.seriestransform.SeriesCursor;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;

public class CleanserCursor
extends SeriesCursor<BComplex> {
    private final Cursor<BComplex> innerCursor;
    private BComplex currentRecord;
    private final String[] fieldNames;
    private final BIDetector detector;
    private final BIReplacer replacer;
    private static final Logger log = Logger.getLogger("seriesTransform.cleanserCursor");

    CleanserCursor(BSeriesSchema schema, BITable<BComplex> table, BIDetector chosenDetector, BIReplacer chosenReplacer) {
        super(table);
        this.innerCursor = table.cursor();
        this.fieldNames = schema.getFieldNames();
        this.detector = chosenDetector;
        this.replacer = chosenReplacer;
        this.detector.initialize(table);
        this.replacer.initialize(table, this.detector);
    }

    protected boolean advanceCursor() {
        if (this.innerCursor.next()) {
            this.currentRecord = (BComplex)this.innerCursor.get();
            BDouble val = CleanserCursor.extractFromRecord(this.currentRecord);
            this.replacer.examineEntry((BValue)val);
            return true;
        }
        return false;
    }

    public Row<BComplex> row() {
        this.prettyPrintRecord(this.currentRecord);
        BDouble value = CleanserCursor.extractFromRecord(this.currentRecord);
        if (this.detector.isDataBad(this.currentRecord)) {
            if (this.replacer instanceof BIComplexReplacer) {
                this.currentRecord = ((BIComplexReplacer)this.replacer).supplyReplacement(this.currentRecord);
            } else if (this.replacer instanceof BIValueReplacer) {
                this.currentRecord.set("value", this.replacer.supplyReplacement((BValue)value));
            } else {
                log.severe("CleanserCursor received unexpected replacer interface: " + this.replacer.getType());
            }
            CleanserCursor.flagAsModified(this.currentRecord);
        }
        return new SeriesTransformRow<BComplex>(this.getTable(), this.currentRecord);
    }

    private void prettyPrintRecord(BComplex record) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Pretty printing current record...");
        for (String fieldName : this.fieldNames) {
            BValue value = record.get(fieldName);
            sb.append(MessageFormat.format("\n{0}: {1} (Type: {2})", fieldName, value.toString(), value.getType().toString()));
        }
        sb.append('\n');
        log.fine(sb.toString());
    }

    public static BDouble extractFromRecord(Object record) {
        BComplex complex = (BComplex)record;
        BINumeric numeric = (BINumeric)complex.get("value");
        return BDouble.make((double)numeric.getNumeric());
    }

    private static void flagAsModified(BComplex complex) {
        BTrendFlags flags = (BTrendFlags)complex.get("trendFlags");
        if (flags != null) {
            complex.set("trendFlags", (BValue)flags.set(8, true));
        }
    }
}

