/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.aggregate;

import com.tridium.seriestransform.aggregate.BAggregateTable;
import com.tridium.seriestransform.functions.BFunctionMap;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.BITransformFunctionNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="functionMap", type="BFunctionMap", defaultValue="new BFunctionMap()")
public class BAggregateNode
extends BGraphNode
implements BITransformFunctionNode {
    @Generated
    public static final Property functionMap = BAggregateNode.newProperty((int)0, (BValue)new BFunctionMap(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAggregateNode.class);

    @Generated
    public BFunctionMap getFunctionMap() {
        return (BFunctionMap)this.get(functionMap);
    }

    @Generated
    public void setFunctionMap(BFunctionMap v) {
        this.set(functionMap, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean allowNonCumulative() {
        return true;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        BFunctionMap map = this.getFunctionMap();
        BFunctionMapping[] mappings = this.getFunctionMappings(map);
        Map<String, BSeriesTransformTable> tables = Arrays.stream(inputs).collect(Collectors.toMap(BSeriesTransformTable::getSeriesName, t -> t));
        BAggregateTable at = new BAggregateTable(this.getName(), this.getSchema(), tables, mappings);
        return new BSeriesTransformTable[]{at};
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        BGraphNode[] sources = this.getSources();
        HashMap<String, BSeriesSchema> sourceMap = new HashMap<String, BSeriesSchema>();
        for (BGraphNode bGraphNode : sources) {
            BSeriesSchema srcSchema = bGraphNode.getSchema();
            sourceMap.put(bGraphNode.getName(), srcSchema);
            String keyField = srcSchema.getKeyField();
            BFacets fieldFacets = srcSchema.getFieldFacets(keyField);
            if (null == schema.get(keyField)) {
                BTypeSpec fieldType = srcSchema.getFieldType(keyField);
                schema.addField(keyField, fieldType, fieldFacets);
                continue;
            }
            schema.mergeFieldFacets(keyField, fieldFacets);
        }
        for (BComponent bComponent : this.getFunctionMappings(this.getFunctionMap())) {
            String fieldName = bComponent.getOutputField();
            BTypeSpec functionTypeSpec = bComponent.getFunctionTypeSpec();
            BTransformFunction instance = (BTransformFunction)functionTypeSpec.getInstance();
            Type returnType = instance.getReturnType();
            BFacets facets = bComponent.getFacets();
            if (returnType.equals(BValue.TYPE)) {
                returnType = this.getConcreteReturnType(sources, (BFunctionMapping)bComponent, returnType);
            } else if (returnType.equals(BNumber.TYPE)) {
                returnType = this.defineReturnType(sourceMap, (BFunctionMapping)bComponent);
            }
            if (null != schema.get(fieldName)) continue;
            schema.addField(fieldName, returnType.getTypeSpec(), facets);
        }
        return schema;
    }

    private Type defineReturnType(Map<String, BSeriesSchema> sourceMap, BFunctionMapping mapping) {
        String[] argumentFields;
        Type returnType = null;
        for (String argField : argumentFields = mapping.getArgumentFields()) {
            BSeriesSchema srcSchema;
            String[] split = TextUtil.split((String)argField, (char)'.');
            if (split.length != 2 || null == (srcSchema = sourceMap.get(split[0]))) continue;
            BTypeSpec fieldType = srcSchema.getFieldType(split[1]);
            if (null == fieldType) {
                return BDouble.TYPE;
            }
            if (null == returnType) {
                returnType = fieldType.getResolvedType();
                continue;
            }
            if (returnType.equals(fieldType.getResolvedType())) continue;
            returnType = BDouble.TYPE;
            break;
        }
        if (null == returnType) {
            returnType = BDouble.TYPE;
        }
        return returnType;
    }

    private Type getConcreteReturnType(BGraphNode[] sources, BFunctionMapping mapping, Type returnType) {
        String[] argumentFields = mapping.getArgumentFields();
        String field = argumentFields[0];
        String[] namespace = TextUtil.split((String)field, (char)'.');
        String srcName = namespace[0];
        for (BGraphNode src : sources) {
            if (!src.getName().equals(srcName)) continue;
            String srcSchemaField = namespace[1];
            BSeriesSchema srcSchema = src.getSchema();
            BTypeSpec fieldType = srcSchema.getFieldType(srcSchemaField);
            if (null == fieldType) continue;
            return fieldType.getResolvedType();
        }
        return returnType;
    }

    protected BFunctionMapping[] getFunctionMappings(BFunctionMap functionMap) {
        return (BFunctionMapping[])functionMap.getChildren(BFunctionMapping.class);
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(this.getSrcFieldNames()));
        for (BFunctionMapping mapping : this.getFunctionMappings(this.getFunctionMap())) {
            List unmatched = Arrays.stream(mapping.getArgumentFields()).filter(s -> !fields.contains(s)).collect(Collectors.toList());
            if (unmatched.isEmpty()) continue;
            String msg = lex.getText("fault.msg.schema.invalidField", new Object[]{unmatched.get(0)});
            this.getTransformInputs().setStatus(BStatus.fault);
            this.getTransformInputs().setValue(msg);
            throw new ConfigException(msg);
        }
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformInputs().setValue("schema");
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("aggregate.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == functionMap) {
            this.fireSchemaModified(this.getSchema());
        }
        super.changed(property, context);
    }
}

