/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.aggregate;

import com.tridium.seriestransform.SubCursor;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.FunctionCursor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.util.IFilter;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;

public class AggregateCursor
extends FunctionCursor<BComplex> {
    private final List<SubCursor<BComplex>> subCursors = new LinkedList<SubCursor<BComplex>>();
    private BComplex currentRecord;
    private final Map<String, List<? extends BComplex>> series = new HashMap<String, List<? extends BComplex>>();
    private final String keyField;

    public AggregateCursor(BSeriesSchema schema, BFunctionMapping[] mappings, Map<String, BSeriesTransformTable> tableCollection) {
        this(schema, mappings, tableCollection, null);
    }

    public AggregateCursor(BSeriesSchema schema, BFunctionMapping[] mappings, Map<String, BSeriesTransformTable> tableCollection, IFilter filter) {
        super(schema.getKeyField());
        this.keyField = schema.getKeyField();
        this.filter = filter;
        this.functions = mappings;
        this.init(tableCollection);
        this.currentRecord = AggregateCursor.createTemplateRecord(schema);
    }

    protected void init(Map<String, BSeriesTransformTable> tables) {
        for (Map.Entry<String, BSeriesTransformTable> entry : tables.entrySet()) {
            BSeriesTransformTable table = entry.getValue();
            TableCursor c = table.cursor();
            this.subCursors.add(new MappingCursor((Cursor<BComplex>)c, this.keyField, entry.getKey()));
        }
    }

    public boolean advanceCursor() {
        AggregateCursor.clearRecord(this.currentRecord);
        BAbsTime baseTime = this.getBaseTime();
        this.series.clear();
        if (baseTime.equals((Object)BAbsTime.DEFAULT)) {
            return false;
        }
        for (SubCursor<BComplex> subCursor : this.subCursors) {
            MappingCursor sc = (MappingCursor)subCursor;
            BComplex record = sc.get(baseTime);
            LinkedList<BComplex> records = new LinkedList<BComplex>();
            records.add(record);
            this.series.put(sc.getSeriesName(), records);
        }
        if (!this.series.isEmpty()) {
            try {
                this.applySeriesFunction(this.series, this.currentRecord, true);
            }
            catch (TransformException e) {
                throw new BajaRuntimeException(e.getMessage());
            }
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComplex>(this.getTable(), this.currentRecord);
    }

    protected void closeCursor() {
        this.subCursors.forEach(AbstractCursor::close);
    }

    protected BAbsTime getBaseTime() {
        BAbsTime timeMarker = BAbsTime.DEFAULT;
        ListIterator<SubCursor<BComplex>> iterator = this.subCursors.listIterator();
        while (iterator.hasNext()) {
            SubCursor<BComplex> mc = iterator.next();
            if (mc.next()) {
                BAbsTime timestamp = mc.getTimestamp();
                if (timeMarker != BAbsTime.DEFAULT && !timestamp.isBefore(timeMarker)) continue;
                timeMarker = timestamp;
                continue;
            }
            iterator.remove();
            return this.getBaseTime();
        }
        return timeMarker;
    }

    protected static class MappingCursor
    extends SubCursor<BComplex> {
        private final String seriesName;

        public MappingCursor(Cursor<BComplex> c, String keyField, String seriesName) {
            super(c, keyField);
            this.seriesName = seriesName;
        }

        public String getSeriesName() {
            return this.seriesName;
        }
    }
}

