/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform;

import javax.baja.collection.AbstractCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

public class SubCursor<E extends BComplex>
extends AbstractCursor<BComplex> {
    private final Cursor<E> c;
    private final String keyField;
    private E record;
    private BAbsTime curTimeStamp = BAbsTime.DEFAULT;
    private BAbsTime prevTimeStamp = BAbsTime.DEFAULT;
    private final BComponent previousRecord = new BComponent();
    private boolean isNextAvailable = true;
    private boolean needsUpdate = true;

    public SubCursor(Cursor<E> c, String keyField) {
        this.c = c;
        this.keyField = keyField;
    }

    public boolean advanceCursor() {
        if (!this.isNextAvailable) {
            return false;
        }
        if (!this.needsUpdate) {
            return true;
        }
        this.isNextAvailable = this.c.next();
        if (this.isNextAvailable) {
            this.record = (BComplex)this.c.get();
            this.curTimeStamp = (BAbsTime)this.record.get(this.keyField);
            this.needsUpdate = false;
            return true;
        }
        this.record = null;
        return false;
    }

    public BComplex doGet() {
        return this.get(this.curTimeStamp);
    }

    public BComplex get(BAbsTime timestamp) {
        BAbsTime curRecordTime = this.getTimestamp();
        if (curRecordTime.equals((Object)timestamp)) {
            this.needsUpdate = true;
            this.prevTimeStamp = this.curTimeStamp;
            this.copyRecord(this.record, this.previousRecord);
            return this.record;
        }
        if (this.getPrevRecordTimestamp().equals((Object)timestamp)) {
            this.needsUpdate = false;
            return this.previousRecord.asComplex();
        }
        return null;
    }

    public BAbsTime getTimestamp() {
        return this.curTimeStamp;
    }

    private BAbsTime getPrevRecordTimestamp() {
        return this.prevTimeStamp;
    }

    private void copyRecord(E srcRecord, BComponent dstRecord) {
        if (null == srcRecord || null == dstRecord) {
            return;
        }
        SlotCursor properties = srcRecord.getProperties();
        while (properties.next()) {
            Property slot = ((Property)properties.slot()).asProperty();
            BValue bValue = srcRecord.get(slot);
            String name = slot.getName();
            if (bValue instanceof BComplex) {
                bValue = bValue.newCopy(true);
            }
            if (null != dstRecord.get(name)) {
                dstRecord.set(name, bValue);
                Slot dstSlot = dstRecord.getSlot(name);
                dstRecord.setFacets(dstSlot, slot.getFacets());
                continue;
            }
            dstRecord.add(name, bValue, 0, slot.getFacets(), null);
        }
    }
}

