/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform;

import com.tridium.seriestransform.BIGraphResolver;
import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BTransformGraph;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BStation;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:LocalHost"})})
@NiagaraSingleton
public class BLocalGraphResolver
extends BSingleton
implements BIGraphResolver {
    @Generated
    public static final BLocalGraphResolver INSTANCE = new BLocalGraphResolver();
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalGraphResolver.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BLocalGraphResolver() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OrdTarget resolve(BISession session, OrdTarget base, OrdQuery query) {
        BTransformGraph graph;
        BTransformQuery tq = (BTransformQuery)query;
        BOrd graphOrd = tq.getGraphOrd();
        BStation station = Sys.getStation();
        BObject baseObj = base.get();
        BOrd baseOrd = null == baseObj || baseObj instanceof BLocalHost || !(baseObj instanceof BComponent) ? station.getAbsoluteOrd() : base.get().asComponent().getAbsoluteOrd();
        if (graphOrd == BOrd.NULL) {
            BObject bObject = baseOrd.get((BObject)station);
            if (!(bObject instanceof BTransformGraph)) throw new BajaRuntimeException("Transform ORD does not contain Graph Ord Path: " + base);
            graph = (BTransformGraph)bObject;
        } else {
            graph = (BTransformGraph)graphOrd.get((BObject)station);
        }
        BSeriesTransformTable resolve = null;
        try {
            BSeriesTransformTable[] results;
            NQueryParameters params = tq.decodeQueryParameters(graph);
            BSeriesTransformTable[] bSeriesTransformTableArray = results = graph.resolve(params, baseOrd, (Context)base);
            int n = bSeriesTransformTableArray.length;
            for (int i = 0; i < n; ++i) {
                BSeriesTransformTable result;
                resolve = result = bSeriesTransformTableArray[i];
            }
            return new OrdTarget(base, (BObject)resolve);
        }
        catch (Throwable e) {
            throw new BajaRuntimeException(e.getMessage(), e);
        }
    }
}

