/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.tls;

import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.provisioningNiagara.tls.BSetTlsLevelJobStep;
import java.util.ArrayList;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BSetTlsLevelDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BSetTlsLevelDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BSetTlsLevelDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetTlsLevelDialog.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private BSetTlsLevelJobStep result;
    private BTextDropDown tlsLevel;
    private BButton okButton;
    private BButton cancelButton;
    private final BInsets insets = BInsets.make((double)7.0);
    private BSslTlsEnum initialSelection;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetTlsLevelDialog(BWidget owner, BSslTlsEnum selection) {
        super(owner, LEX.getText("SetTlsLevelDialog.title"), true);
        this.initialSelection = selection;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BSetTlsLevelJobStep show(BWidget owner, BSslTlsEnum selection) {
        BSetTlsLevelDialog dialog = new BSetTlsLevelDialog(owner, selection);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() {
        BEdgePane pane = new BEdgePane();
        pane.setTop(BSetTlsLevelDialog.buildHeader());
        pane.setCenter(this.buildBody());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private static BWidget buildHeader() {
        return new BWizardHeader(null, LEX.getText("SetTlsLevelDialog.title"), LEX.get("SetTlsLevelDialog.description"));
    }

    private BWidget buildBody() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        ArrayList tlsLevels = new ArrayList();
        tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.3"));
        tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.2"));
        tlsLevels.add(CryptoSupport.TYPES.get("tlsv1.1"));
        tlsLevels.add(CryptoSupport.TYPES.get("tlsv1"));
        this.tlsLevel = new BTextDropDown(tlsLevels, 7, false);
        this.tlsLevel.setEnabled(false);
        this.tlsLevel.setEnabled(true);
        if (this.initialSelection == null) {
            this.initialSelection = BSslTlsEnum.tlsv1_3;
        }
        String selectedTextString = (String)CryptoSupport.TYPES.get(this.initialSelection.getTag());
        this.tlsLevel.setText(selectedTextString);
        this.tlsLevel.getList().setSelectedItem((Object)selectedTextString);
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.setRowGap(5.0);
        contentGrid.setColumnGap(5.0);
        contentGrid.setColumnAlign(BHalign.left);
        contentGrid.setStretchColumn(1);
        contentGrid.add(null, (BValue)new BLabel(LEX.getText("SetTlsLevelDialog.tlsLevel")));
        contentGrid.add(null, (BValue)this.tlsLevel);
        contentPane.add(null, (BValue)contentGrid);
        return new BBorderPane((BWidget)contentPane, this.insets);
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(true);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BAbstractButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BAbstractButton.actionPerformed, (Slot)cancelButtonPressed);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, this.insets);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        String version = this.tlsLevel.getText();
        String versionTag = (String)CryptoSupport.TYPE_TAG_TO_VERSION.get(version);
        this.result = new BSetTlsLevelJobStep(BSslTlsEnum.make((String)versionTag));
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    private BSetTlsLevelJobStep getResult() {
        return this.result;
    }
}

