/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.time;

import com.tridium.platform.ui.util.BBox;
import com.tridium.provisioningNiagara.time.BNtpSettings;
import com.tridium.provisioningNiagara.time.BSetTimeJobStep;
import com.tridium.provisioningNiagara.ui.BTogglePane;
import com.tridium.provisioningNiagara.ui.time.BNtpSettingsEditor;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BTimeZoneFE;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;

@NiagaraType
public class BSetTimeEditor
extends BWbEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSetTimeEditor.class);
    private final BTogglePane supervisorPane;
    private final BTogglePane selectedPane;
    private final BTogglePane ntpPane;
    private final BAbsTimeFE date;
    private final BNtpSettingsEditor ntpSettingsEditor;
    private static final BFacets TIME_FACETS = BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE, (String)"showDate", (BIDataValue)BBoolean.TRUE);
    private final BTimeZoneFE timeZone;
    private final ToggleCommandGroup<ToggleCommand> commandGroup = new ToggleCommandGroup();
    protected static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetTimeEditor() {
        this.supervisorPane = new BTogglePane(LEX.getText("SetTimeStepDialog.supervisorTime"));
        this.supervisorPane.setCommandGroup(this.commandGroup);
        this.supervisorPane.setSelected(true);
        BAbsTime now = BAbsTime.now();
        this.date = new BAbsTimeFE();
        this.date.loadValue((BObject)BAbsTime.now(), (Context)TIME_FACETS);
        this.timeZone = new BTimeZoneFE();
        this.timeZone.loadValue((BObject)now.getTimeZone());
        this.timeZone.computePreferredSize();
        BBox fillerBox = new BBox(this.timeZone.getPreferredWidth(), 0.0);
        BGridPane selectedInnerPane = new BGridPane(2);
        selectedInnerPane.setRowGap(5.0);
        selectedInnerPane.setColumnGap(5.0);
        selectedInnerPane.setColumnAlign(BHalign.left);
        selectedInnerPane.setStretchColumn(1);
        LabelUtil.addLabelWidgetPair((BPane)selectedInnerPane, (String)LEX.getText("SetTimeStepDialog.dateTime"), (BWidget)this.date);
        LabelUtil.addLabelWidgetPair((BPane)selectedInnerPane, (String)LEX.getText("SetTimeStepDialog.timeZone"), (BWidget)this.timeZone);
        selectedInnerPane.add(null, (BValue)new BNullWidget());
        selectedInnerPane.add(null, (BValue)fillerBox);
        this.selectedPane = new BTogglePane(LEX.getText("SetTimeStepDialog.selectedTime"), (BWidget)selectedInnerPane);
        this.selectedPane.setCommandGroup(this.commandGroup);
        this.ntpSettingsEditor = new BNtpSettingsEditor();
        this.ntpPane = new BTogglePane(LEX.getText("SetTimeStepDialog.ntpTime"), (BWidget)this.ntpSettingsEditor);
        this.ntpPane.setCommandGroup(this.commandGroup);
        BGridPane allContent = new BGridPane(1);
        allContent.add(null, (BValue)this.supervisorPane);
        allContent.add(null, (BValue)this.selectedPane);
        allContent.add(null, (BValue)this.ntpPane);
        allContent.setColumnAlign(BHalign.fill);
        this.setContent((BWidget)allContent);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BSetTimeJobStep jobStep = (BSetTimeJobStep)value;
        switch (jobStep.getTimeSetMethod().getOrdinal()) {
            case 0: {
                this.supervisorPane.setSelected(true);
                break;
            }
            case 1: {
                this.date.loadValue((BObject)jobStep.getDateTime(), (Context)TIME_FACETS);
                this.timeZone.loadValue((BObject)jobStep.getTimeZone());
                this.selectedPane.setSelected(true);
                break;
            }
            case 2: {
                this.ntpSettingsEditor.doLoadValue((BObject)jobStep.getNtpSettings(), null);
                this.ntpPane.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Found invalid value for time set method");
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.supervisorPane.getSelected()) {
            return new BSetTimeJobStep();
        }
        if (this.selectedPane.getSelected()) {
            return new BSetTimeJobStep((BAbsTime)this.date.saveValue(), (BTimeZone)this.timeZone.saveValue());
        }
        return new BSetTimeJobStep((BNtpSettings)this.ntpSettingsEditor.doSaveValue(null, null));
    }
}

