/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.station.BStationProxyOutputPane;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.util.Lexicon;

public class PauseOutputCommand
extends ToggleCommand {
    private BStationProxyOutputPane outputPane;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public PauseOutputCommand(BAbstractButton owner, BStationProxyOutputPane outputPane) {
        super((BWidget)owner, lex, "");
        this.outputPane = outputPane;
    }

    public void checkEnabled() {
        if (this.outputPane.getStation().getStationStatus() == BStationStatus.unknown) {
            this.setSelected(false);
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public String getLabel() {
        if (this.isSelected()) {
            return lex.getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.label");
        }
        return lex.getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.label");
    }

    public String getDescription() {
        if (this.isSelected()) {
            return lex.getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.description");
        }
        return lex.getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.description");
    }

    public CommandArtifact doInvoke() {
        try {
            BAbstractButton button = (BAbstractButton)this.getOwner();
            button.setText(this.getLabel());
            if (this.isSelected()) {
                this.outputPane.stopUpdates();
            } else {
                this.outputPane.load();
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        return null;
    }
}

