/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class SoftwareTableRow
implements SortableTableUtil.SortableRow {
    private List<BDependency> forwardDeps = new ArrayList<BDependency>();
    private Map<SoftwareTableRow, BDependency> reverseDepsByRow = new HashMap<SoftwareTableRow, BDependency>();
    private BPart currentPart = null;
    private boolean outOfDate = false;
    private boolean needsCommission = false;
    private long installablePartSize = Long.MIN_VALUE;
    private BInstallable installable;
    private SoftwareTableModel model;
    private BInstallable highestVersionInstallable = null;
    private BPartInstallStatus installStatus = BPartInstallStatus.noChange;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private int installableSigningStatus = Integer.MIN_VALUE;
    private int currentSigningStatus = Integer.MIN_VALUE;
    public static final int SIGNING_STATUS_UNAVAILABLE = 0;
    public static final int SIGNING_STATUS_UNKNOWN = 1;
    public static final int SIGNING_STATUS_LOW = 2;
    public static final int SIGNING_STATUS_MEDIUM = 3;
    public static final int SIGNING_STATUS_HIGH = 4;

    public SoftwareTableRow(SoftwareTableModel pModel) {
        this.model = pModel;
    }

    public int compareComment(SoftwareTableRow row) {
        int statusRank2;
        int statusRank1 = SoftwareTableRow.getStatusRank(this.getStatus());
        if (statusRank1 < (statusRank2 = SoftwareTableRow.getStatusRank(row.getStatus()))) {
            return -1;
        }
        if (statusRank1 > statusRank2) {
            return 1;
        }
        return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)row.getComment()));
    }

    public Object getRowId() {
        return this.getPartName();
    }

    public int compareToRowForColumn(SortableTableUtil.SortableRow sRow, int columnId) {
        SoftwareTableRow row = (SoftwareTableRow)sRow;
        switch (columnId) {
            case 0: {
                return TextUtil.toLowerCase((String)this.getPartName()).compareTo(TextUtil.toLowerCase((String)row.getPartName()));
            }
            case 3: {
                return this.compareComment(row);
            }
            case 1: {
                if (this.getCurrentPart() == null) {
                    if (row.getCurrentPart() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (row.getCurrentPart() == null) {
                    return 1;
                }
                return this.getCurrentPart().getVersion().compareTo((Object)row.getCurrentPart().getVersion());
            }
            case 2: {
                if (this.getInstallable() == null) {
                    if (row.getInstallable() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (row.getInstallable() == null) {
                    return 1;
                }
                return this.getInstallable().getVersion().compareTo((Object)row.getInstallable().getVersion());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static String statusToComment(int status) {
        switch (status) {
            case 6: {
                return lex.getText("StationSoftwareView.status.notInstalled");
            }
            case 3: 
            case 4: {
                return lex.getText("StationSoftwareView.status.outOfDate");
            }
            case 1: 
            case 2: 
            case 5: {
                return lex.getText("StationSoftwareView.status.upToDate");
            }
            case 7: {
                return lex.getText("StationSoftwareView.status.badInstallable");
            }
            case 8: 
            case 9: {
                return lex.getText("StationSoftwareView.status.badTarget");
            }
            case 10: 
            case 11: {
                return lex.getText("StationSoftwareView.status.noLocal");
            }
            case 12: {
                return lex.getText("StationSoftwareView.status.needCommissioningOod");
            }
            case 13: {
                return lex.getText("StationSoftwareView.status.needCommissioningMissing");
            }
        }
        return "";
    }

    public String getComment() {
        switch (this.getInstallStatus().getOrdinal()) {
            case 2: {
                return lex.getText("StationSoftwareView.status.install", new Object[]{this.installable.getVersion()});
            }
            case 3: {
                return lex.getText("StationSoftwareView.status.upgrade", new Object[]{this.installable.getVersion()});
            }
            case 4: {
                return lex.getText("StationSoftwareView.status.reinstall", new Object[]{this.installable.getVersion()});
            }
            case 5: {
                return lex.getText("StationSoftwareView.status.downgrade", new Object[]{this.installable.getVersion()});
            }
            case 6: {
                return lex.getText("StationSoftwareView.status.uninstall", new Object[]{this.currentPart.getVersion()});
            }
        }
        return SoftwareTableRow.statusToComment(this.getStatus());
    }

    public BPart getCurrentPart() {
        return this.currentPart;
    }

    public BImage getPartIcon() {
        if (this.getCurrentPart() == null) {
            if (this.getInstallablePart() == null) {
                return BImage.make((BIcon)this.getInstallable().getIcon());
            }
            return BImage.make((BIcon)this.getInstallablePart().getIcon());
        }
        return BImage.make((BIcon)this.getCurrentPart().getIcon());
    }

    public BVersion getCurrentVersion() {
        return this.currentPart == null ? null : this.currentPart.getVersion();
    }

    public String getInstallableName() {
        return this.installable == null ? null : this.installable.getInstallableName();
    }

    public BPart getInstallablePart() {
        return this.installable == null ? null : this.installable.getPart();
    }

    public BPart getHighestVersionedPart() {
        return this.highestVersionInstallable == null ? null : this.highestVersionInstallable.getPart();
    }

    public long getInstallablePartSize() {
        if (this.installable == null) {
            return 0L;
        }
        if (this.installablePartSize == Long.MIN_VALUE) {
            this.installablePartSize = this.installable instanceof BModuleInstallable ? ((BModulePart)this.getInstallablePart()).getFilteredFileSize(this.model.getTargetPlatform().getModuleContent(), this.model.getTargetPlatform().getStripLineNumbers()) : this.installable.getInstallableFileSize();
        }
        return this.installablePartSize;
    }

    public BVersion getHighestInstallableVersion() {
        if (this.highestVersionInstallable == null) {
            return this.installable == null ? null : this.installable.getVersion();
        }
        return this.highestVersionInstallable.getVersion();
    }

    public void setLatestAvailableInstallable(BInstallable value) {
        this.highestVersionInstallable = value;
    }

    public BVersion getInstallableVersion() {
        return this.installable == null ? null : this.installable.getVersion();
    }

    public String getPartName() {
        return this.installable == null ? this.currentPart.getPartName() : this.installable.getInstallableName();
    }

    public long getSizeDeltaOnCommit() {
        if (this.installStatus == BPartInstallStatus.install) {
            return this.getInstallablePartSize();
        }
        if (this.installStatus == BPartInstallStatus.uninstall) {
            BInstallable inst = this.currentPart.getInstallable();
            if (inst != null) {
                return -1L * inst.getInstallableFileSize();
            }
        } else if (this.installStatus == BPartInstallStatus.upgrade || this.installStatus == BPartInstallStatus.downgrade || this.installStatus == BPartInstallStatus.reinstall) {
            if (this.currentPart.getInstallable() == null) {
                return 0L;
            }
            return this.getInstallablePartSize() - this.currentPart.getInstallable().getInstallableFileSize();
        }
        return 0L;
    }

    public String getType() {
        if (this.currentPart == null) {
            if (this.installable.getPart() == null) {
                return this.installable.getDisplayName(null);
            }
            return BPart.getPartTypeShortName((Type)this.installable.getPart().getType());
        }
        return BPart.getPartTypeShortName((Type)this.currentPart.getType());
    }

    public int hashCode() {
        return this.getPartName().hashCode();
    }

    public boolean isModule() {
        BPart part = this.currentPart == null ? this.getInstallablePart() : this.currentPart;
        return part instanceof BModulePart;
    }

    public void setCurrentPart(BPart value) {
        this.currentPart = value;
        this.outOfDate = this.model.oodScenario.getPartStatus(value) == BPartInstallStatus.upgrade;
        this.updateRow();
    }

    public void setInstallable(BInstallable value) {
        if (this.installable != value) {
            this.installable = value;
            this.installablePartSize = Long.MIN_VALUE;
            this.updateRow();
        }
    }

    public BInstallable getInstallable() {
        return this.installable;
    }

    public String toString() {
        return this.getPartName();
    }

    public void setForwardDeps(List<BDependency> value) {
        this.forwardDeps = value;
        if (value != null) {
            for (BDependency dep : value) {
                if (dep.canSolveWith(this.model.scenario.getSolutionParameters().solvers)) continue;
                this.needsCommission = !this.model.scenario.getTargetPlatform().meets(dep);
                break;
            }
        }
    }

    public List<BDependency> getForwardDeps() {
        return this.forwardDeps;
    }

    public List<BPart> getDependentParts() {
        ArrayList<BPart> result = new ArrayList<BPart>();
        for (SoftwareTableRow depRow : this.reverseDepsByRow.keySet()) {
            if (depRow.getInstallablePart() == null) {
                result.add(depRow.getCurrentPart());
                continue;
            }
            result.add(depRow.getInstallablePart());
        }
        return result;
    }

    public Map<SoftwareTableRow, BDependency> getReverseDeps() {
        return this.reverseDepsByRow;
    }

    public void addReverseDep(SoftwareTableRow row, BDependency dep) {
        this.reverseDepsByRow.put(row, dep);
    }

    public void clearDeps() {
        this.forwardDeps.clear();
        this.reverseDepsByRow.clear();
    }

    public int getStatus() {
        if (this.currentPart == null) {
            if (this.installable != null) {
                if (this.installable instanceof BModuleInstallable && ((BModulePart)this.installable.getPart()).getStatus() != BModuleStatus.ok) {
                    return 7;
                }
                return this.needsCommission ? 13 : 6;
            }
        } else {
            if (this.installable == null) {
                if (this.currentPart instanceof BModulePart) {
                    BModuleStatus moduleStatus = ((BModulePart)this.currentPart).getStatus();
                    if (moduleStatus == BModuleStatus.nomanifest) {
                        return 10;
                    }
                    if (moduleStatus == BModuleStatus.ok) {
                        return 11;
                    }
                    return 8;
                }
                return 11;
            }
            BVersion currentVersion = this.currentPart.getVersion();
            BVersion installableVersion = this.installable.getPart().getVersion();
            if (this.installable instanceof BModuleInstallable && !((BModulePart)this.installable.getPart()).getStatus().equals((Object)BModuleStatus.ok)) {
                if (this.currentPart instanceof BModulePart && !((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                    return 9;
                }
                return 7;
            }
            if (this.currentPart instanceof BModulePart && !((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                return 8;
            }
            switch (currentVersion.checkVersionRequirement(installableVersion)) {
                case 2: {
                    if (this.currentPart instanceof BModulePart) {
                        BModulePart currentModule = (BModulePart)this.currentPart;
                        BModulePart installableModule = (BModulePart)this.installable.getPart();
                        if (currentModule.getBuildAbsTime() != null && installableModule.getBuildAbsTime() != null) {
                            int dateStampComp = installableModule.getBuildAbsTime().compareTo((Object)currentModule.getBuildAbsTime());
                            if (dateStampComp > 0) {
                                return this.outOfDate ? 3 : 12;
                            }
                            if (dateStampComp < 0) {
                                return 1;
                            }
                            return 2;
                        }
                        return 2;
                    }
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 8: {
                    return this.outOfDate ? 4 : 12;
                }
                case 4: {
                    return this.outOfDate ? 3 : 12;
                }
            }
            return 1;
        }
        return 0;
    }

    public static int getStatus(BInstallable installable, BPart currentPart) {
        if (currentPart == null) {
            if (installable != null) {
                if (installable instanceof BModuleInstallable && ((BModulePart)installable.getPart()).getStatus() != BModuleStatus.ok) {
                    return 7;
                }
                return 6;
            }
        } else {
            if (installable == null) {
                if (currentPart instanceof BModulePart) {
                    BModuleStatus moduleStatus = ((BModulePart)currentPart).getStatus();
                    if (moduleStatus == BModuleStatus.nomanifest) {
                        return 10;
                    }
                    if (moduleStatus == BModuleStatus.ok) {
                        return 11;
                    }
                    return 8;
                }
                return 11;
            }
            BVersion currentVersion = currentPart.getVersion();
            BVersion installableVersion = installable.getPart().getVersion();
            if (installable instanceof BModuleInstallable && !((BModulePart)installable.getPart()).getStatus().equals((Object)BModuleStatus.ok)) {
                if (currentPart instanceof BModulePart && !((BModulePart)currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                    return 9;
                }
                return 7;
            }
            if (currentPart instanceof BModulePart && !((BModulePart)currentPart).getStatus().equals((Object)BModuleStatus.ok)) {
                return 8;
            }
            switch (currentVersion.checkVersionRequirement(installableVersion)) {
                case 2: {
                    if (currentPart instanceof BModulePart) {
                        BModulePart currentModule = (BModulePart)currentPart;
                        BModulePart installableModule = (BModulePart)installable.getPart();
                        if (currentModule.getBuildAbsTime() != null && installableModule.getBuildAbsTime() != null) {
                            int dateStampComp = installableModule.getBuildAbsTime().compareTo((Object)currentModule.getBuildAbsTime());
                            if (dateStampComp > 0) {
                                return 3;
                            }
                            if (dateStampComp < 0) {
                                return 1;
                            }
                            return 2;
                        }
                        return 2;
                    }
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 8: {
                    return 4;
                }
                case 4: {
                    return 3;
                }
            }
            return 1;
        }
        return 0;
    }

    public void updateRow() {
        this.installStatus = this.model.getScenario().getPartStatus(this.getPart());
    }

    public BPart getPart() {
        return this.installable == null ? this.currentPart : this.installable.getPart();
    }

    public BPartInstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public static int getStatusRank(int status) {
        switch (status) {
            case 7: 
            case 8: 
            case 9: {
                return 0;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 1: 
            case 2: 
            case 5: {
                return 6;
            }
            case 0: 
            case 10: 
            case 11: {
                return 7;
            }
        }
        return 5;
    }

    public int getCurrentSigningStatus() {
        if (this.currentSigningStatus == Integer.MIN_VALUE) {
            this.currentSigningStatus = SoftwareTableRow.getSigningStatus(this.getCurrentPart(), this.model.getModuleVerificationMode(), this.model.getCertValidator());
        }
        return this.currentSigningStatus;
    }

    public int getInstallableSigningStatus() {
        if (this.installableSigningStatus == Integer.MIN_VALUE) {
            this.installableSigningStatus = SoftwareTableRow.getSigningStatus(this.getInstallablePart(), this.model.getModuleVerificationMode(), this.model.getCertValidator());
        }
        return this.installableSigningStatus;
    }

    private static int getSigningStatus(BPart part, ModuleVerificationMode verificationMode, CertificateChainValidator certValidator) {
        if (part instanceof BModulePart) {
            List statuses = ((BModulePart)part).getSignatureStatus(certValidator);
            if (statuses.contains(ModuleSignatureStatusEnum.UNKNOWN)) {
                return 1;
            }
            if (statuses.contains(ModuleSignatureStatusEnum.OK)) {
                return 4;
            }
            for (ModuleSignatureStatusEnum status : statuses) {
                if (status.isAcceptable(verificationMode)) continue;
                return 2;
            }
            return 3;
        }
        return 0;
    }

    protected boolean needsCommission() {
        return this.needsCommission;
    }
}

