/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BPartInstallStatus;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.table.TableCellRenderer;

public class SoftwareCellRenderer
extends TableCellRenderer {
    public SoftwareTableModel getSoftwareTableModel() {
        return (SoftwareTableModel)this.getTable().getModel();
    }

    public BBrush getForeground(TableCellRenderer.Cell cell) {
        if (cell.column == 3) {
            if (this.getSoftwareTableModel().getInstallStatusAt(cell.row) != BPartInstallStatus.noChange) {
                return BColor.blue.toBrush();
            }
            switch (this.getSoftwareTableModel().getStatusAt(cell.row)) {
                case 6: 
                case 13: {
                    return BColor.blue.toBrush();
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getForeground(cell);
    }

    public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
        int status = this.getSoftwareTableModel().getStatusAt(cell.row);
        if (cell.column == 3) {
            switch (status) {
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    return BColor.red.toBrush();
                }
            }
        }
        return super.getSelectionForeground(cell);
    }

    public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
        String s = this.getCellText(cell);
        double w = Theme.table().getCellFont().width(s) + 12.0;
        if (this.getSoftwareTableModel().getCellIcon(cell.row, cell.column) != null) {
            w += 20.0;
        }
        return w;
    }

    public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
        SoftwareTableModel model = this.getSoftwareTableModel();
        this.paintCellBackground(g, cell);
        double x = 2.0;
        double y = (cell.height - 16.0) / 2.0;
        BImage icon = model.getCellIcon(cell.row, cell.column);
        if (icon != null) {
            g.drawImage(icon, x, y);
            x += 20.0;
        }
        String s = this.getCellText(cell);
        BFont font = Theme.table().getCellFont();
        switch (model.getColumnAlignment(cell.column).getOrdinal()) {
            case 2: {
                x = cell.width - 2.0 - font.width(s);
                break;
            }
            case 1: {
                x = (cell.width - font.width(s)) / 2.0;
            }
        }
        g.setFont(font);
        g.drawString(s, x, font.getAscent() + 2.0);
    }
}

