/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.credentials;

import com.tridium.provisioningNiagara.credentials.BAddStationUserStep;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="passwordModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BAddStationUserStepDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action passwordModified = BAddStationUserStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAddStationUserStepDialog.class);
    private BAddStationUserStep result;
    private final BButton okButton = new BButton();
    private final BButton cancelButton = new BButton();
    private final BTextField username = new BTextField();
    private final BPasswordFE password = new BPasswordFE();
    private final BPasswordFE confirmedPassword = new BPasswordFE();
    private final BCheckBox isAdmin = new BCheckBox();

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void passwordModified(BWidgetEvent parameter) {
        this.invoke(passwordModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BAddStationUserStepDialog() throws Exception {
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public BAddStationUserStepDialog(BWidget owner) throws Exception {
        super(owner, "", true);
        this.setTitle(this.lexValue("title", new Object[0]));
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BAddStationUserStep show(BWidget owner) throws Exception {
        BAddStationUserStepDialog dialog = new BAddStationUserStepDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    public static BAddStationUserStep show(BWidget owner, BObject step, Context context) throws Exception {
        BAddStationUserStepDialog dialog = new BAddStationUserStepDialog(owner);
        BAddStationUserStep oldStep = (BAddStationUserStep)step;
        dialog.username.setText(oldStep.getUsername());
        dialog.password.loadValue((BObject)oldStep.getPassword(), context);
        dialog.confirmedPassword.loadValue((BObject)oldStep.getPassword(), context);
        dialog.isAdmin.setSelected(oldStep.getAdmin());
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() throws Exception {
        return new BWizardHeader(null, this.lexValue("title", new Object[0]), this.lexValue("description", new Object[0]));
    }

    private BWidget buildContent() throws Exception {
        BGridPane content = new BGridPane(1);
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("username", new Object[0])));
        contentGrid.add(null, (BValue)this.username);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("password", new Object[0])));
        this.password.loadValue((BObject)BPassword.DEFAULT);
        contentGrid.add(null, (BValue)this.password);
        contentGrid.add(null, (BValue)new BLabel(this.lexValue("confirmedPassword", new Object[0])));
        this.confirmedPassword.loadValue((BObject)BPassword.DEFAULT);
        contentGrid.add(null, (BValue)this.confirmedPassword);
        content.add(null, (BValue)contentGrid);
        this.isAdmin.setText(this.lexValue("admin", new Object[0]));
        this.isAdmin.setSelected(false);
        this.isAdmin.setEnabled(true);
        content.add(null, (BValue)this.isAdmin);
        return new BBorderPane((BWidget)content, 7.0, 7.0, 0.0, 7.0);
    }

    private BWidget buildButtonPane() throws Exception {
        this.okButton.setText(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton.setText(UiLexicon.bajaui().getText("dialog.cancel"));
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.linkTo("linkC", (BComponent)this.password, (Slot)BPasswordFE.setModified, (Slot)passwordModified);
        this.linkTo("linkD", (BComponent)this.confirmedPassword, (Slot)BPasswordFE.setModified, (Slot)passwordModified);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword confirmedValue;
        BPassword passwordValue = (BPassword)this.password.saveValue();
        if (!passwordValue.validate(confirmedValue = (BPassword)this.confirmedPassword.saveValue())) {
            BDialog.error((BWidget)this, (Object)this.lexValue("passwordMismatch", new Object[0]));
            return;
        }
        if (this.username.getText().isEmpty()) {
            BDialog.error((BWidget)this, (Object)this.lexValue("usernameRequired", new Object[0]));
            return;
        }
        String passwordChars = AccessController.doPrivileged(() -> ((BPassword)passwordValue).getValue());
        if (passwordValue == BPassword.DEFAULT || passwordChars.isEmpty()) {
            BDialog.error((BWidget)this, (Object)this.lexValue("passwordRequired", new Object[0]));
            return;
        }
        this.result = new BAddStationUserStep(this.username.getText(), (BPassword)this.password.saveValue(), this.isAdmin.getSelected());
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public void doPasswordModified(BWidgetEvent event) throws Exception {
        BPassword passwordValue = (BPassword)this.password.saveValue();
        BPassword confirmedValue = (BPassword)this.confirmedPassword.saveValue();
        this.okButton.setEnabled(passwordValue.validate(confirmedValue));
    }

    protected String lexValue(String key, Object ... parameters) {
        return this.getLexicon().getText(this.getType().getTypeName() + "." + key, parameters);
    }

    public BAddStationUserStep getResult() {
        return this.result;
    }
}

