/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.BNiagaraNetworkJobEditor;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:NiagaraNetworkJobPrototype"})})
public class BNiagaraNetworkPrototypeView
extends BNiagaraNetworkJobEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkPrototypeView.class);
    private final Command submit = new Submit();
    private final long SCREEN_HYPERLINK_DELAY = 2000L;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetworkPrototypeView() {
        this.buttons.add(this.submit);
        this.linkTo(null, (BComponent)this.alertOnStepFailureCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.alertOnJobSuccessCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stations, (Slot)BList.listModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.allJobSteps, (Slot)BList.listModified, (Slot)setModified);
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        BBatchJobPrototype proto = (BBatchJobPrototype)this.getCurrentValue();
        proto.lease(Integer.MAX_VALUE);
        BNiagaraNetworkJob job = (BNiagaraNetworkJob)proto.getJobPrototype();
        this.alertOnStepFailureCheckBox.setSelected(job.getAlertOnStepFailure());
        this.alertOnJobSuccessCheckBox.setSelected(job.getAlertOnJobSuccess());
        this.stations.loadFromJob((BDeviceNetworkJob)job);
        this.allJobSteps.load((BDeviceNetworkJob)job, (BObject)job.getNetwork());
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell != null) {
            this.buttons.add(shell.getSaveCommand(), true, true);
            this.buttons.add(shell.getRefreshCommand(), true, true);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        this.saveJob();
        return value;
    }

    @Override
    protected BNiagaraNetworkJob saveJob() {
        BNiagaraNetworkJob job = (BNiagaraNetworkJob)((BBatchJobPrototype)this.getCurrentValue()).getJobPrototype();
        job.setAlertOnStepFailure(this.alertOnStepFailureCheckBox.isSelected());
        job.setAlertOnJobSuccess(this.alertOnJobSuccessCheckBox.isSelected());
        this.stations.saveToJob((BDeviceNetworkJob)job);
        this.allJobSteps.saveToStage((BJobStage)job.getInitialStage());
        this.allJobSteps.saveToStage((BJobStage)job.getForEachStationStage());
        return job;
    }

    @Override
    public void doHandleListUpdated(BWidgetEvent event) {
        boolean enable = this.stations.getModel().getItemCount() > 0 && this.allJobSteps.getModel().getItemCount() > 0;
        this.submit.setEnabled(enable);
    }

    private class Submit
    extends Command {
        public Submit() {
            super((BWidget)BNiagaraNetworkPrototypeView.this, BNiagaraNetworkJobEditor.lex, "NiagaraNetworkJobBuilder.submit");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJobPrototype proto = (BBatchJobPrototype)BNiagaraNetworkPrototypeView.this.getCurrentValue();
                BNiagaraNetworkPrototypeView.this.saveJob();
                BBatchJob job = proto.submit();
                BWbShell shell = BWbShell.getWbShell((BWidget)BNiagaraNetworkPrototypeView.this);
                if (shell != null) {
                    Thread.sleep(2000L);
                    shell.hyperlink(job.getNavOrd());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

