/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.station;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="stationStatus", type="BStationStatus", defaultValue="BStationStatus.unknown", flags=3), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="isRestartEnabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isRebootEnabled", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isAutoStart", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isAutoRestart", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="isAcceptingMessages", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="logBufferSize", type="int", defaultValue="32767", flags=3), @NiagaraProperty(name="logBufferFileSize", type="int", defaultValue="32767", flags=3), @NiagaraProperty(name="numCpus", type="int", defaultValue="1", flags=3), @NiagaraProperty(name="currentCpuUsage", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="overallCpuUsage", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="totalPhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="freePhysicalMemory", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="filesystemAttributes", type="BVector", defaultValue="new BVector()", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="poll", flags=16), @NiagaraAction(name="pollWithNotify", parameterType="BString", defaultValue="BString.DEFAULT", flags=20, facets={@Facet(name="BProvisioningStationExt.NOTIFY_ACTION_COMPLETE", value="BBoolean.TRUE")}), @NiagaraAction(name="dumpThreads", flags=16), @NiagaraAction(name="saveStation", flags=16), @NiagaraAction(name="saveStationWithNotify", parameterType="BString", defaultValue="BString.DEFAULT", flags=20, facets={@Facet(name="BProvisioningStationExt.NOTIFY_ACTION_COMPLETE", value="BBoolean.TRUE")}), @NiagaraAction(name="stopStation", flags=144), @NiagaraAction(name="stopStationWithNotify", parameterType="BString", defaultValue="BString.DEFAULT", flags=20, facets={@Facet(name="BProvisioningStationExt.NOTIFY_ACTION_COMPLETE", value="BBoolean.TRUE")}), @NiagaraAction(name="startStation"), @NiagaraAction(name="killStation", flags=144), @NiagaraAction(name="killStationWithNotify", parameterType="BString", defaultValue="BString.DEFAULT", flags=20, facets={@Facet(name="BProvisioningStationExt.NOTIFY_ACTION_COMPLETE", value="BBoolean.TRUE")}), @NiagaraAction(name="restartStation", flags=144), @NiagaraAction(name="rebootHost", flags=144), @NiagaraAction(name="updateLogBufferSize", flags=20), @NiagaraAction(name="updateStartSettings", flags=20)})
public class BStationProxy
extends BProvisioningStationExt
implements BIMixIn,
BIPollable {
    @Generated
    public static final Property stationStatus = BStationProxy.newProperty((int)3, (BValue)BStationStatus.unknown, null);
    @Generated
    public static final Property pollFrequency = BStationProxy.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property isRestartEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isRebootEnabled = BStationProxy.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isAutoStart = BStationProxy.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isAutoRestart = BStationProxy.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property isAcceptingMessages = BStationProxy.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property logBufferSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    @Generated
    public static final Property logBufferFileSize = BStationProxy.newProperty((int)3, (int)Short.MAX_VALUE, null);
    @Generated
    public static final Property numCpus = BStationProxy.newProperty((int)3, (int)1, null);
    @Generated
    public static final Property currentCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property overallCpuUsage = BStationProxy.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property totalPhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property freePhysicalMemory = BStationProxy.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property filesystemAttributes = BStationProxy.newProperty((int)3, (BValue)new BVector(), null);
    @Generated
    public static final Action poll = BStationProxy.newAction((int)16, null);
    @Generated
    public static final Action pollWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action dumpThreads = BStationProxy.newAction((int)16, null);
    @Generated
    public static final Action saveStation = BStationProxy.newAction((int)16, null);
    @Generated
    public static final Action saveStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action stopStation = BStationProxy.newAction((int)144, null);
    @Generated
    public static final Action stopStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action startStation = BStationProxy.newAction((int)0, null);
    @Generated
    public static final Action killStation = BStationProxy.newAction((int)144, null);
    @Generated
    public static final Action killStationWithNotify = BStationProxy.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action restartStation = BStationProxy.newAction((int)144, null);
    @Generated
    public static final Action rebootHost = BStationProxy.newAction((int)144, null);
    @Generated
    public static final Action updateLogBufferSize = BStationProxy.newAction((int)20, null);
    @Generated
    public static final Action updateStartSettings = BStationProxy.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStationProxy.class);
    private volatile boolean allowStartUpdate = true;
    private boolean startUpdated = false;
    private boolean inPoll = false;
    public static BIcon ICON = BIcon.std((String)"computer.png");
    public static final String FACET_TIMEOUT = "timeout";

    @Generated
    public BStationStatus getStationStatus() {
        return (BStationStatus)this.get(stationStatus);
    }

    @Generated
    public void setStationStatus(BStationStatus v) {
        this.set(stationStatus, (BValue)v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public boolean getIsRestartEnabled() {
        return this.getBoolean(isRestartEnabled);
    }

    @Generated
    public void setIsRestartEnabled(boolean v) {
        this.setBoolean(isRestartEnabled, v, null);
    }

    @Generated
    public boolean getIsRebootEnabled() {
        return this.getBoolean(isRebootEnabled);
    }

    @Generated
    public void setIsRebootEnabled(boolean v) {
        this.setBoolean(isRebootEnabled, v, null);
    }

    @Generated
    public boolean getIsAutoStart() {
        return this.getBoolean(isAutoStart);
    }

    @Generated
    public void setIsAutoStart(boolean v) {
        this.setBoolean(isAutoStart, v, null);
    }

    @Generated
    public boolean getIsAutoRestart() {
        return this.getBoolean(isAutoRestart);
    }

    @Generated
    public void setIsAutoRestart(boolean v) {
        this.setBoolean(isAutoRestart, v, null);
    }

    @Generated
    public boolean getIsAcceptingMessages() {
        return this.getBoolean(isAcceptingMessages);
    }

    @Generated
    public void setIsAcceptingMessages(boolean v) {
        this.setBoolean(isAcceptingMessages, v, null);
    }

    @Generated
    public int getLogBufferSize() {
        return this.getInt(logBufferSize);
    }

    @Generated
    public void setLogBufferSize(int v) {
        this.setInt(logBufferSize, v, null);
    }

    @Generated
    public int getLogBufferFileSize() {
        return this.getInt(logBufferFileSize);
    }

    @Generated
    public void setLogBufferFileSize(int v) {
        this.setInt(logBufferFileSize, v, null);
    }

    @Generated
    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    @Generated
    public void setNumCpus(int v) {
        this.setInt(numCpus, v, null);
    }

    @Generated
    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    @Generated
    public void setCurrentCpuUsage(int v) {
        this.setInt(currentCpuUsage, v, null);
    }

    @Generated
    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    @Generated
    public void setOverallCpuUsage(int v) {
        this.setInt(overallCpuUsage, v, null);
    }

    @Generated
    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    @Generated
    public void setTotalPhysicalMemory(int v) {
        this.setInt(totalPhysicalMemory, v, null);
    }

    @Generated
    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    @Generated
    public void setFreePhysicalMemory(int v) {
        this.setInt(freePhysicalMemory, v, null);
    }

    @Generated
    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    @Generated
    public void setFilesystemAttributes(BVector v) {
        this.set(filesystemAttributes, (BValue)v, null);
    }

    @Generated
    public void poll() {
        this.invoke(poll, null, null);
    }

    @Generated
    public void pollWithNotify(BString parameter) {
        this.invoke(pollWithNotify, (BValue)parameter, null);
    }

    @Generated
    public void dumpThreads() {
        this.invoke(dumpThreads, null, null);
    }

    @Generated
    public void saveStation() {
        this.invoke(saveStation, null, null);
    }

    @Generated
    public void saveStationWithNotify(BString parameter) {
        this.invoke(saveStationWithNotify, (BValue)parameter, null);
    }

    @Generated
    public void stopStation() {
        this.invoke(stopStation, null, null);
    }

    @Generated
    public void stopStationWithNotify(BString parameter) {
        this.invoke(stopStationWithNotify, (BValue)parameter, null);
    }

    @Generated
    public void startStation() {
        this.invoke(startStation, null, null);
    }

    @Generated
    public void killStation() {
        this.invoke(killStation, null, null);
    }

    @Generated
    public void killStationWithNotify(BString parameter) {
        this.invoke(killStationWithNotify, (BValue)parameter, null);
    }

    @Generated
    public void restartStation() {
        this.invoke(restartStation, null, null);
    }

    @Generated
    public void rebootHost() {
        this.invoke(rebootHost, null, null);
    }

    @Generated
    public void updateLogBufferSize() {
        this.invoke(updateLogBufferSize, null, null);
    }

    @Generated
    public void updateStartSettings() {
        this.invoke(updateStartSettings, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("StationProxy");
    }

    public void subscribed() {
        try {
            BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            nwExt.getPollScheduler().subscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void unsubscribed() {
        try {
            BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            nwExt.getPollScheduler().unsubscribe(this);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.allowStartUpdate && (prop == isAutoStart || prop == isAutoRestart)) {
            this.startUpdated = true;
        }
    }

    public BFilesystemAttributes getFilesystemAttributes(FilePath path) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            BDaemonSession session = this.getDaemonSession();
            if (session == null) {
                throw new IllegalStateException("Daemon session unavailable");
            }
            return DaemonFileUtil.getFilesystemAttributes((BDaemonSession)session, (FilePath)path);
        }
        return this.channel().getFilesystemAttributes(this.getStationName(), path);
    }

    public String getStationName() {
        return this.getNiagaraStation().getStationName();
    }

    public String getStationDisplayName() {
        return this.getNiagaraStation().getDisplayName(null);
    }

    public InputStream getStationOutput(boolean follow, boolean updatesOnly) throws Exception {
        if (this.isUnoperational()) {
            return null;
        }
        if (this.isRunning()) {
            return this.getStationSurrogate().getStationOutput(follow, updatesOnly);
        }
        return this.channel().getStationOutput(this.getStationName(), follow, updatesOnly);
    }

    public void startStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().startStation(cancelHint, listener);
        } else {
            this.channel().startStation(this.getStationName(), cancelHint, listener);
        }
    }

    public void stopStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().stopStation(BStationProxy.stationShutdownCancelHint(cancelHint, null), listener);
        } else {
            this.channel().stopStation(this.getStationName(), cancelHint, listener);
        }
    }

    public void saveStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().saveStation(cancelHint, listener);
        } else {
            this.channel().saveStation(this.getStationName(), cancelHint, listener);
        }
    }

    public void killStation(ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (this.isRunning()) {
            this.getStationSurrogate().killStation(cancelHint, listener);
        } else {
            this.channel().killStation(this.getStationName(), cancelHint, listener);
        }
    }

    public void doPoll(Context cx) throws Exception {
        this.doPollWithNotify(null, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPollWithNotify(BString invokeId, Context cx) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        canceledListener = this.startAsyncAction(invokeId, cx);
        try {
            if (this.inPoll) {
                this.asyncActionComplete(canceledListener, null, cx);
                return;
            }
            this.inPoll = true;
            if (this.isUnoperational()) {
                this.clearDown();
                this.asyncActionComplete(canceledListener, null, cx);
                this.inPoll = false;
                return;
            }
            timeout = BDaemonSession.DEFAULT_TIMEOUT;
            if (cx != null) {
                timeout = cx.getFacets().geti("timeout", timeout);
            }
            if ((session = this.getDaemonSession()) == null) {
                this.setDown();
                this.asyncActionComplete(canceledListener, null, cx);
                this.inPoll = false;
                return;
            }
            props = session.updateHostProperties(timeout);
            var7_9 = this;
            synchronized (var7_9) {
                this.setNumCpus(props.getNumCpus());
                this.setCurrentCpuUsage(props.getCurrentCpuUsage());
                this.setOverallCpuUsage(props.getOverallCpuUsage());
                this.setTotalPhysicalMemory(props.getTotalPhysicalMemory());
                this.setFreePhysicalMemory(props.getFreePhysicalMemory());
                slotsToRemove = new ArrayList<String>();
                c = this.getFilesystemAttributes().getProperties();
                while (c.next(BFilesystemAttributes.class)) {
                    slotsToRemove.add(((Property)c.slot()).getName());
                }
                cFs = props.getFilesystemAttributes().getProperties();
                while (cFs.next(BFilesystemAttributes.class)) {
                    slotName = ((Property)cFs.slot()).getName();
                    slotsToRemove.remove(slotName);
                    attrs = (BFilesystemAttributes)cFs.get();
                    p = this.getFilesystemAttributes().getProperty(slotName);
                    if (p == null) {
                        this.getFilesystemAttributes().add(slotName, attrs.newCopy());
                        continue;
                    }
                    currentAttrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(p);
                    cAttr = attrs.getProperties();
                    while (cAttr.next()) {
                        value = cAttr.get();
                        if (value instanceof BComplex) {
                            currentAttrs.set(cAttr.property(), value.newCopy());
                            continue;
                        }
                        currentAttrs.set(cAttr.property(), value);
                    }
                }
                for (String aSlotsToRemove : slotsToRemove) {
                    this.getFilesystemAttributes().remove(aSlotsToRemove);
                }
            }
            surrogate = this.getStationSurrogate();
            var8_10 = this;
            synchronized (var8_10) {
                if (surrogate != null) ** break block29
                this.clearDown();
                this.asyncActionComplete(canceledListener, null, cx);
            }
            this.inPoll = false;
            return;
            {
                ** try [egrp 6[TRYBLOCK] [11 : 502->670)] { 
lbl75:
                // 1 sources

                try {
                    if (!this.startUpdated) {
                        this.allowStartUpdate = false;
                        if (surrogate.getIsAutoStart() != this.getIsAutoStart()) {
                            this.setIsAutoStart(surrogate.getIsAutoStart());
                        }
                        if (surrogate.getIsAutoRestart() != this.getIsAutoRestart()) {
                            this.setIsAutoRestart(surrogate.getIsAutoRestart());
                        }
                        this.allowStartUpdate = true;
                    }
                    this.setStationStatus(surrogate.getStationStatus());
                    this.setIsAcceptingMessages(surrogate.getIsAcceptingMessages());
                    this.setLogBufferFileSize(surrogate.getLogBufferFileSize());
                    this.setLogBufferSize(surrogate.getLogBufferSize());
                    this.setIsRestartEnabled(surrogate.isRestartEnabled());
                    this.setIsRebootEnabled(props.supportsServlet("reboot") != false && props.getHostId().equals(Nre.getHostId()) == false);
                    this.clearDown();
                }
                catch (IOException ioe) {
                    this.setDown();
                    this.reset();
                }
                ** break block30
lbl95:
                // 1 sources

                finally {
                    this.inPoll = false;
                }
            }
        }
        catch (Exception e) {
            this.asyncActionException(canceledListener, e, cx);
            return;
        }
lbl-1000:
        // 2 sources

        {
            this.asyncActionComplete(canceledListener, null, cx);
            return;
        }
    }

    public void reset() {
        this.setStationStatus(BStationStatus.unknown);
        this.setIsAcceptingMessages(false);
        this.setIsRestartEnabled(false);
        this.setIsRebootEnabled(false);
    }

    public void doStopStation(Context cx) throws Exception {
        this.doStopStationWithNotify(null, cx);
    }

    public void doStopStationWithNotify(BString invokeId, Context cx) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(invokeId, cx);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, cx);
                return;
            }
            this.setStationStatus(BStationStatus.stopping);
            if (canceledListener == null) {
                this.getStationSurrogate().stopStationAsync();
            } else {
                this.getStationSurrogate().stopStation(BStationProxy.stationShutdownCancelHint(canceledListener, null), null);
            }
        }
        catch (Exception e) {
            this.asyncActionException(canceledListener, e, cx);
            return;
        }
        this.asyncActionComplete(canceledListener, null, cx);
    }

    public static ICancelHint stationShutdownCancelHint(ICancelHint canceledListener, RuntimeException throwOnCancel) {
        try {
            BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            int timeout = ext.getStationShutdownTimeout();
            if (timeout <= 0) {
                return canceledListener;
            }
            TimedCancel result = new TimedCancel(canceledListener, timeout, throwOnCancel);
            result.start();
            return result;
        }
        catch (Exception e) {
            return canceledListener;
        }
    }

    public static ICancelHint rebootCancelHint(ICancelHint canceledListener, RuntimeException throwOnCancel) {
        try {
            BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            int timeout = ext.getDeviceRebootTimeout();
            if (timeout <= 0) {
                return canceledListener;
            }
            TimedCancel result = new TimedCancel(canceledListener, timeout, throwOnCancel);
            result.start();
            return result;
        }
        catch (Exception e) {
            return canceledListener;
        }
    }

    public void doStartStation() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.setStationStatus(BStationStatus.starting);
        this.getStationSurrogate().startStationAsync();
    }

    public void doKillStation(Context cx) throws Exception {
        this.doKillStationWithNotify(null, cx);
    }

    public void doKillStationWithNotify(BString invokeId, Context cx) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(invokeId, cx);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, cx);
                return;
            }
            if (canceledListener == null) {
                this.getStationSurrogate().killStationAsync();
            } else {
                this.getStationSurrogate().killStation((ICancelHint)canceledListener, null);
            }
        }
        catch (Exception e) {
            this.asyncActionException(canceledListener, e, cx);
            return;
        }
        this.asyncActionComplete(canceledListener, null, cx);
    }

    public void doRestartStation(Context cx) throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        if (!this.getIsRestartEnabled()) {
            throw new IllegalStateException("Restart not permitted");
        }
        this.setStationStatus(BStationStatus.stopping);
        this.getStationSurrogate().restartStationAsync();
    }

    public void doRebootHost() throws Exception {
        BDaemonSession session;
        if (this.isUnoperational()) {
            return;
        }
        if (this.getIsRebootEnabled()) {
            session = this.getDaemonSession();
            if (session == null) {
                throw new IllegalStateException("Daemon session unavailable");
            }
        } else {
            throw new IllegalStateException("Reboot not permitted");
        }
        session.sendRebootRequest(false);
        this.reset();
    }

    public void doDumpThreads() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().dumpThreads();
    }

    public void doSaveStation(Context cx) throws Exception {
        this.doSaveStationWithNotify(null, cx);
    }

    public void doSaveStationWithNotify(BString invokeId, Context cx) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(invokeId, cx);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, cx);
                return;
            }
            if (canceledListener == null) {
                this.getStationSurrogate().saveStationAsync();
            } else {
                this.getStationSurrogate().saveStation((ICancelHint)canceledListener, null);
            }
        }
        catch (Exception e) {
            this.asyncActionException(canceledListener, e, cx);
            return;
        }
        this.asyncActionComplete(canceledListener, null, cx);
    }

    public void doUpdateLogBufferSize() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateLogBufferSize(this.getLogBufferSize(), this.getLogBufferFileSize());
    }

    public void doUpdateStartSettings() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        this.getStationSurrogate().updateSettings(this.getIsAutoStart(), this.getIsAutoRestart());
        this.startUpdated = false;
    }

    protected BStationSurrogate getStationSurrogate() throws Exception {
        BDaemonSession session = this.getDaemonSession();
        return session == null ? null : BStationSurrogate.make((BDaemonSession)session, (String)this.getStationName());
    }

    protected BNiagaraProvisioningChannel channel() throws Exception {
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)this);
        return (BNiagaraProvisioningChannel)session.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
    }

    @Override
    public boolean isUnoperational() {
        return this.isDisabled() || this.isFault();
    }

    protected void setDown() {
        if (!this.getStatus().isDown()) {
            int bits = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(bits |= 4)));
        }
    }

    protected void clearDown() {
        if (this.getStatus().isDown()) {
            int bits = this.getStatus().getBits();
            this.setStatus(BStatus.make((int)(bits &= 0xFFFFFFFB)));
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    protected static class TimedCancel
    extends Thread
    implements ICancelHint {
        private final ICancelHint cancelHint;
        private final long timeoutSeconds;
        private boolean isTimedOut = false;
        private final RuntimeException throwOnTimeout;

        public TimedCancel(ICancelHint canceledListener, long timeoutSeconds, RuntimeException throwOnTimeout) {
            super("Station Shutdown Timeout");
            this.cancelHint = canceledListener;
            this.timeoutSeconds = timeoutSeconds;
            this.throwOnTimeout = throwOnTimeout;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeoutSeconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.isTimedOut = true;
                if (this.cancelHint != null && this.cancelHint instanceof BProvisioningStationExt.CanceledListener) {
                    ((BProvisioningStationExt.CanceledListener)this.cancelHint).setCanceled();
                }
            }
        }

        public boolean isCanceled() {
            if (this.isTimedOut) {
                if (this.throwOnTimeout != null) {
                    throw this.throwOnTimeout;
                }
                return true;
            }
            return this.cancelHint != null && this.cancelHint.isCanceled();
        }
    }
}

