/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.license.BLicenseInstallable;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BIcon;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BUpgradeOutOfDateStep
extends BAbstractSoftwareStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BUpgradeOutOfDateStep.class);
    private static final Version MIN_SMA_VERSION = new Version("4.6");
    private static final BIcon icon = BIcon.std((String)"backup.png");
    static final Logger log = Logger.getLogger("provisioningNiagara");
    static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        boolean scenarioHasConfigDist = false;
        String configDistName = scenario.getTargetPlatform().getConfigDistFileName();
        Version licenseVersion = null;
        block0: for (BInstallable installable : scenario.getToInstall()) {
            if (!scenarioHasConfigDist && BPart.matchesName((String)installable.getInstallableFileName(), (String)configDistName)) {
                scenarioHasConfigDist = true;
            }
            if (!(installable instanceof BLicenseInstallable)) continue;
            for (BEnvLicenseSummary summary : ((BLicenseInstallable)installable).getLicenseSummaries()) {
                if (!summary.getHostId().equals("*") && !summary.getHostId().equals(scenario.getTargetPlatform().getHostId())) continue;
                licenseVersion = summary.getTridiumVersion();
                continue block0;
            }
        }
        if (!scenarioHasConfigDist) {
            BLicenseStationExt licenseExt;
            if (licenseVersion == null && (licenseVersion = (licenseExt = (BLicenseStationExt)details.getDevice().getMixIn(BLicenseStationExt.TYPE)).makeLicenseSummary().getTridiumVersion()) != null) {
                details.message("provisioningNiagara", "UpgradeOutOfDateStep.currentVersion", new String[]{licenseVersion.toString()});
            }
            if (licenseVersion != null) {
                BDistribution configDist = null;
                int configInstallSize = 0;
                IterableCursor c = LocalInstallableRegistry.getInstance().getInstallables(true, null, configDistName);
                BLicenseStationExt licenseExt2 = (BLicenseStationExt)details.getDevice().getMixIn(BLicenseStationExt.TYPE);
                if (licenseExt2.getLicenseStatus() != BLicenseStatus.upToDate) {
                    licenseExt2.makeLicenseSummary();
                }
                BEnvLicenseSummary licenseSummary = licenseExt2.getLicenseSummary();
                VendorLicense[] licenses = AccessController.doPrivileged(() -> {
                    VendorLicense[] lics = LicenseDatabase.LOCAL_INSTANCE.getLicenses(licenseSummary.getHostId(), licenseSummary.getBrandId());
                    return lics;
                });
                while (c.next()) {
                    InstallScenario s;
                    this.checkCanceled(details.getDevice());
                    BDistribution configCand = (BDistribution)c.get();
                    if (!this.acceptDistribution((BInstallable)configCand, details, scenario, licenses, licenseVersion) || !(s = InstallScenario.solve((BDaemonPlatform)scenario.getTargetPlatform(), (DaemonSessionTaskListener)listener, null, null, (BInstallable[])new BInstallable[]{configCand}, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)scenario.getCertValidator())).canCommit()) continue;
                    configDist = configCand;
                    configInstallSize = s.getToInstall().length;
                    break;
                }
                if (configDist != null && (configInstallSize > 1 || configDist.hasFileUpdates(scenario.getTargetPlatform(), null, (ICancelHint)details, listener))) {
                    details.message("provisioningNiagara", "UpgradeOutOfDateStep.configDist.found", new String[]{configDist.toString()});
                    scenario = scenario.solve(listener, null, null, new BInstallable[]{configDist}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                } else {
                    details.message("provisioningNiagara", "UpgradeOutOfDateStep.configDist.notFound");
                }
            }
        }
        return InstallScenario.upgradeOutOfDate((InstallScenario)scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance());
    }

    private boolean acceptDistribution(BInstallable candidate, BDeviceStepDetails details, InstallScenario scenario, VendorLicense[] licenses, Version licenseVersion) {
        for (BDependency configDep : candidate.getAllDependencies()) {
            if (configDep.getPartType() != BNrePart.TYPE) continue;
            boolean isPartInstallable = this.acceptInstallable(candidate, details, scenario, licenses, licenseVersion);
            if (!isPartInstallable) {
                details.message("provisioningNiagara", "UpgradeOutOfDateStep.smaLicenseCheckFailed", new String[]{candidate.getInstallableName()});
                details.message("provisioningNiagara", "UpgradeOutOfDateStep.dependencyInstallWarning");
            }
            return isPartInstallable;
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }
}

