/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="installableFilePath", type="String", defaultValue="", flags=1)
public class BInstallByOrdStep
extends BAbstractSoftwareStep {
    @Generated
    public static final Property installableFilePath = BInstallByOrdStep.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallByOrdStep.class);
    public static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public String getInstallableFilePath() {
        return this.getString(installableFilePath);
    }

    @Generated
    public void setInstallableFilePath(String v) {
        this.setString(installableFilePath, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInstallByOrdStep() {
    }

    public BInstallByOrdStep(BOrd installableOrd) {
        FilePath path;
        OrdQuery[] ordQueries = installableOrd.parse();
        if (ordQueries[ordQueries.length - 1] instanceof FilePath) {
            path = (FilePath)ordQueries[ordQueries.length - 1];
            if (!path.isStationHomeAbsolute() && !path.isProtectedStationHomeAbsolute()) {
                throw new IllegalArgumentException("installableOrd must end with a station-home-absolute or protected-station-home-absolute FilePath");
            }
        } else {
            throw new IllegalArgumentException("installableOrd must end with a station-home-absolute or protected-station-home-absolute FilePath");
        }
        this.setInstallableFilePath(path.getBody());
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        ArrayList<BInstallable> toInstall = new ArrayList<BInstallable>(Arrays.asList(scenario.getToInstall()));
        BIFile installableFile = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.findFile(new FilePath(this.getInstallableFilePath())));
        if (installableFile == null) {
            details.failed("provisioningNiagara", "InstallStep.installableNotFound", this.getInstallableFilePath());
            details.complete(BJobState.failed);
            return scenario;
        }
        AccessController.doPrivileged(() -> {
            toInstall.add(BInstallable.make((BIFile)installableFile));
            return null;
        });
        return new InstallScenario(scenario.getTargetPlatform(), listener, scenario.getModulesToUninstall(), scenario.getUnmetDependencies(), toInstall.toArray(new BInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), scenario.getCertValidator());
    }

    public BIcon getIcon() {
        FilePath path = new FilePath(this.getInstallableFilePath());
        String extension = BajaFileUtil.getExtension((String)path.getName());
        if (extension != null) {
            switch (extension) {
                case "dist": {
                    return BIcon.std((String)"modules.png");
                }
                case "jar": {
                    return BPart.getPartTypeIcon((Type)BModulePart.TYPE);
                }
            }
        }
        return super.getIcon();
    }

    public String toString(Context cx) {
        return LEX.getText("InstallStep.display", new Object[]{this.getInstallableFilePath()});
    }
}

