/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sourceFileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="destinationFileName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="destinationDirPathBody", type="String", defaultValue="!", flags=1), @NiagaraProperty(name="shouldCleanUp", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="isLocalFileCopy", type="boolean", defaultValue="false", flags=5)})
public class BFileCopyStep
extends BAbstractSoftwareStep {
    @Generated
    public static final Property sourceFileOrd = BFileCopyStep.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property destinationFileName = BFileCopyStep.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property destinationDirPathBody = BFileCopyStep.newProperty((int)1, (String)"!", null);
    @Generated
    public static final Property shouldCleanUp = BFileCopyStep.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property isLocalFileCopy = BFileCopyStep.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFileCopyStep.class);
    private BISession fileSession = null;
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.std((String)"file.png");

    @Generated
    public BOrd getSourceFileOrd() {
        return (BOrd)this.get(sourceFileOrd);
    }

    @Generated
    public void setSourceFileOrd(BOrd v) {
        this.set(sourceFileOrd, (BValue)v, null);
    }

    @Generated
    public String getDestinationFileName() {
        return this.getString(destinationFileName);
    }

    @Generated
    public void setDestinationFileName(String v) {
        this.setString(destinationFileName, v, null);
    }

    @Generated
    public String getDestinationDirPathBody() {
        return this.getString(destinationDirPathBody);
    }

    @Generated
    public void setDestinationDirPathBody(String v) {
        this.setString(destinationDirPathBody, v, null);
    }

    @Generated
    public boolean getShouldCleanUp() {
        return this.getBoolean(shouldCleanUp);
    }

    @Generated
    public void setShouldCleanUp(boolean v) {
        this.setBoolean(shouldCleanUp, v, null);
    }

    @Generated
    public boolean getIsLocalFileCopy() {
        return this.getBoolean(isLocalFileCopy);
    }

    @Generated
    public void setIsLocalFileCopy(boolean v) {
        this.setBoolean(isLocalFileCopy, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileCopyStep() {
    }

    public BFileCopyStep(BIFile srcFile, FilePath destDirPath) {
        this.setSourceFileOrd(srcFile.getOrdInSession());
        this.setDestinationFileName(srcFile.getFileName());
        this.setDestinationDirPathBody(destDirPath.getBody());
        this.fileSession = srcFile.getFileSpace().getSession();
    }

    public void prepareStep(BObject target) throws Exception {
        BISession targetSession;
        if (this.fileSession != null && !(targetSession = BOrd.toSession((BObject)target)).equals(this.fileSession)) {
            BIFile from = (BIFile)this.getSourceFileOrd().get((BObject)this.fileSession);
            BBatchJobService batch = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(target);
            BIFile to = batch.makeTempFile(from.getExtension());
            BajaFileUtil.pipe((BIFile)from, (BIFile)to);
            this.setSourceFileOrd(to.getOrdInSession());
            this.setShouldCleanUp(true);
        }
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        BIFile file = (BIFile)this.getSourceFileOrd().get();
        FilePath destDir = SystemFilePaths.translateStationPath((FilePath)new FilePath(this.getDestinationDirPathBody()), (String)details.getDeviceId().toString(), (boolean)scenario.getTargetPlatform().getIsNiagara4());
        ArrayList<BInstallable> toInstall = new ArrayList<BInstallable>(Arrays.asList(scenario.getToInstall()));
        toInstall.add((BInstallable)new BFileInstallable(file, this.getDestinationFileName(), destDir));
        return new InstallScenario(scenario.getTargetPlatform(), listener, scenario.getModulesToUninstall(), scenario.getUnmetDependencies(), toInstall.toArray(new BInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), scenario.getCertValidator());
    }

    @Override
    public void deviceNetworkJobComplete(DeviceNetworkJobOp op) {
        if (this.getShouldCleanUp()) {
            BIFile file = (BIFile)this.getSourceFileOrd().get();
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.deviceNetworkJobComplete(op);
    }

    public BIcon getIcon() {
        try {
            String ext = FileUtil.getExtension((String)this.getDestinationFileName());
            if (ext != null && ext.length() > 0) {
                TypeInfo type = Sys.getRegistry().getFileTypeForExtension(ext);
                BObject file = type.getInstance();
                return file.getIcon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public String toString(Context cx) {
        return lex.getText("FileCopyStep.display", new Object[]{this.getDestinationFileName(), this.getDestinationDirPathBody()});
    }
}

