/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.ui.BulkDeployUtil;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="configPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="alwaysEncrypt", type="BBoolean", defaultValue="BBoolean.FALSE")})
public class BExportApplicationTemplateConfigJobStep
extends BNetworkJobStep {
    @Generated
    public static final Property configPassword = BExportApplicationTemplateConfigJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property alwaysEncrypt = BExportApplicationTemplateConfigJobStep.newProperty((int)0, (boolean)((BBoolean)BBoolean.FALSE.as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExportApplicationTemplateConfigJobStep.class);

    @Generated
    public BPassword getConfigPassword() {
        return (BPassword)this.get(configPassword);
    }

    @Generated
    public void setConfigPassword(BPassword v) {
        this.set(configPassword, (BValue)v, null);
    }

    @Generated
    public boolean getAlwaysEncrypt() {
        return this.getBoolean(alwaysEncrypt);
    }

    @Generated
    public void setAlwaysEncrypt(boolean v) {
        this.setBoolean(alwaysEncrypt, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExportApplicationTemplateConfigJobStep() {
    }

    public BExportApplicationTemplateConfigJobStep(BPassword password, boolean alwaysEncrypt) {
        this.setConfigPassword(password);
        this.setAlwaysEncrypt(alwaysEncrypt);
    }

    /*
     * Unable to fully structure code
     */
    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) throws Exception {
        templates = new ArrayList<NiagaraTemplate>();
        hasSensitiveData = false;
        for (i = 0; i < devices.length; ++i) {
            this.checkCanceled();
            device = devices[i];
            template = this.getTemplateFromStation(devices[i], details);
            if (template == null) continue;
            hasSensitiveData |= template.hasSensitiveDataConfig();
            templates.add(template);
        }
        if (templates.isEmpty()) {
            details.message("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.noTemplatesFound");
            details.complete(BJobState.success);
            return;
        }
        if (hasSensitiveData) ** GOTO lbl21
        if (this.getAlwaysEncrypt()) {
lbl21:
            // 2 sources

            v0 = BPassword.make((String)AccessController.doPrivileged((PrivilegedAction<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getValue(), ()Ljava/lang/String;)((BPassword)this.getConfigPassword())));
        } else {
            v0 = password = null;
        }
        if (password != null && password.validate("")) {
            details.failed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.passwordRequired");
            details.complete(BJobState.failed);
            this.closeTemplates(templates);
            return;
        }
        dateTime = new SimpleDateFormat("dd-MM-yyyy_HHmmss").format(new Date());
        exportFilePath = new FilePath("^templateCache/" + dateTime + '.' + "xlsx");
        try {
            exportFile = BFileSystem.INSTANCE.makeFile(exportFilePath);
            replyMessage = new StringBuilder();
            bulkDeployUtil = new BulkDeployUtil();
            resultCheck = bulkDeployUtil.exportApplicationTemplateToExcel(exportFile, password, templates, replyMessage);
            if (resultCheck == null) {
                details.message(replyMessage.toString());
                details.failed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.exportFailed");
                details.complete(BJobState.failed);
                BFileSystem.INSTANCE.delete(exportFilePath);
            }
            this.closeTemplates(templates);
        }
        catch (Exception ex) {
            details.failed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.exportFailed");
            details.complete(BJobState.failed);
            this.closeTemplates(templates);
            BFileSystem.INSTANCE.delete(exportFilePath);
        }
    }

    private NiagaraTemplate getTemplateFromStation(BDevice device, BNetworkStepDetails details) {
        BNiagaraStation niagaraStation = (BNiagaraStation)device;
        details.start("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.retrievingTemplateConfig", niagaraStation.getDisplayName(null));
        BFoxSession foxSession = (BFoxSession)BProvisioningNiagaraNetworkExt.getFoxProxySession(niagaraStation);
        try {
            foxSession.engageNoRetry("ExportTemplateConfig");
        }
        catch (Exception ex) {
            details.endFailed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.stationConnectionFailed", new String[]{niagaraStation.getDisplayName(null), ex.getMessage()});
            return null;
        }
        try {
            BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)foxSession);
            try {
                NiagaraTemplate template = NiagaraTemplate.open((BComponent)station);
                details.endSuccess();
                return template;
            }
            catch (Exception ex) {
                details.endFailed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.noTemplate", new String[]{niagaraStation.getDisplayName(null)});
            }
        }
        catch (Exception ex) {
            details.endFailed("provisioningNiagara", "ExportApplicationTemplateConfigJobStep.noTemplate", new String[]{niagaraStation.getDisplayName(null), ex.getMessage()});
        }
        return null;
    }

    private void closeTemplates(List<NiagaraTemplate> templates) {
        for (NiagaraTemplate template : templates) {
            template.close();
            Object var3_3 = null;
        }
    }
}

