/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.license;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.ReloadLicenseModeMessage;
import com.tridium.provisioningNiagara.BPlatformConnection;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public class BConvertToPerpetualLicenseModeJobStep
extends BNetworkJobStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BConvertToPerpetualLicenseModeJobStep.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) throws Exception {
        for (BDevice device : devices) {
            BNiagaraStation station = (BNiagaraStation)device;
            BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            details.start("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.starting", new String[]{station.getDisplayName(null)});
            this.checkCanceled();
            if (platformConn.isUnoperational()) {
                details.endFailed("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.platformConnUnoperational", new String[]{station.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
                continue;
            }
            BDaemonSession pDaemonSession = platformConn.getDaemonSession();
            if (pDaemonSession == null) {
                details.endFailed("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.daemonSessionUnavailable", new String[]{station.getDisplayName(null)});
                continue;
            }
            if (pDaemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual()) {
                details.endFailed("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.licenseModePerpetual", new String[]{station.getDisplayName(null)});
                continue;
            }
            if (pDaemonSession.getHostProperties().getRequireSubscription()) {
                details.endFailed("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.requiredSubscriptionLicensing", new String[]{station.getDisplayName(null)});
                continue;
            }
            this.checkCanceled();
            FilePath licensePropertiesFilePath = SystemFilePaths.getLicensePropertiesPath((boolean)pDaemonSession.getHostProperties().getIsNiagaraHomeReadonly());
            BIFile licensePropertiesFile = pDaemonSession.getFileSpace().findFile(licensePropertiesFilePath);
            if (licensePropertiesFile != null) {
                DaemonFileUtil.deleteFile((BIFile)licensePropertiesFile);
                details.message("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.deleteMessage", licensePropertiesFile.getFileName());
            }
            boolean isNiagaraHomeReadonly = pDaemonSession.getHostProperties().getIsNiagaraHomeReadonly();
            BIFile subscriptionDirectory = pDaemonSession.getFileSpace().findFile(SystemFilePaths.getSubscriptionDirPath((boolean)isNiagaraHomeReadonly));
            if (subscriptionDirectory != null) {
                DaemonFileUtil.deleteFile((BIFile)subscriptionDirectory);
                details.message("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.deleteMessage", subscriptionDirectory.getFileName());
            }
            this.checkCanceled();
            pDaemonSession.sendMessage((DaemonMessage)new ReloadLicenseModeMessage());
            details.message("provisioningNiagara", "ConvertToPerpetualLicenseModeJobStep.reloadLicenseMode");
            details.success();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

