/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperty(name="username", type="String", defaultValue="BString.DEFAULT")
public class BRemovePlatformUserJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property username = BRemovePlatformUserJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRemovePlatformUserJobStep.class);
    public static Logger log = Logger.getLogger("provisioning.removePlatformUser");
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRemovePlatformUserJobStep() {
    }

    public BRemovePlatformUserJobStep(String username) {
        this.setUsername(username);
    }

    private static boolean accountManagementEnabled(ProvisioningConnectionUtil util) {
        BDaemonSession daemonSession;
        try {
            daemonSession = util.getDaemonSession();
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
        BHostProperties hostProperties = daemonSession.getHostProperties();
        return hostProperties.isNiagara4() && hostProperties.supportsServlet("acctmgt");
    }

    private static boolean isAuthReadOnly(ProvisioningConnectionUtil util) throws LocalizableException {
        XElem authenticationInfo;
        try {
            authenticationInfo = util.getDaemonResponse((DaemonMessage)new CheckAuthenticationReadonlyMessage());
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
        XElem authElem = authenticationInfo.elem("auth");
        if (authElem == null) {
            throw new LocalizableException(lex, "RemovePlatformUserJobStep.noAuthInfo");
        }
        return authElem.getb("readonly", false);
    }

    private static void removeUser(String username, ProvisioningConnectionUtil util) throws LocalizableException {
        XElem accountInfo;
        XElem authInfoElem;
        BDaemonSession daemonSession;
        try {
            daemonSession = util.getDaemonSession();
            authInfoElem = util.getDaemonResponse((DaemonMessage)new AuthenticationInfoMessage(false));
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
        XElem authElem = authInfoElem.elem("auth");
        if (authElem == null) {
            throw new LocalizableException(lex, "RemovePlatformUserJobStep.noAuthInfo");
        }
        XElem adminGroupElem = authElem.elem("admingroup");
        GroupAccount adminGroupAccount = new GroupAccount(adminGroupElem.get("name"), adminGroupElem.get("id"));
        boolean userNameIsQualified = NativeAccount.isAccountNameFullyQualified((String)username);
        UserAccount userToDelete = null;
        try {
            accountInfo = util.getDaemonResponse((DaemonMessage)new AccountManagementMessage());
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
        block6: for (XElem group : accountInfo.elems("group")) {
            for (XElem user : group.elems("user")) {
                UserAccount existingUser = new UserAccount(user.get("name"), user.get("id", null), user.get("description", null), null);
                if ((!userNameIsQualified || !username.equals(existingUser.getFullyQualifiedName())) && (userNameIsQualified || !username.equals(existingUser.getAccountName()))) continue;
                if ("false".equals(user.get("canModify", "false"))) {
                    throw new IllegalArgumentException(String.format(lex.get("RemovePlatformUserJobStep.readOnly"), username));
                }
                userToDelete = existingUser;
                if (!userToDelete.getAccountName().equals(NativeAccount.fullyQualifiedToUsername((String)((BIUserCredentials)daemonSession.getCredentials()).getUsername()))) continue block6;
                throw new IllegalArgumentException(lex.get("RemovePlatformUserJobStep.sameUser"));
            }
        }
        if (userToDelete == null) {
            throw new IllegalArgumentException(String.format(lex.get("RemovePlatformUserJobStep.notFound"), username));
        }
        try {
            if (!util.sendDaemonMessage((DaemonMessage)new DeleteMemberMessage(adminGroupAccount, userToDelete))) {
                throw new BajaRuntimeException(String.format(lex.get("RemovePlatformUserJobStep.notDeleted"), username));
            }
            if (!util.sendDaemonMessage((DaemonMessage)new DeleteUserMessage(userToDelete))) {
                throw new BajaRuntimeException(String.format(lex.get("RemovePlatformUserJobStep.notDeleted"), username));
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static void handleErrorLex(BDeviceStepDetails details, String key) {
        log.warning(lex.getText(key));
        details.failed("provisioningNiagara", key);
        details.complete(BJobState.failed);
    }

    private static void handleError(BDeviceStepDetails details, String text) {
        if (text != null) {
            log.warning(text);
            details.log().failed(text);
            details.getJob().log().failed(text);
        } else {
            String errorMessage = lex.getText("RemovePlatformUserJobStep.unspecifiedErrorOccurred");
            log.warning(errorMessage);
            details.log().failed(errorMessage);
            details.getJob().log().failed(errorMessage);
        }
        details.complete(BJobState.failed);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            if (!BRemovePlatformUserJobStep.accountManagementEnabled(util)) {
                throw new LocalizableException(lex, "RemovePlatformUserJobStep.acctMgmtNotSupported");
            }
            if (BRemovePlatformUserJobStep.isAuthReadOnly(util)) {
                throw new LocalizableException(lex, "RemovePlatformUserJobStep.authReadOnly");
            }
            BRemovePlatformUserJobStep.removeUser(this.getUsername(), util);
            details.success();
        }
        catch (LocalizableException ex) {
            BRemovePlatformUserJobStep.handleErrorLex(details, ex.getLexiconKey());
        }
        catch (Exception ex) {
            BRemovePlatformUserJobStep.handleError(details, ex.getMessage());
        }
    }

    public String toString(Context context) {
        return super.toString(context) + " (" + this.getUsername() + ')';
    }
}

