/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.nd.BNiagaraStation;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEnableBootstrapStep
extends BNetworkJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BEnableBootstrapStep.class);
    private static final String BOOTSTRAPPED_STATIONS_KEY = "bootstrappedStations";
    private static final Logger logger = Logger.getLogger(BEnableBootstrapStep.class.getPackage().getName());

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEnableBootstrapStep() {
        logger.finest("BDiscoverDevicesStep() called");
    }

    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) {
        logger.finest("Entering doRun()");
        for (BDevice device : devices) {
            BNiagaraStation station = (BNiagaraStation)device;
            station.setBootstrap(true);
            Set<BNiagaraStation> stations = this.getBootstrappedStationList((BatchJobOp)op);
            stations.add(station);
            logger.info(() -> this.lexValue("bootstrapEnabled", new Object[]{station.getStationName()}));
            details.vaSuccess(this.lexKey("bootstrapEnabled"), new String[]{station.getStationName()});
        }
        details.success();
        logger.finest("Exiting doRun()");
    }

    private Set<BNiagaraStation> getBootstrappedStationList(BatchJobOp op) {
        HashSet stations = (HashSet)op.getAttribute((Object)BOOTSTRAPPED_STATIONS_KEY);
        if (stations == null) {
            stations = new HashSet();
            op.setAttribute((Object)BOOTSTRAPPED_STATIONS_KEY, stations);
        }
        return stations;
    }

    public void jobComplete(BatchJobOp op) {
        for (BNiagaraStation station : this.getBootstrappedStationList(op)) {
            logger.info(() -> this.lexValue("bootstrapDisabled", new Object[]{station.getStationName()}));
            station.setBootstrap(false);
        }
        op.removeAttribute((Object)BOOTSTRAPPED_STATIONS_KEY);
    }
}

